/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.serder.PlanGsonHelper;
import org.apache.tajo.plan.util.PlannerUtil;
import org.apache.tajo.util.TUtil;

public abstract class LogicalNode
implements Cloneable,
GsonObject {
    @Expose
    private int nodeId;
    @Expose
    private NodeType type;
    @Expose
    private Schema inputSchema;
    @Expose
    private Schema outputSchema;
    @Expose
    private double cost = 0.0;

    protected LogicalNode(int nodeId, NodeType type) {
        this.nodeId = nodeId;
        this.type = type;
    }

    public int getPID() {
        return this.nodeId;
    }

    public void setPID(int pid) {
        this.nodeId = pid;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public abstract int childNum();

    public abstract LogicalNode getChild(int var1);

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setInSchema(Schema inSchema) {
        this.inputSchema = inSchema;
    }

    public Schema getInSchema() {
        return this.inputSchema;
    }

    public void setOutSchema(Schema outSchema) {
        this.outputSchema = outSchema;
    }

    public Schema getOutSchema() {
        return this.outputSchema;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogicalNode) {
            LogicalNode other = (LogicalNode)obj;
            boolean eq = this.type == other.type;
            eq = eq && TUtil.checkEquals((Object)this.inputSchema, (Object)other.inputSchema);
            eq = eq && TUtil.checkEquals((Object)this.outputSchema, (Object)other.outputSchema);
            eq = eq && this.cost == other.cost;
            return eq;
        }
        return false;
    }

    public boolean deepEquals(Object o) {
        return this.equals(o);
    }

    public Object clone() throws CloneNotSupportedException {
        LogicalNode node = (LogicalNode)super.clone();
        node.nodeId = this.nodeId;
        node.type = this.type;
        node.inputSchema = (Schema)(this.inputSchema != null ? this.inputSchema.clone() : null);
        node.outputSchema = (Schema)(this.outputSchema != null ? this.outputSchema.clone() : null);
        return node;
    }

    public String toJson() {
        return PlanGsonHelper.toJson(this, LogicalNode.class);
    }

    public abstract void preOrder(LogicalNodeVisitor var1);

    public abstract void postOrder(LogicalNodeVisitor var1);

    public abstract PlanString getPlanString();

    public String toString() {
        return PlannerUtil.buildExplainString(this);
    }
}

