/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.logical;

import com.google.common.base.Objects;
import com.google.gson.annotations.Expose;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.plan.PlanString;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.util.PlannerUtil;

public class TableSubQueryNode
extends RelationNode
implements Projectable {
    @Expose
    private String tableName;
    @Expose
    private LogicalNode subQuery;
    @Expose
    private Target[] targets;

    public TableSubQueryNode(int pid) {
        super(pid, NodeType.TABLE_SUBQUERY);
    }

    @Override
    public int childNum() {
        return 1;
    }

    @Override
    public LogicalNode getChild(int idx) {
        return this.subQuery;
    }

    public void init(String tableName, LogicalNode subQuery) {
        this.tableName = tableName;
        if (subQuery != null) {
            this.subQuery = subQuery;
            this.setOutSchema(SchemaUtil.clone((Schema)this.subQuery.getOutSchema()));
            this.setInSchema(SchemaUtil.clone((Schema)this.subQuery.getOutSchema()));
            this.getInSchema().setQualifier(this.tableName);
            this.getOutSchema().setQualifier(this.tableName);
        }
    }

    @Override
    public boolean hasAlias() {
        return false;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getCanonicalName() {
        return this.tableName;
    }

    @Override
    public Schema getLogicalSchema() {
        return this.getInSchema();
    }

    public void setSubQuery(LogicalNode node) {
        this.subQuery = node;
        this.setInSchema(SchemaUtil.clone((Schema)this.subQuery.getOutSchema()));
        this.getInSchema().setQualifier(this.tableName);
        if (this.hasTargets()) {
            this.setOutSchema(PlannerUtil.targetToSchema(this.targets));
        } else {
            this.setOutSchema(SchemaUtil.clone((Schema)this.subQuery.getOutSchema()));
        }
    }

    public LogicalNode getSubQuery() {
        return this.subQuery;
    }

    @Override
    public boolean hasTargets() {
        return this.targets != null;
    }

    @Override
    public void setTargets(Target[] targets) {
        this.targets = targets;
        this.setOutSchema(PlannerUtil.targetToSchema(targets));
    }

    @Override
    public Target[] getTargets() {
        return this.targets;
    }

    @Override
    public PlanString getPlanString() {
        PlanString planStr = new PlanString(this);
        planStr.appendTitle(" as ").appendTitle(this.tableName);
        if (this.hasTargets()) {
            StringBuilder sb = new StringBuilder("Targets: ");
            for (int i = 0; i < this.targets.length; ++i) {
                sb.append(this.targets[i]);
                if (i >= this.targets.length - 1) continue;
                sb.append(", ");
            }
            planStr.addExplan(sb.toString());
            if (this.getOutSchema() != null) {
                planStr.addExplan("out schema: " + this.getOutSchema().toString());
            }
            if (this.getInSchema() != null) {
                planStr.addExplan("in  schema: " + this.getInSchema().toString());
            }
        }
        return planStr;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableName, this.subQuery});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TableSubQueryNode) {
            TableSubQueryNode another = (TableSubQueryNode)object;
            return this.tableName.equals(another.tableName) && this.subQuery.equals(another.subQuery);
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TableSubQueryNode newTableSubQueryNode = (TableSubQueryNode)super.clone();
        newTableSubQueryNode.tableName = this.tableName;
        newTableSubQueryNode.subQuery = (LogicalNode)this.subQuery.clone();
        if (this.hasTargets()) {
            newTableSubQueryNode.targets = new Target[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                newTableSubQueryNode.targets[i] = (Target)this.targets[i].clone();
            }
        }
        return newTableSubQueryNode;
    }

    @Override
    public void preOrder(LogicalNodeVisitor visitor) {
        visitor.visit(this);
        this.subQuery.preOrder(visitor);
    }

    @Override
    public void postOrder(LogicalNodeVisitor visitor) {
        this.subQuery.preOrder(visitor);
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "Inline view (name=" + this.tableName + ")";
    }
}

