/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.nameresolver;

import java.util.List;
import org.apache.tajo.algebra.ColumnReferenceExpr;
import org.apache.tajo.catalog.CatalogUtil;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.NoSuchColumnException;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.nameresolver.NameResolver;
import org.apache.tajo.plan.nameresolver.NameResolvingMode;
import org.apache.tajo.util.Pair;
import org.apache.tajo.util.TUtil;

public class ResolverByLegacy
extends NameResolver {
    @Override
    public Column resolve(LogicalPlan plan, LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws PlanningException {
        if (columnRef.hasQualifier()) {
            return ResolverByLegacy.resolveColumnWithQualifier(plan, block, columnRef);
        }
        return ResolverByLegacy.resolveColumnWithoutQualifier(plan, block, columnRef);
    }

    private static Column resolveColumnWithQualifier(LogicalPlan plan, LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws PlanningException {
        Pair<String, String> normalized = ResolverByLegacy.normalizeQualifierAndCanonicalName(block, columnRef);
        String qualifier = (String)normalized.getFirst();
        String canonicalName = (String)normalized.getSecond();
        String qualifiedName = CatalogUtil.buildFQName((String[])new String[]{qualifier, columnRef.getName()});
        Column found = ResolverByLegacy.resolveFromRelsWithinBlock(plan, block, columnRef);
        if (found == null) {
            throw new NoSuchColumnException(columnRef.getCanonicalName());
        }
        Object currentNode = block.getCurrentNode();
        Schema currentNodeSchema = null;
        if (currentNode != null) {
            currentNodeSchema = currentNode instanceof RelationNode ? ((RelationNode)currentNode).getLogicalSchema() : ((LogicalNode)currentNode).getInSchema();
        }
        if (currentNode != null && !currentNodeSchema.contains(found) && ((LogicalNode)currentNode).getType() != NodeType.TABLE_SUBQUERY) {
            String alias;
            List candidates = TUtil.newList();
            if (block.getNamedExprsManager().isAliased(qualifiedName) && (found = ResolverByLegacy.resolve(plan, block, new ColumnReferenceExpr(alias = block.getNamedExprsManager().getAlias(canonicalName)), NameResolvingMode.LEGACY)) != null) {
                candidates.add(found);
            }
            if (!candidates.isEmpty()) {
                return ResolverByLegacy.ensureUniqueColumn(candidates);
            }
        }
        return found;
    }

    static Column resolveColumnWithoutQualifier(LogicalPlan plan, LogicalPlan.QueryBlock block, ColumnReferenceExpr columnRef) throws PlanningException {
        Column found = ResolverByLegacy.resolveFromAllRelsInBlock(block, columnRef);
        if (found != null) {
            return found;
        }
        found = ResolverByLegacy.resolveAliasedName(block, columnRef);
        if (found != null) {
            return found;
        }
        found = ResolverByLegacy.resolveFromCurrentAndChildNode(block, columnRef);
        if (found != null) {
            return found;
        }
        found = ResolverByLegacy.resolveFromAllRelsInAllBlocks(plan, columnRef);
        if (found != null) {
            return found;
        }
        throw new NoSuchColumnException("ERROR: no such a column name " + columnRef.getCanonicalName());
    }
}

