/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.serder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.algebra.WindowSpec;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.FunctionDesc;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.catalog.exception.NoSuchFunctionException;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.exception.InternalException;
import org.apache.tajo.function.Function;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BetweenPredicateEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.CaseWhenEval;
import org.apache.tajo.plan.expr.CastEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.expr.GeneralFunctionEval;
import org.apache.tajo.plan.expr.InEval;
import org.apache.tajo.plan.expr.IsNullEval;
import org.apache.tajo.plan.expr.LikePredicateEval;
import org.apache.tajo.plan.expr.NotEval;
import org.apache.tajo.plan.expr.RegexPredicateEval;
import org.apache.tajo.plan.expr.RowConstantEval;
import org.apache.tajo.plan.expr.SignedEval;
import org.apache.tajo.plan.expr.SimilarToPredicateEval;
import org.apache.tajo.plan.expr.WindowFunctionEval;
import org.apache.tajo.plan.function.AggFunction;
import org.apache.tajo.plan.function.GeneralFunction;
import org.apache.tajo.plan.logical.WindowSpec;
import org.apache.tajo.plan.serder.LogicalNodeDeserializer;
import org.apache.tajo.plan.serder.PlanProto;

public class EvalNodeDeserializer {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EvalNode deserialize(OverridableConf context, PlanProto.EvalNodeTree tree) {
        void var4_5;
        HashMap evalNodeMap = Maps.newHashMap();
        ArrayList nodeList = Lists.newArrayList(tree.getNodesList());
        Collections.sort(nodeList, new Comparator<PlanProto.EvalNode>(){

            @Override
            public int compare(PlanProto.EvalNode o1, PlanProto.EvalNode o2) {
                return o1.getId() - o2.getId();
            }
        });
        Object var4_4 = null;
        for (PlanProto.EvalNode protoNode : nodeList) {
            EvalType type = EvalType.valueOf(protoNode.getType().name());
            if (EvalType.isUnaryOperator(type)) {
                PlanProto.UnaryEval unaryProto = protoNode.getUnary();
                EvalNode child = (EvalNode)evalNodeMap.get(unaryProto.getChildId());
                switch (type) {
                    case NOT: {
                        NotEval notEval = new NotEval(child);
                        break;
                    }
                    case IS_NULL: {
                        IsNullEval isNullEval = new IsNullEval(unaryProto.getNegative(), child);
                        break;
                    }
                    case CAST: {
                        CastEval castEval = new CastEval(context, child, unaryProto.getCastingType());
                        break;
                    }
                    case SIGNED: {
                        SignedEval signedEval = new SignedEval(unaryProto.getNegative(), child);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown EvalType: " + type.name());
                    }
                }
            } else if (EvalType.isBinaryOperator(type)) {
                PlanProto.BinaryEval binProto = protoNode.getBinary();
                EvalNode lhs = (EvalNode)evalNodeMap.get(binProto.getLhsId());
                EvalNode rhs = (EvalNode)evalNodeMap.get(binProto.getRhsId());
                switch (type) {
                    case IN: {
                        InEval inEval = new InEval(lhs, (RowConstantEval)rhs, binProto.getNegative());
                        break;
                    }
                    case LIKE: {
                        PlanProto.PatternMatchEvalSpec patternMatchProto = protoNode.getPatternMatch();
                        LikePredicateEval likePredicateEval = new LikePredicateEval(binProto.getNegative(), lhs, (ConstEval)rhs, patternMatchProto.getCaseSensitive());
                        break;
                    }
                    case REGEX: {
                        PlanProto.PatternMatchEvalSpec patternMatchProto = protoNode.getPatternMatch();
                        RegexPredicateEval regexPredicateEval = new RegexPredicateEval(binProto.getNegative(), lhs, (ConstEval)rhs, patternMatchProto.getCaseSensitive());
                        break;
                    }
                    case SIMILAR_TO: {
                        PlanProto.PatternMatchEvalSpec patternMatchProto = protoNode.getPatternMatch();
                        SimilarToPredicateEval similarToPredicateEval = new SimilarToPredicateEval(binProto.getNegative(), lhs, (ConstEval)rhs, patternMatchProto.getCaseSensitive());
                        break;
                    }
                    default: {
                        BinaryEval binaryEval = new BinaryEval(type, lhs, rhs);
                        break;
                    }
                }
            } else if (type == EvalType.CONST) {
                PlanProto.ConstEval constProto = protoNode.getConst();
                ConstEval constEval = new ConstEval(EvalNodeDeserializer.deserialize(constProto.getValue()));
            } else if (type == EvalType.ROW_CONSTANT) {
                PlanProto.RowConstEval rowConstProto = protoNode.getRowConst();
                Datum[] values = new Datum[rowConstProto.getValuesCount()];
                for (int i = 0; i < rowConstProto.getValuesCount(); ++i) {
                    values[i] = EvalNodeDeserializer.deserialize(rowConstProto.getValues(i));
                }
                RowConstantEval rowConstantEval = new RowConstantEval(values);
            } else if (type == EvalType.FIELD) {
                CatalogProtos.ColumnProto columnProto = protoNode.getField();
                FieldEval fieldEval = new FieldEval(new Column(columnProto));
            } else if (type == EvalType.BETWEEN) {
                PlanProto.BetweenEval betweenProto = protoNode.getBetween();
                BetweenPredicateEval betweenPredicateEval = new BetweenPredicateEval(betweenProto.getNegative(), betweenProto.getSymmetric(), (EvalNode)evalNodeMap.get(betweenProto.getPredicand()), (EvalNode)evalNodeMap.get(betweenProto.getBegin()), (EvalNode)evalNodeMap.get(betweenProto.getEnd()));
            } else if (type == EvalType.CASE) {
                PlanProto.CaseWhenEval caseWhenProto = protoNode.getCasewhen();
                CaseWhenEval caseWhenEval = new CaseWhenEval();
                for (int i = 0; i < caseWhenProto.getIfCondsCount(); ++i) {
                    caseWhenEval.addIfCond((CaseWhenEval.IfThenEval)evalNodeMap.get(caseWhenProto.getIfConds(i)));
                }
                if (caseWhenProto.hasElse()) {
                    caseWhenEval.setElseResult((EvalNode)evalNodeMap.get(caseWhenProto.getElse()));
                }
                CaseWhenEval caseWhenEval2 = caseWhenEval;
            } else if (type == EvalType.IF_THEN) {
                PlanProto.IfCondEval ifCondProto = protoNode.getIfCond();
                CaseWhenEval.IfThenEval ifThenEval = new CaseWhenEval.IfThenEval((EvalNode)evalNodeMap.get(ifCondProto.getCondition()), (EvalNode)evalNodeMap.get(ifCondProto.getThen()));
            } else {
                if (!EvalType.isFunction(type)) throw new RuntimeException("Unknown EvalType: " + type.name());
                PlanProto.FunctionEval funcProto = protoNode.getFunction();
                EvalNode[] params = new EvalNode[funcProto.getParamIdsCount()];
                for (int i = 0; i < funcProto.getParamIdsCount(); ++i) {
                    params[i] = (EvalNode)evalNodeMap.get(funcProto.getParamIds(i));
                }
                FunctionDesc funcDesc = null;
                try {
                    Function instance;
                    funcDesc = new FunctionDesc(funcProto.getFuncion());
                    if (type == EvalType.FUNCTION) {
                        instance = (GeneralFunction)funcDesc.newInstance();
                        GeneralFunctionEval generalFunctionEval = new GeneralFunctionEval(context, new FunctionDesc(funcProto.getFuncion()), (GeneralFunction)instance, params);
                    } else if (type == EvalType.AGG_FUNCTION || type == EvalType.WINDOW_FUNCTION) {
                        instance = (AggFunction)funcDesc.newInstance();
                        if (type == EvalType.AGG_FUNCTION) {
                            AggregationFunctionCallEval aggFunc = new AggregationFunctionCallEval(new FunctionDesc(funcProto.getFuncion()), (AggFunction)instance, params);
                            PlanProto.AggFunctionEvalSpec aggFunctionProto = protoNode.getAggFunction();
                            aggFunc.setIntermediatePhase(aggFunctionProto.getIntermediatePhase());
                            aggFunc.setFinalPhase(aggFunctionProto.getFinalPhase());
                            if (aggFunctionProto.hasAlias()) {
                                aggFunc.setAlias(aggFunctionProto.getAlias());
                            }
                            AggregationFunctionCallEval aggregationFunctionCallEval = aggFunc;
                        } else {
                            PlanProto.WinFunctionEvalSpec windowFuncProto = protoNode.getWinFunction();
                            WindowFunctionEval winFunc = new WindowFunctionEval(new FunctionDesc(funcProto.getFuncion()), (AggFunction)instance, params, EvalNodeDeserializer.convertWindowFrame(windowFuncProto.getWindowFrame()));
                            if (windowFuncProto.getSortSpecCount() > 0) {
                                SortSpec[] sortSpecs = LogicalNodeDeserializer.convertSortSpecs(windowFuncProto.getSortSpecList());
                                winFunc.setSortSpecs(sortSpecs);
                            }
                            WindowFunctionEval windowFunctionEval = winFunc;
                        }
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new NoSuchFunctionException(funcDesc.getFunctionName(), funcDesc.getParamTypes());
                }
                catch (InternalException ie) {
                    throw new NoSuchFunctionException(funcDesc.getFunctionName(), funcDesc.getParamTypes());
                }
            }
            evalNodeMap.put(protoNode.getId(), var4_5);
        }
        return var4_5;
    }

    private static WindowSpec.WindowFrame convertWindowFrame(PlanProto.WinFunctionEvalSpec.WindowFrame windowFrame) {
        WindowSpec.WindowFrameStartBoundType startBoundType = EvalNodeDeserializer.convertWindowStartBound(windowFrame.getStartBound().getBoundType());
        WindowSpec.WindowStartBound startBound = new WindowSpec.WindowStartBound(startBoundType);
        WindowSpec.WindowFrameEndBoundType endBoundType = EvalNodeDeserializer.convertWindowEndBound(windowFrame.getEndBound().getBoundType());
        WindowSpec.WindowEndBound endBound = new WindowSpec.WindowEndBound(endBoundType);
        WindowSpec.WindowFrame frame = new WindowSpec.WindowFrame(startBound, endBound);
        return frame;
    }

    private static WindowSpec.WindowFrameStartBoundType convertWindowStartBound(PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType type) {
        if (type == PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType.S_UNBOUNDED_PRECEDING) {
            return WindowSpec.WindowFrameStartBoundType.UNBOUNDED_PRECEDING;
        }
        if (type == PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType.S_CURRENT_ROW) {
            return WindowSpec.WindowFrameStartBoundType.CURRENT_ROW;
        }
        if (type == PlanProto.WinFunctionEvalSpec.WindowFrameStartBoundType.S_PRECEDING) {
            return WindowSpec.WindowFrameStartBoundType.PRECEDING;
        }
        throw new IllegalStateException("Unknown Window Start Bound type: " + type.name());
    }

    private static WindowSpec.WindowFrameEndBoundType convertWindowEndBound(PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType type) {
        if (type == PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType.E_UNBOUNDED_FOLLOWING) {
            return WindowSpec.WindowFrameEndBoundType.UNBOUNDED_FOLLOWING;
        }
        if (type == PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType.E_CURRENT_ROW) {
            return WindowSpec.WindowFrameEndBoundType.CURRENT_ROW;
        }
        if (type == PlanProto.WinFunctionEvalSpec.WindowFrameEndBoundType.E_FOLLOWING) {
            return WindowSpec.WindowFrameEndBoundType.FOLLOWING;
        }
        throw new IllegalStateException("Unknown Window Start Bound type: " + type.name());
    }

    public static Datum deserialize(PlanProto.Datum datum) {
        switch (datum.getType()) {
            case BOOLEAN: {
                return DatumFactory.createBool((boolean)datum.getBoolean());
            }
            case CHAR: {
                return DatumFactory.createChar((String)datum.getText());
            }
            case INT1: 
            case INT2: {
                return DatumFactory.createInt2((short)((short)datum.getInt4()));
            }
            case INT4: {
                return DatumFactory.createInt4((int)datum.getInt4());
            }
            case INT8: {
                return DatumFactory.createInt8((long)datum.getInt8());
            }
            case FLOAT4: {
                return DatumFactory.createFloat4((float)datum.getFloat4());
            }
            case FLOAT8: {
                return DatumFactory.createFloat8((double)datum.getFloat8());
            }
            case VARCHAR: 
            case TEXT: {
                return DatumFactory.createText((String)datum.getText());
            }
            case TIMESTAMP: {
                return new TimestampDatum(datum.getInt8());
            }
            case DATE: {
                return DatumFactory.createDate((int)datum.getInt4());
            }
            case TIME: {
                return DatumFactory.createTime((long)datum.getInt8());
            }
            case BINARY: 
            case BLOB: {
                return DatumFactory.createBlob((byte[])datum.getBlob().toByteArray());
            }
            case INTERVAL: {
                return new IntervalDatum(datum.getInterval().getMonth(), datum.getInterval().getMsec());
            }
            case NULL_TYPE: {
                return NullDatum.get();
            }
        }
        throw new RuntimeException("Unknown data type: " + datum.getType().name());
    }
}

