/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.serder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.fs.Path;
import org.apache.tajo.catalog.TableMeta;
import org.apache.tajo.catalog.json.FunctionAdapter;
import org.apache.tajo.catalog.json.TableMetaAdapter;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.function.Function;
import org.apache.tajo.json.ClassNameSerializer;
import org.apache.tajo.json.DataTypeAdapter;
import org.apache.tajo.json.DatumAdapter;
import org.apache.tajo.json.GsonHelper;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.json.GsonSerDerAdapter;
import org.apache.tajo.json.PathSerializer;
import org.apache.tajo.json.TimeZoneGsonSerdeAdapter;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.function.AggFunction;
import org.apache.tajo.plan.function.GeneralFunction;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.serder.EvalNodeAdapter;
import org.apache.tajo.plan.serder.LogicalNodeAdapter;
import org.apache.tajo.util.TUtil;

public class PlanGsonHelper {
    private static Gson gson;
    private static Gson gsonPretty;

    private PlanGsonHelper() {
    }

    private static Map<Type, GsonSerDerAdapter> registerAdapters() {
        Map adapters = TUtil.newHashMap();
        adapters.put(Path.class, new PathSerializer());
        adapters.put(Class.class, new ClassNameSerializer());
        adapters.put(LogicalNode.class, new LogicalNodeAdapter());
        adapters.put(EvalNode.class, new EvalNodeAdapter());
        adapters.put(TableMeta.class, new TableMetaAdapter());
        adapters.put(Function.class, new FunctionAdapter());
        adapters.put(GeneralFunction.class, new FunctionAdapter());
        adapters.put(AggFunction.class, new FunctionAdapter());
        adapters.put(Datum.class, new DatumAdapter());
        adapters.put(TajoDataTypes.DataType.class, new DataTypeAdapter());
        adapters.put(TimeZone.class, new TimeZoneGsonSerdeAdapter());
        return adapters;
    }

    public static Gson getInstance() {
        if (gson == null) {
            GsonHelper helper = new GsonHelper(PlanGsonHelper.registerAdapters());
            gson = helper.getGson();
        }
        return gson;
    }

    public static Gson getPrettyInstance() {
        if (gsonPretty == null) {
            GsonBuilder prettyBuilder = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation();
            GsonHelper.registerAdapters((GsonBuilder)prettyBuilder, PlanGsonHelper.registerAdapters());
            gsonPretty = prettyBuilder.create();
        }
        return gsonPretty;
    }

    public static String toJson(GsonObject object, Class<? extends GsonObject> clazz) {
        return PlanGsonHelper.getInstance().toJson((Object)object, clazz);
    }

    public static <T extends GsonObject> T fromJson(String json, Class<T> clazz) {
        return (T)((GsonObject)PlanGsonHelper.getInstance().fromJson(json, clazz));
    }
}

