/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.OverridableConf;
import org.apache.tajo.SessionVars;
import org.apache.tajo.algebra.CountRowsFunctionExpr;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.JoinType;
import org.apache.tajo.algebra.OpType;
import org.apache.tajo.annotation.Nullable;
import org.apache.tajo.catalog.CatalogService;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.catalog.Schema;
import org.apache.tajo.catalog.SchemaUtil;
import org.apache.tajo.catalog.SortSpec;
import org.apache.tajo.catalog.TableDesc;
import org.apache.tajo.catalog.TableMeta;
import org.apache.tajo.catalog.proto.CatalogProtos;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.plan.InvalidQueryException;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.Target;
import org.apache.tajo.plan.expr.AggregationFunctionCallEval;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalNodeVisitor;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.FieldEval;
import org.apache.tajo.plan.logical.BinaryNode;
import org.apache.tajo.plan.logical.CreateTableNode;
import org.apache.tajo.plan.logical.DistinctGroupbyNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalNodeVisitor;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.NodeType;
import org.apache.tajo.plan.logical.PartitionedTableScanNode;
import org.apache.tajo.plan.logical.Projectable;
import org.apache.tajo.plan.logical.RelationNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.UnaryNode;
import org.apache.tajo.plan.visitor.BasicLogicalPlanVisitor;
import org.apache.tajo.plan.visitor.ExplainLogicalPlanVisitor;
import org.apache.tajo.plan.visitor.SimpleAlgebraVisitor;
import org.apache.tajo.util.KeyValueSet;
import org.apache.tajo.util.TUtil;

public class PlannerUtil {
    public static final Column[] EMPTY_COLUMNS = new Column[0];
    public static final AggregationFunctionCallEval[] EMPTY_AGG_FUNCS = new AggregationFunctionCallEval[0];

    public static boolean checkIfSetSession(LogicalNode node) {
        LogicalNode baseNode = node;
        if (node instanceof LogicalRootNode) {
            baseNode = ((LogicalRootNode)node).getChild();
        }
        return baseNode.getType() == NodeType.SET_SESSION;
    }

    public static boolean checkIfDDLPlan(LogicalNode node) {
        NodeType type;
        LogicalNode baseNode = node;
        if (node instanceof LogicalRootNode) {
            baseNode = ((LogicalRootNode)node).getChild();
        }
        return (type = baseNode.getType()) == NodeType.CREATE_DATABASE || type == NodeType.DROP_DATABASE || type == NodeType.CREATE_TABLE && !((CreateTableNode)baseNode).hasSubQuery() || baseNode.getType() == NodeType.DROP_TABLE || baseNode.getType() == NodeType.ALTER_TABLESPACE || baseNode.getType() == NodeType.ALTER_TABLE || baseNode.getType() == NodeType.TRUNCATE_TABLE;
    }

    public static boolean checkIfSimpleQuery(LogicalPlan plan) {
        LogicalRootNode rootNode = (LogicalRootNode)plan.getRootBlock().getRoot();
        boolean isOneQueryBlock = plan.getQueryBlocks().size() == 1;
        boolean simpleOperator = ((LogicalNode)rootNode.getChild()).getType() == NodeType.LIMIT || ((LogicalNode)rootNode.getChild()).getType() == NodeType.SCAN || ((LogicalNode)rootNode.getChild()).getType() == NodeType.PARTITIONS_SCAN;
        boolean noOrderBy = !plan.getRootBlock().hasNode(NodeType.SORT);
        boolean noGroupBy = !plan.getRootBlock().hasNode(NodeType.GROUP_BY);
        boolean noWhere = !plan.getRootBlock().hasNode(NodeType.SELECTION);
        boolean noJoin = !plan.getRootBlock().hasNode(NodeType.JOIN);
        boolean singleRelation = (plan.getRootBlock().hasNode(NodeType.SCAN) || plan.getRootBlock().hasNode(NodeType.PARTITIONS_SCAN)) && PlannerUtil.getRelationLineage(plan.getRootBlock().getRoot()).length == 1;
        boolean noComplexComputation = false;
        if (singleRelation) {
            ScanNode scanNode = (ScanNode)plan.getRootBlock().getNode(NodeType.SCAN);
            if (scanNode == null) {
                scanNode = (ScanNode)plan.getRootBlock().getNode(NodeType.PARTITIONS_SCAN);
            }
            if (scanNode.hasTargets()) {
                if (scanNode.getTableDesc().hasPartition()) {
                    int numPartitionColumns = scanNode.getTableDesc().getPartitionMethod().getExpressionSchema().size();
                    if (scanNode.getTargets().length != scanNode.getInSchema().size() + numPartitionColumns) {
                        return false;
                    }
                } else if (scanNode.getTargets().length != scanNode.getInSchema().size()) {
                    return false;
                }
                noComplexComputation = true;
                for (int i = 0; i < scanNode.getTargets().length; ++i) {
                    boolean bl = noComplexComputation = noComplexComputation && ((EvalNode)scanNode.getTargets()[i].getEvalTree()).getType() == EvalType.FIELD;
                    if (noComplexComputation) {
                        boolean bl2 = noComplexComputation = noComplexComputation && scanNode.getTargets()[i].getNamedColumn().equals((Object)scanNode.getTableDesc().getLogicalSchema().getColumn(i));
                    }
                    if (noComplexComputation) continue;
                    return noComplexComputation;
                }
            }
        }
        return !PlannerUtil.checkIfDDLPlan(rootNode) && simpleOperator && noComplexComputation && isOneQueryBlock && noOrderBy && noGroupBy && noWhere && noJoin && singleRelation;
    }

    public static boolean checkIfQueryTargetIsVirtualTable(LogicalPlan plan) {
        LogicalRootNode rootNode = (LogicalRootNode)plan.getRootBlock().getRoot();
        boolean hasScanNode = plan.getRootBlock().hasNode(NodeType.SCAN);
        LogicalNode[] scanNodes = PlannerUtil.findAllNodes(rootNode, NodeType.SCAN);
        boolean isVirtualTable = scanNodes.length > 0;
        ScanNode scanNode = null;
        for (LogicalNode node : scanNodes) {
            scanNode = (ScanNode)node;
            isVirtualTable &= scanNode.getTableDesc().getMeta().getStoreType() == CatalogProtos.StoreType.SYSTEM;
        }
        return !PlannerUtil.checkIfDDLPlan(rootNode) && hasScanNode && isVirtualTable;
    }

    public static boolean checkIfNonFromQuery(LogicalPlan plan) {
        Object node = plan.getRootBlock().getRoot();
        boolean isOneQueryBlock = plan.getQueryBlocks().size() == 1;
        boolean noRelation = !plan.getRootBlock().hasAlgebraicExpr(OpType.Relation);
        return !PlannerUtil.checkIfDDLPlan(node) && noRelation && isOneQueryBlock;
    }

    public static String[] getRelationLineage(LogicalNode from) {
        LogicalNode[] scans = PlannerUtil.findAllNodes(from, NodeType.SCAN, NodeType.PARTITIONS_SCAN);
        String[] tableNames = new String[scans.length];
        for (int i = 0; i < scans.length; ++i) {
            ScanNode scan = (ScanNode)scans[i];
            tableNames[i] = scan.getCanonicalName();
        }
        return tableNames;
    }

    public static Collection<String> getRelationLineageWithinQueryBlock(LogicalPlan plan, LogicalNode from) throws PlanningException {
        RelationFinderVisitor visitor = new RelationFinderVisitor();
        visitor.visit((Object)null, plan, (LogicalPlan.QueryBlock)null, from, new Stack());
        return visitor.getFoundRelations();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogicalNode deleteNode(LogicalNode parent, LogicalNode tobeRemoved) {
        Preconditions.checkArgument((boolean)(tobeRemoved instanceof UnaryNode), (Object)"ERROR: the logical node to be removed must be unary node.");
        UnaryNode child = (UnaryNode)tobeRemoved;
        Object grandChild = child.getChild();
        if (parent instanceof UnaryNode) {
            UnaryNode unaryParent = (UnaryNode)parent;
            Preconditions.checkArgument((unaryParent.getChild() == child ? 1 : 0) != 0, (Object)"ERROR: both logical node must be parent and child nodes");
            unaryParent.setChild((LogicalNode)grandChild);
            return child;
        } else {
            if (!(parent instanceof BinaryNode)) throw new InvalidQueryException("Unexpected logical plan: " + parent);
            BinaryNode binaryParent = (BinaryNode)parent;
            if (((LogicalNode)binaryParent.getLeftChild()).deepEquals(child)) {
                binaryParent.setLeftChild((LogicalNode)grandChild);
                return child;
            } else {
                if (!((LogicalNode)binaryParent.getRightChild()).deepEquals(child)) throw new IllegalStateException("ERROR: both logical node must be parent and child nodes");
                binaryParent.setRightChild((LogicalNode)grandChild);
            }
        }
        return child;
    }

    public static void replaceNode(LogicalPlan plan, LogicalNode startNode, LogicalNode oldNode, LogicalNode newNode) {
        LogicalNodeReplaceVisitor replacer = new LogicalNodeReplaceVisitor(oldNode, newNode);
        try {
            replacer.visit(new ReplacerContext(), plan, (LogicalPlan.QueryBlock)null, startNode, new Stack<LogicalNode>());
        }
        catch (PlanningException e) {
            e.printStackTrace();
        }
    }

    public static void replaceNode(LogicalNode plan, LogicalNode newNode, NodeType type) {
        Object parent = PlannerUtil.findTopParentNode(plan, type);
        Preconditions.checkArgument((boolean)(parent instanceof UnaryNode));
        Preconditions.checkArgument((!(newNode instanceof BinaryNode) ? 1 : 0) != 0);
        UnaryNode parentNode = (UnaryNode)parent;
        Object child = parentNode.getChild();
        if (child instanceof UnaryNode) {
            ((UnaryNode)newNode).setChild((LogicalNode)((UnaryNode)child).getChild());
        }
        parentNode.setChild(newNode);
    }

    public static <T extends LogicalNode> T findTopNode(LogicalNode node, NodeType type) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)((Object)type));
        LogicalNodeFinder finder = new LogicalNodeFinder(type);
        node.preOrder(finder);
        if (finder.getFoundNodes().size() == 0) {
            return null;
        }
        return (T)finder.getFoundNodes().get(0);
    }

    public static <T extends LogicalNode> T findMostBottomNode(LogicalNode node, NodeType type) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)((Object)type));
        LogicalNodeFinder finder = new LogicalNodeFinder(type);
        node.preOrder(finder);
        if (finder.getFoundNodes().size() == 0) {
            return null;
        }
        return (T)finder.getFoundNodes().get(finder.getFoundNodes().size() - 1);
    }

    public static LogicalNode[] findAllNodes(LogicalNode node, NodeType ... type) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)type);
        LogicalNodeFinder finder = new LogicalNodeFinder(type);
        node.postOrder(finder);
        if (finder.getFoundNodes().size() == 0) {
            return new LogicalNode[0];
        }
        List<LogicalNode> founds = finder.getFoundNodes();
        return founds.toArray(new LogicalNode[founds.size()]);
    }

    public static <T extends LogicalNode> T findTopParentNode(LogicalNode node, NodeType type) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)((Object)type));
        ParentNodeFinder finder = new ParentNodeFinder(type);
        node.postOrder(finder);
        if (finder.getFoundNodes().size() == 0) {
            return null;
        }
        return (T)finder.getFoundNodes().get(0);
    }

    public static void schemaToTargets(Schema schema, Target[] targets) {
        for (int i = 0; i < schema.size(); ++i) {
            FieldEval eval = new FieldEval(schema.getColumn(i));
            targets[i] = new Target(eval);
        }
    }

    public static Target[] schemaToTargets(Schema schema) {
        Target[] targets = new Target[schema.size()];
        for (int i = 0; i < schema.size(); ++i) {
            FieldEval eval = new FieldEval(schema.getColumn(i));
            targets[i] = new Target(eval);
        }
        return targets;
    }

    public static Target[] schemaToTargetsWithGeneratedFields(Schema schema) {
        List targets = TUtil.newList();
        for (int i = 0; i < schema.size(); ++i) {
            FieldEval eval = new FieldEval(schema.getColumn(i));
            targets.add(new Target(eval));
        }
        return targets.toArray(new Target[targets.size()]);
    }

    public static SortSpec[] schemaToSortSpecs(Schema schema) {
        return PlannerUtil.columnsToSortSpecs(schema.toArray());
    }

    public static SortSpec[] columnsToSortSpecs(Column[] columns) {
        SortSpec[] specs = new SortSpec[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            specs[i] = new SortSpec(columns[i], true, false);
        }
        return specs;
    }

    public static SortSpec[] columnsToSortSpecs(Collection<Column> columns) {
        return PlannerUtil.columnsToSortSpecs(columns.toArray(new Column[columns.size()]));
    }

    public static Schema sortSpecsToSchema(SortSpec[] sortSpecs) {
        Schema schema = new Schema();
        for (SortSpec spec : sortSpecs) {
            schema.addColumn(spec.getSortKey());
        }
        return schema;
    }

    public static SortSpec[][] getSortKeysFromJoinQual(EvalNode joinQual, Schema outer, Schema inner) {
        List<Column[]> joinKeyPairs = PlannerUtil.getJoinKeyPairs(joinQual, outer, inner, false);
        SortSpec[] outerSortSpec = new SortSpec[joinKeyPairs.size()];
        SortSpec[] innerSortSpec = new SortSpec[joinKeyPairs.size()];
        for (int i = 0; i < joinKeyPairs.size(); ++i) {
            outerSortSpec[i] = new SortSpec(joinKeyPairs.get(i)[0]);
            innerSortSpec[i] = new SortSpec(joinKeyPairs.get(i)[1]);
        }
        return new SortSpec[][]{outerSortSpec, innerSortSpec};
    }

    public static Column[][] joinJoinKeyForEachTable(EvalNode joinQual, Schema leftSchema, Schema rightSchema, boolean includeThetaJoin) {
        List<Column[]> joinKeys = PlannerUtil.getJoinKeyPairs(joinQual, leftSchema, rightSchema, includeThetaJoin);
        Column[] leftColumns = new Column[joinKeys.size()];
        Column[] rightColumns = new Column[joinKeys.size()];
        for (int i = 0; i < joinKeys.size(); ++i) {
            leftColumns[i] = joinKeys.get(i)[0];
            rightColumns[i] = joinKeys.get(i)[1];
        }
        return new Column[][]{leftColumns, rightColumns};
    }

    public static List<Column[]> getJoinKeyPairs(EvalNode joinQual, Schema leftSchema, Schema rightSchema, boolean includeThetaJoin) {
        JoinKeyPairFinder finder = new JoinKeyPairFinder(includeThetaJoin, leftSchema, rightSchema);
        joinQual.preOrder(finder);
        return finder.getPairs();
    }

    public static Schema targetToSchema(Collection<Target> targets) {
        return PlannerUtil.targetToSchema(targets.toArray(new Target[targets.size()]));
    }

    public static Schema targetToSchema(Target[] targets) {
        Schema schema = new Schema();
        for (Target t : targets) {
            TajoDataTypes.DataType type = ((EvalNode)t.getEvalTree()).getValueType();
            String name = t.hasAlias() ? t.getAlias() : ((EvalNode)t.getEvalTree()).getName();
            if (schema.containsByQualifiedName(name)) continue;
            schema.addColumn(name, type);
        }
        return schema;
    }

    public static Target[] stripTarget(Target[] sourceTargets) {
        Target[] copy = new Target[sourceTargets.length];
        for (int i = 0; i < sourceTargets.length; ++i) {
            FieldEval fieldEval;
            try {
                copy[i] = (Target)sourceTargets[i].clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.getMessage());
            }
            if (((EvalNode)copy[i].getEvalTree()).getType() != EvalType.FIELD || !(fieldEval = (FieldEval)copy[i].getEvalTree()).getColumnRef().hasQualifier()) continue;
            fieldEval.replaceColumnRef(fieldEval.getColumnName());
        }
        return copy;
    }

    public static <T extends LogicalNode> T clone(LogicalPlan plan, LogicalNode node) {
        try {
            LogicalNode copy = (LogicalNode)node.clone();
            if (plan == null) {
                copy.setPID(-1);
            } else {
                copy.setPID(plan.newPID());
                if (node instanceof DistinctGroupbyNode) {
                    DistinctGroupbyNode dNode = (DistinctGroupbyNode)copy;
                    for (GroupbyNode eachNode : dNode.getSubPlans()) {
                        eachNode.setPID(plan.newPID());
                    }
                }
            }
            return (T)copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCommutativeJoin(JoinType joinType) {
        return joinType == JoinType.INNER;
    }

    public static boolean existsAggregationFunction(Expr expr) throws PlanningException {
        AggregationFunctionFinder finder = new AggregationFunctionFinder();
        AggFunctionFoundResult result = new AggFunctionFoundResult();
        finder.visit(result, new Stack<Expr>(), expr);
        return result.generalSetFunction;
    }

    public static boolean existsDistinctAggregationFunction(Expr expr) throws PlanningException {
        AggregationFunctionFinder finder = new AggregationFunctionFinder();
        AggFunctionFoundResult result = new AggFunctionFoundResult();
        finder.visit(result, new Stack<Expr>(), expr);
        return result.distinctSetFunction;
    }

    public static Collection<String> toQualifiedFieldNames(Collection<String> fieldNames, String qualifier) {
        List names = TUtil.newList();
        for (String n : fieldNames) {
            String[] parts = n.split("\\.");
            if (parts.length == 1) {
                names.add(qualifier + "." + parts[0]);
                continue;
            }
            names.add(qualifier + "." + parts[1]);
        }
        return names;
    }

    public static String buildExplainString(LogicalNode node) {
        ExplainLogicalPlanVisitor explain = new ExplainLogicalPlanVisitor();
        StringBuilder explains = new StringBuilder();
        try {
            ExplainLogicalPlanVisitor.Context explainContext = explain.getBlockPlanStrings(null, node);
            while (!explainContext.explains.empty()) {
                explains.append(ExplainLogicalPlanVisitor.printDepthString(explainContext.getMaxDepth(), explainContext.explains.pop()));
            }
        }
        catch (PlanningException e) {
            throw new RuntimeException(e);
        }
        return explains.toString();
    }

    public static void applySessionToTableProperties(OverridableConf sessionVars, CatalogProtos.StoreType storeType, KeyValueSet tableProperties) {
        if (storeType == CatalogProtos.StoreType.CSV || storeType == CatalogProtos.StoreType.TEXTFILE) {
            if (sessionVars.containsKey((ConfigKey)SessionVars.NULL_CHAR)) {
                tableProperties.set("text.null", sessionVars.get((ConfigKey)SessionVars.NULL_CHAR));
            }
            if (sessionVars.containsKey((ConfigKey)SessionVars.TIMEZONE)) {
                tableProperties.set("timezone", sessionVars.get((ConfigKey)SessionVars.TIMEZONE));
            }
        }
    }

    public static void applySystemDefaultToTableProperties(OverridableConf systemConf, TableMeta meta) {
        if (!meta.containsOption("timezone")) {
            meta.putOption("timezone", systemConf.get((ConfigKey)SessionVars.TIMEZONE));
        }
    }

    public static boolean isFileStorageType(String storageType) {
        return !storageType.equalsIgnoreCase("hbase");
    }

    public static boolean isFileStorageType(CatalogProtos.StoreType storageType) {
        return storageType != CatalogProtos.StoreType.HBASE;
    }

    public static CatalogProtos.StoreType getStoreType(LogicalPlan plan) {
        LogicalRootNode rootNode = (LogicalRootNode)plan.getRootBlock().getRoot();
        NodeType nodeType = ((LogicalNode)rootNode.getChild()).getType();
        if (nodeType == NodeType.CREATE_TABLE) {
            return ((CreateTableNode)rootNode.getChild()).getStorageType();
        }
        if (nodeType == NodeType.INSERT) {
            return ((InsertNode)rootNode.getChild()).getStorageType();
        }
        return null;
    }

    public static String getStoreTableName(LogicalPlan plan) {
        LogicalRootNode rootNode = (LogicalRootNode)plan.getRootBlock().getRoot();
        NodeType nodeType = ((LogicalNode)rootNode.getChild()).getType();
        if (nodeType == NodeType.CREATE_TABLE) {
            return ((CreateTableNode)rootNode.getChild()).getTableName();
        }
        if (nodeType == NodeType.INSERT) {
            return ((InsertNode)rootNode.getChild()).getTableName();
        }
        return null;
    }

    public static TableDesc getTableDesc(CatalogService catalog, LogicalNode node) throws IOException {
        if (node.getType() == NodeType.CREATE_TABLE) {
            return PlannerUtil.createTableDesc((CreateTableNode)node);
        }
        String tableName = null;
        InsertNode insertNode = null;
        if (node.getType() != NodeType.INSERT) {
            return null;
        }
        insertNode = (InsertNode)node;
        tableName = insertNode.getTableName();
        if (tableName != null) {
            String[] tableTokens = tableName.split("\\.");
            if (tableTokens.length >= 2 && catalog.existsTable(tableTokens[0], tableTokens[1])) {
                return catalog.getTableDesc(tableTokens[0], tableTokens[1]);
            }
        } else if (insertNode.getPath() != null) {
            return PlannerUtil.createTableDesc(insertNode);
        }
        return null;
    }

    private static TableDesc createTableDesc(CreateTableNode createTableNode) {
        TableMeta meta = new TableMeta(createTableNode.getStorageType(), createTableNode.getOptions());
        TableDesc tableDescTobeCreated = new TableDesc(createTableNode.getTableName(), createTableNode.getTableSchema(), meta, createTableNode.getPath() != null ? createTableNode.getPath().toUri() : null);
        tableDescTobeCreated.setExternal(createTableNode.isExternal());
        if (createTableNode.hasPartition()) {
            tableDescTobeCreated.setPartitionMethod(createTableNode.getPartitionMethod());
        }
        return tableDescTobeCreated;
    }

    private static TableDesc createTableDesc(InsertNode insertNode) {
        TableMeta meta = new TableMeta(insertNode.getStorageType(), insertNode.getOptions());
        TableDesc tableDescTobeCreated = new TableDesc(insertNode.getTableName(), insertNode.getTableSchema(), meta, insertNode.getPath() != null ? insertNode.getPath().toUri() : null);
        if (insertNode.hasPartition()) {
            tableDescTobeCreated.setPartitionMethod(insertNode.getPartitionMethod());
        }
        return tableDescTobeCreated;
    }

    static class AggregationFunctionFinder
    extends SimpleAlgebraVisitor<AggFunctionFoundResult, Object> {
        AggregationFunctionFinder() {
        }

        @Override
        public Object visitCountRowsFunction(AggFunctionFoundResult ctx, Stack<Expr> stack, CountRowsFunctionExpr expr) throws PlanningException {
            ctx.generalSetFunction = true;
            return super.visitCountRowsFunction(ctx, stack, expr);
        }

        @Override
        public Object visitGeneralSetFunction(AggFunctionFoundResult ctx, Stack<Expr> stack, GeneralSetFunctionExpr expr) throws PlanningException {
            ctx.generalSetFunction = true;
            ctx.distinctSetFunction = expr.isDistinct();
            return super.visitGeneralSetFunction(ctx, stack, expr);
        }
    }

    static class AggFunctionFoundResult {
        boolean generalSetFunction;
        boolean distinctSetFunction;

        AggFunctionFoundResult() {
        }
    }

    public static class JoinKeyPairFinder
    implements EvalNodeVisitor {
        private boolean includeThetaJoin;
        private final List<Column[]> pairs = Lists.newArrayList();
        private Schema[] schemas = new Schema[2];

        public JoinKeyPairFinder(boolean includeThetaJoin, Schema outer, Schema inner) {
            this.includeThetaJoin = includeThetaJoin;
            this.schemas[0] = outer;
            this.schemas[1] = inner;
        }

        @Override
        public void visit(EvalNode node) {
            if (EvalTreeUtil.isJoinQual(null, this.schemas[0], this.schemas[1], node, this.includeThetaJoin)) {
                BinaryEval binaryEval = (BinaryEval)node;
                Column[] pair = new Column[2];
                for (int i = 0; i <= 1; ++i) {
                    Column column = EvalTreeUtil.findAllColumnRefs(binaryEval.getChild(i)).get(0);
                    for (int j = 0; j < this.schemas.length; ++j) {
                        if (!this.schemas[j].contains(column.getQualifiedName())) continue;
                        pair[j] = column;
                    }
                }
                if (pair[0] == null || pair[1] == null) {
                    throw new IllegalStateException("Wrong join key: " + node);
                }
                this.pairs.add(pair);
            }
        }

        public List<Column[]> getPairs() {
            return this.pairs;
        }
    }

    private static class ParentNodeFinder
    implements LogicalNodeVisitor {
        private List<LogicalNode> list = new ArrayList<LogicalNode>();
        private NodeType tofind;

        public ParentNodeFinder(NodeType type) {
            this.tofind = type;
        }

        @Override
        public void visit(LogicalNode node) {
            BinaryNode bin;
            if (node instanceof UnaryNode) {
                UnaryNode unary = (UnaryNode)node;
                if (((LogicalNode)unary.getChild()).getType() == this.tofind) {
                    this.list.add(node);
                }
            } else if (node instanceof BinaryNode && (((LogicalNode)(bin = (BinaryNode)node).getLeftChild()).getType() == this.tofind || ((LogicalNode)bin.getRightChild()).getType() == this.tofind)) {
                this.list.add(node);
            }
        }

        public List<LogicalNode> getFoundNodes() {
            return this.list;
        }
    }

    private static class LogicalNodeFinder
    implements LogicalNodeVisitor {
        private List<LogicalNode> list = new ArrayList<LogicalNode>();
        private final NodeType[] tofind;
        private boolean topmost = false;
        private boolean finished = false;

        public LogicalNodeFinder(NodeType ... type) {
            this.tofind = type;
        }

        public LogicalNodeFinder(NodeType[] type, boolean topmost) {
            this(type);
            this.topmost = topmost;
        }

        @Override
        public void visit(LogicalNode node) {
            if (!this.finished) {
                for (NodeType type : this.tofind) {
                    if (node.getType() == type) {
                        this.list.add(node);
                    }
                    if (!this.topmost || this.list.size() <= 0) continue;
                    this.finished = true;
                }
            }
        }

        public List<LogicalNode> getFoundNodes() {
            return this.list;
        }

        public LogicalNode[] getFoundNodeArray() {
            return this.list.toArray(new LogicalNode[this.list.size()]);
        }
    }

    public static class LogicalNodeReplaceVisitor
    extends BasicLogicalPlanVisitor<ReplacerContext, LogicalNode> {
        private LogicalNode target;
        private LogicalNode tobeReplaced;

        public LogicalNodeReplaceVisitor(LogicalNode target, LogicalNode tobeReplaced) {
            this.target = target;
            this.tobeReplaced = tobeReplaced;
        }

        private static boolean checkIfVisitable(LogicalNode node) {
            return node instanceof UnaryNode || node instanceof BinaryNode;
        }

        @Override
        public LogicalNode visit(ReplacerContext context, LogicalPlan plan, @Nullable LogicalPlan.QueryBlock block, LogicalNode node, Stack<LogicalNode> stack) throws PlanningException {
            LogicalNode left = null;
            LogicalNode right = null;
            if (node instanceof UnaryNode) {
                UnaryNode unaryNode = (UnaryNode)node;
                if (((LogicalNode)unaryNode.getChild()).deepEquals(this.target)) {
                    unaryNode.setChild(this.tobeReplaced);
                    left = this.tobeReplaced;
                    context.updateSchemaFlag = true;
                } else if (LogicalNodeReplaceVisitor.checkIfVisitable(unaryNode.getChild())) {
                    left = this.visit(context, plan, (LogicalPlan.QueryBlock)null, (LogicalNode)unaryNode.getChild(), stack);
                }
            } else if (node instanceof BinaryNode) {
                BinaryNode binaryNode = (BinaryNode)node;
                if (((LogicalNode)binaryNode.getLeftChild()).deepEquals(this.target)) {
                    binaryNode.setLeftChild(this.tobeReplaced);
                    left = this.tobeReplaced;
                    context.updateSchemaFlag = true;
                } else {
                    left = LogicalNodeReplaceVisitor.checkIfVisitable(binaryNode.getLeftChild()) ? this.visit(context, plan, (LogicalPlan.QueryBlock)null, (LogicalNode)binaryNode.getLeftChild(), stack) : binaryNode.getLeftChild();
                }
                if (((LogicalNode)binaryNode.getRightChild()).deepEquals(this.target)) {
                    binaryNode.setRightChild(this.tobeReplaced);
                    right = this.tobeReplaced;
                    context.updateSchemaFlag = true;
                } else {
                    right = LogicalNodeReplaceVisitor.checkIfVisitable(binaryNode.getRightChild()) ? this.visit(context, plan, (LogicalPlan.QueryBlock)null, (LogicalNode)binaryNode.getRightChild(), stack) : binaryNode.getRightChild();
                }
            }
            if (context.updateSchemaFlag) {
                if (node instanceof Projectable) {
                    if (node instanceof BinaryNode) {
                        node.setInSchema(SchemaUtil.merge((Schema)left.getOutSchema(), (Schema)right.getOutSchema()));
                    } else {
                        node.setInSchema(left.getOutSchema());
                    }
                    context.updateSchemaFlag = false;
                } else {
                    node.setInSchema(left.getOutSchema());
                    node.setOutSchema(left.getOutSchema());
                }
            }
            return node;
        }

        @Override
        public LogicalNode visitScan(ReplacerContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, ScanNode node, Stack<LogicalNode> stack) throws PlanningException {
            return node;
        }

        @Override
        public LogicalNode visitPartitionedTableScan(ReplacerContext context, LogicalPlan plan, LogicalPlan.QueryBlock block, PartitionedTableScanNode node, Stack<LogicalNode> stack) throws PlanningException {
            return node;
        }
    }

    static class ReplacerContext {
        boolean updateSchemaFlag = false;

        ReplacerContext() {
        }
    }

    public static class RelationFinderVisitor
    extends BasicLogicalPlanVisitor<Object, LogicalNode> {
        private Set<String> foundRelNameSet = Sets.newHashSet();

        public Set<String> getFoundRelations() {
            return this.foundRelNameSet;
        }

        @Override
        public LogicalNode visit(Object context, LogicalPlan plan, @Nullable LogicalPlan.QueryBlock block, LogicalNode node, Stack<LogicalNode> stack) throws PlanningException {
            if (node.getType() != NodeType.TABLE_SUBQUERY) {
                super.visit(context, plan, block, node, stack);
            }
            if (node instanceof RelationNode) {
                this.foundRelNameSet.add(((RelationNode)node).getCanonicalName());
            }
            return node;
        }
    }
}

