/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.verifier;

import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.tajo.catalog.Column;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.expr.BasicEvalNodeVisitor;
import org.apache.tajo.plan.expr.BinaryEval;
import org.apache.tajo.plan.expr.ConstEval;
import org.apache.tajo.plan.expr.EvalNode;
import org.apache.tajo.plan.expr.EvalTreeUtil;
import org.apache.tajo.plan.expr.EvalType;
import org.apache.tajo.plan.expr.GeneralFunctionEval;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.verifier.VerificationState;

public class ExprsVerifier
extends BasicEvalNodeVisitor<VerificationState, EvalNode> {
    private static final ExprsVerifier instance = new ExprsVerifier();

    public static VerificationState verify(VerificationState state, LogicalNode currentNode, EvalNode expression) throws PlanningException {
        instance.visitChild(state, expression, new Stack<EvalNode>());
        LinkedHashSet<Column> referredColumns = EvalTreeUtil.findUniqueColumns(expression);
        for (Column referredColumn : referredColumns) {
            if (currentNode.getInSchema().contains(referredColumn)) continue;
            throw new PlanningException("Invalid State: " + referredColumn + " cannot be accessible at Node (" + currentNode.getPID() + ")");
        }
        return state;
    }

    private static boolean isCompatibleType(TajoDataTypes.DataType dataType1, TajoDataTypes.DataType dataType2) {
        if (ExprsVerifier.checkNumericType(dataType1) && ExprsVerifier.checkNumericType(dataType2)) {
            return true;
        }
        if (ExprsVerifier.checkTextData(dataType1) && ExprsVerifier.checkTextData(dataType2)) {
            return true;
        }
        if (ExprsVerifier.checkDateTime(dataType1) && ExprsVerifier.checkDateTime(dataType2)) {
            return true;
        }
        return ExprsVerifier.checkNetworkType(dataType1) && ExprsVerifier.checkNetworkType(dataType2);
    }

    private static void verifyComparisonOperator(VerificationState state, BinaryEval expr) {
        TajoDataTypes.DataType rightType;
        TajoDataTypes.DataType leftType = ((EvalNode)expr.getLeftExpr()).getValueType();
        if (!ExprsVerifier.isCompatibleType(leftType, rightType = ((EvalNode)expr.getRightExpr()).getValueType())) {
            state.addVerification("No operator matches the given name and argument type(s): " + expr.toString());
        }
    }

    @Override
    public EvalNode visitEqual(VerificationState context, BinaryEval expr, Stack<EvalNode> stack) {
        super.visitEqual(context, expr, stack);
        ExprsVerifier.verifyComparisonOperator(context, expr);
        return expr;
    }

    @Override
    public EvalNode visitNotEqual(VerificationState context, BinaryEval expr, Stack<EvalNode> stack) {
        super.visitNotEqual(context, expr, stack);
        ExprsVerifier.verifyComparisonOperator(context, expr);
        return expr;
    }

    @Override
    public EvalNode visitLessThan(VerificationState context, BinaryEval expr, Stack<EvalNode> stack) {
        super.visitLessThan(context, expr, stack);
        ExprsVerifier.verifyComparisonOperator(context, expr);
        return expr;
    }

    @Override
    public EvalNode visitLessThanOrEqual(VerificationState context, BinaryEval expr, Stack<EvalNode> stack) {
        super.visitLessThanOrEqual(context, expr, stack);
        ExprsVerifier.verifyComparisonOperator(context, expr);
        return expr;
    }

    @Override
    public EvalNode visitGreaterThan(VerificationState context, BinaryEval expr, Stack<EvalNode> stack) {
        super.visitGreaterThan(context, expr, stack);
        ExprsVerifier.verifyComparisonOperator(context, expr);
        return expr;
    }

    @Override
    public EvalNode visitGreaterThanOrEqual(VerificationState context, BinaryEval expr, Stack<EvalNode> stack) {
        super.visitGreaterThanOrEqual(context, expr, stack);
        ExprsVerifier.verifyComparisonOperator(context, expr);
        return expr;
    }

    private static void checkDivisionByZero(VerificationState state, BinaryEval evalNode) {
        ConstEval constEval;
        if (((EvalNode)evalNode.getRightExpr()).getType() == EvalType.CONST && (constEval = (ConstEval)evalNode.getRightExpr()).getValue().asFloat8() == 0.0) {
            state.addVerification("division by zero");
        }
    }

    private static void checkArithmeticOperand(VerificationState state, BinaryEval evalNode) {
        Object leftExpr = evalNode.getLeftExpr();
        Object rightExpr = evalNode.getRightExpr();
        TajoDataTypes.DataType leftDataType = ((EvalNode)leftExpr).getValueType();
        TajoDataTypes.DataType rightDataType = ((EvalNode)rightExpr).getValueType();
        TajoDataTypes.Type leftType = leftDataType.getType();
        TajoDataTypes.Type rightType = rightDataType.getType();
        if (leftType == TajoDataTypes.Type.DATE && (ExprsVerifier.checkIntType(rightDataType) || rightType == TajoDataTypes.Type.DATE || rightType == TajoDataTypes.Type.INTERVAL || rightType == TajoDataTypes.Type.TIME)) {
            return;
        }
        if (leftType == TajoDataTypes.Type.INTERVAL && (ExprsVerifier.checkNumericType(rightDataType) || rightType == TajoDataTypes.Type.DATE || rightType == TajoDataTypes.Type.INTERVAL || rightType == TajoDataTypes.Type.TIME || rightType == TajoDataTypes.Type.TIMESTAMP)) {
            return;
        }
        if (leftType == TajoDataTypes.Type.TIME && (rightType == TajoDataTypes.Type.DATE || rightType == TajoDataTypes.Type.INTERVAL || rightType == TajoDataTypes.Type.TIME)) {
            return;
        }
        if (leftType == TajoDataTypes.Type.TIMESTAMP && (rightType == TajoDataTypes.Type.TIMESTAMP || rightType == TajoDataTypes.Type.INTERVAL || rightType == TajoDataTypes.Type.TIME)) {
            return;
        }
        if (!ExprsVerifier.checkNumericType(leftDataType) || !ExprsVerifier.checkNumericType(rightDataType)) {
            state.addVerification("No operator matches the given name and argument type(s): " + evalNode.toString());
        }
    }

    private static boolean checkNetworkType(TajoDataTypes.DataType dataType) {
        return dataType.getType() == TajoDataTypes.Type.INET4 || dataType.getType() == TajoDataTypes.Type.INET6;
    }

    private static boolean checkIntType(TajoDataTypes.DataType dataType) {
        int typeNumber = dataType.getType().getNumber();
        return TajoDataTypes.Type.INT1.getNumber() < typeNumber && typeNumber <= TajoDataTypes.Type.INT8.getNumber();
    }

    private static boolean checkNumericType(TajoDataTypes.DataType dataType) {
        int typeNumber = dataType.getType().getNumber();
        return TajoDataTypes.Type.INT1.getNumber() <= typeNumber && typeNumber <= TajoDataTypes.Type.NUMERIC.getNumber();
    }

    private static boolean checkTextData(TajoDataTypes.DataType dataType) {
        int typeNumber = dataType.getType().getNumber();
        return TajoDataTypes.Type.CHAR.getNumber() <= typeNumber && typeNumber <= TajoDataTypes.Type.TEXT.getNumber();
    }

    private static boolean checkDateTime(TajoDataTypes.DataType dataType) {
        int typeNumber = dataType.getType().getNumber();
        return TajoDataTypes.Type.DATE.getNumber() <= typeNumber && typeNumber <= TajoDataTypes.Type.INTERVAL.getNumber() || TajoDataTypes.Type.TIMEZ.getNumber() <= typeNumber && typeNumber <= TajoDataTypes.Type.TIMESTAMPZ.getNumber();
    }

    @Override
    public EvalNode visitPlus(VerificationState context, BinaryEval evalNode, Stack<EvalNode> stack) {
        super.visitPlus(context, evalNode, stack);
        ExprsVerifier.checkArithmeticOperand(context, evalNode);
        return evalNode;
    }

    @Override
    public EvalNode visitMinus(VerificationState context, BinaryEval evalNode, Stack<EvalNode> stack) {
        super.visitMinus(context, evalNode, stack);
        ExprsVerifier.checkArithmeticOperand(context, evalNode);
        return evalNode;
    }

    @Override
    public EvalNode visitMultiply(VerificationState context, BinaryEval evalNode, Stack<EvalNode> stack) {
        super.visitMultiply(context, evalNode, stack);
        ExprsVerifier.checkArithmeticOperand(context, evalNode);
        return evalNode;
    }

    @Override
    public EvalNode visitDivide(VerificationState context, BinaryEval evalNode, Stack<EvalNode> stack) {
        super.visitDivide(context, evalNode, stack);
        ExprsVerifier.checkArithmeticOperand(context, evalNode);
        ExprsVerifier.checkDivisionByZero(context, evalNode);
        return evalNode;
    }

    @Override
    public EvalNode visitModular(VerificationState context, BinaryEval evalNode, Stack<EvalNode> stack) {
        super.visitDivide(context, evalNode, stack);
        ExprsVerifier.checkArithmeticOperand(context, evalNode);
        ExprsVerifier.checkDivisionByZero(context, evalNode);
        return evalNode;
    }

    @Override
    public EvalNode visitFuncCall(VerificationState context, GeneralFunctionEval evalNode, Stack<EvalNode> stack) {
        super.visitFuncCall(context, evalNode, stack);
        if (evalNode.getArgs() != null) {
            for (EvalNode param : evalNode.getArgs()) {
                this.visitChild(context, param, stack);
            }
        }
        return evalNode;
    }
}

