/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.visitor;

import java.util.Stack;
import org.apache.tajo.plan.LogicalPlan;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.logical.AlterTableNode;
import org.apache.tajo.plan.logical.AlterTablespaceNode;
import org.apache.tajo.plan.logical.CreateDatabaseNode;
import org.apache.tajo.plan.logical.CreateTableNode;
import org.apache.tajo.plan.logical.DistinctGroupbyNode;
import org.apache.tajo.plan.logical.DropDatabaseNode;
import org.apache.tajo.plan.logical.DropTableNode;
import org.apache.tajo.plan.logical.EvalExprNode;
import org.apache.tajo.plan.logical.ExceptNode;
import org.apache.tajo.plan.logical.GroupbyNode;
import org.apache.tajo.plan.logical.HavingNode;
import org.apache.tajo.plan.logical.InsertNode;
import org.apache.tajo.plan.logical.IntersectNode;
import org.apache.tajo.plan.logical.JoinNode;
import org.apache.tajo.plan.logical.LimitNode;
import org.apache.tajo.plan.logical.LogicalNode;
import org.apache.tajo.plan.logical.LogicalRootNode;
import org.apache.tajo.plan.logical.PartitionedTableScanNode;
import org.apache.tajo.plan.logical.ProjectionNode;
import org.apache.tajo.plan.logical.ScanNode;
import org.apache.tajo.plan.logical.SelectionNode;
import org.apache.tajo.plan.logical.SetSessionNode;
import org.apache.tajo.plan.logical.SortNode;
import org.apache.tajo.plan.logical.StoreTableNode;
import org.apache.tajo.plan.logical.TableSubQueryNode;
import org.apache.tajo.plan.logical.TruncateTableNode;
import org.apache.tajo.plan.logical.UnionNode;
import org.apache.tajo.plan.logical.WindowAggNode;
import org.apache.tajo.plan.visitor.LogicalPlanVisitor;

public class BasicLogicalPlanVisitor<CONTEXT, RESULT>
implements LogicalPlanVisitor<CONTEXT, RESULT> {
    public void preHook(LogicalPlan plan, LogicalNode node, Stack<LogicalNode> stack, CONTEXT data) throws PlanningException {
    }

    public void postHook(LogicalPlan plan, LogicalNode node, Stack<LogicalNode> stack, CONTEXT data) throws PlanningException {
    }

    public CONTEXT visit(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block) throws PlanningException {
        this.visit(context, plan, block, (LogicalNode)block.getRoot(), new Stack<LogicalNode>());
        return context;
    }

    public RESULT visit(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, LogicalNode node, Stack<LogicalNode> stack) throws PlanningException {
        RESULT current;
        switch (node.getType()) {
            case ROOT: {
                current = this.visitRoot(context, plan, block, (LogicalRootNode)node, stack);
                break;
            }
            case SET_SESSION: {
                current = this.visitSetSession(context, plan, block, (SetSessionNode)node, stack);
                break;
            }
            case EXPRS: {
                current = this.visitEvalExpr(context, plan, block, (EvalExprNode)node, stack);
                break;
            }
            case PROJECTION: {
                current = this.visitProjection(context, plan, block, (ProjectionNode)node, stack);
                break;
            }
            case LIMIT: {
                current = this.visitLimit(context, plan, block, (LimitNode)node, stack);
                break;
            }
            case SORT: {
                current = this.visitSort(context, plan, block, (SortNode)node, stack);
                break;
            }
            case HAVING: {
                current = this.visitHaving(context, plan, block, (HavingNode)node, stack);
                break;
            }
            case GROUP_BY: {
                current = this.visitGroupBy(context, plan, block, (GroupbyNode)node, stack);
                break;
            }
            case WINDOW_AGG: {
                current = this.visitWindowAgg(context, plan, block, (WindowAggNode)node, stack);
                break;
            }
            case DISTINCT_GROUP_BY: {
                current = this.visitDistinctGroupby(context, plan, block, (DistinctGroupbyNode)node, stack);
                break;
            }
            case SELECTION: {
                current = this.visitFilter(context, plan, block, (SelectionNode)node, stack);
                break;
            }
            case JOIN: {
                current = this.visitJoin(context, plan, block, (JoinNode)node, stack);
                break;
            }
            case UNION: {
                current = this.visitUnion(context, plan, block, (UnionNode)node, stack);
                break;
            }
            case EXCEPT: {
                current = this.visitExcept(context, plan, block, (ExceptNode)node, stack);
                break;
            }
            case INTERSECT: {
                current = this.visitIntersect(context, plan, block, (IntersectNode)node, stack);
                break;
            }
            case TABLE_SUBQUERY: {
                current = this.visitTableSubQuery(context, plan, block, (TableSubQueryNode)node, stack);
                break;
            }
            case SCAN: {
                current = this.visitScan(context, plan, block, (ScanNode)node, stack);
                break;
            }
            case PARTITIONS_SCAN: {
                current = this.visitPartitionedTableScan(context, plan, block, (PartitionedTableScanNode)node, stack);
                break;
            }
            case STORE: {
                current = this.visitStoreTable(context, plan, block, (StoreTableNode)node, stack);
                break;
            }
            case INSERT: {
                current = this.visitInsert(context, plan, block, (InsertNode)node, stack);
                break;
            }
            case CREATE_DATABASE: {
                current = this.visitCreateDatabase(context, plan, block, (CreateDatabaseNode)node, stack);
                break;
            }
            case DROP_DATABASE: {
                current = this.visitDropDatabase(context, plan, block, (DropDatabaseNode)node, stack);
                break;
            }
            case CREATE_TABLE: {
                current = this.visitCreateTable(context, plan, block, (CreateTableNode)node, stack);
                break;
            }
            case DROP_TABLE: {
                current = this.visitDropTable(context, plan, block, (DropTableNode)node, stack);
                break;
            }
            case ALTER_TABLESPACE: {
                current = this.visitAlterTablespace(context, plan, block, (AlterTablespaceNode)node, stack);
                break;
            }
            case ALTER_TABLE: {
                current = this.visitAlterTable(context, plan, block, (AlterTableNode)node, stack);
                break;
            }
            case TRUNCATE_TABLE: {
                current = this.visitTruncateTable(context, plan, block, (TruncateTableNode)node, stack);
                break;
            }
            default: {
                throw new PlanningException("Unknown logical node type: " + (Object)((Object)node.getType()));
            }
        }
        return current;
    }

    @Override
    public RESULT visitRoot(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, LogicalRootNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitSetSession(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, SetSessionNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitEvalExpr(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, EvalExprNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitProjection(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, ProjectionNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitLimit(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, LimitNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitSort(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, SortNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitHaving(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, HavingNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitGroupBy(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, GroupbyNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitWindowAgg(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, WindowAggNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitDistinctGroupby(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, DistinctGroupbyNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitFilter(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, SelectionNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitJoin(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, JoinNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getLeftChild(), stack);
        this.visit(context, plan, block, (LogicalNode)node.getRightChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitUnion(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, UnionNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = null;
        if (plan != null) {
            LogicalPlan.QueryBlock leftBlock = plan.getBlock((LogicalNode)node.getLeftChild());
            result = this.visit(context, plan, leftBlock, (LogicalNode)leftBlock.getRoot(), stack);
            LogicalPlan.QueryBlock rightBlock = plan.getBlock((LogicalNode)node.getRightChild());
            this.visit(context, plan, rightBlock, (LogicalNode)rightBlock.getRoot(), stack);
        } else {
            result = this.visit(context, plan, null, (LogicalNode)node.getLeftChild(), stack);
            this.visit(context, plan, null, (LogicalNode)node.getRightChild(), stack);
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitExcept(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, ExceptNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getLeftChild(), stack);
        this.visit(context, plan, block, (LogicalNode)node.getRightChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitIntersect(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, IntersectNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getLeftChild(), stack);
        this.visit(context, plan, block, (LogicalNode)node.getRightChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitTableSubQuery(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, TableSubQueryNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = null;
        if (plan != null) {
            LogicalPlan.QueryBlock childBlock = plan.getBlock(node.getSubQuery());
            result = this.visit(context, plan, childBlock, (LogicalNode)childBlock.getRoot(), stack);
        } else {
            result = this.visit(context, plan, null, node.getSubQuery(), stack);
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitScan(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, ScanNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitPartitionedTableScan(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, PartitionedTableScanNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitStoreTable(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, StoreTableNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitInsert(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, InsertNode node, Stack<LogicalNode> stack) throws PlanningException {
        stack.push(node);
        RESULT result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitCreateDatabase(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, CreateDatabaseNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitDropDatabase(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, DropDatabaseNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitCreateTable(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, CreateTableNode node, Stack<LogicalNode> stack) throws PlanningException {
        RESULT result = null;
        stack.push(node);
        if (node.hasSubQuery()) {
            result = this.visit(context, plan, block, (LogicalNode)node.getChild(), stack);
        }
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitDropTable(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, DropTableNode node, Stack<LogicalNode> stack) {
        return null;
    }

    @Override
    public RESULT visitAlterTablespace(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, AlterTablespaceNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }

    @Override
    public RESULT visitAlterTable(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, AlterTableNode node, Stack<LogicalNode> stack) {
        return null;
    }

    @Override
    public RESULT visitTruncateTable(CONTEXT context, LogicalPlan plan, LogicalPlan.QueryBlock block, TruncateTableNode node, Stack<LogicalNode> stack) throws PlanningException {
        return null;
    }
}

