/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.plan.visitor;

import java.util.Stack;
import org.apache.tajo.algebra.Aggregation;
import org.apache.tajo.algebra.AlterTable;
import org.apache.tajo.algebra.BetweenPredicate;
import org.apache.tajo.algebra.BinaryOperator;
import org.apache.tajo.algebra.CaseWhenPredicate;
import org.apache.tajo.algebra.CountRowsFunctionExpr;
import org.apache.tajo.algebra.CreateTable;
import org.apache.tajo.algebra.DataTypeExpr;
import org.apache.tajo.algebra.DropTable;
import org.apache.tajo.algebra.Expr;
import org.apache.tajo.algebra.FunctionExpr;
import org.apache.tajo.algebra.GeneralSetFunctionExpr;
import org.apache.tajo.algebra.Having;
import org.apache.tajo.algebra.Insert;
import org.apache.tajo.algebra.Join;
import org.apache.tajo.algebra.Limit;
import org.apache.tajo.algebra.LiteralValue;
import org.apache.tajo.algebra.NullLiteral;
import org.apache.tajo.algebra.Projection;
import org.apache.tajo.algebra.RelationList;
import org.apache.tajo.algebra.Selection;
import org.apache.tajo.algebra.Sort;
import org.apache.tajo.algebra.TablePrimarySubQuery;
import org.apache.tajo.algebra.TimeLiteral;
import org.apache.tajo.algebra.TimestampLiteral;
import org.apache.tajo.algebra.UnaryOperator;
import org.apache.tajo.algebra.ValueListExpr;
import org.apache.tajo.algebra.WindowFunctionExpr;
import org.apache.tajo.plan.PlanningException;
import org.apache.tajo.plan.algebra.BaseAlgebraVisitor;

public abstract class SimpleAlgebraVisitor<CONTEXT, RESULT>
extends BaseAlgebraVisitor<CONTEXT, RESULT> {
    @Override
    public RESULT visit(CONTEXT ctx, Stack<Expr> stack, Expr expr) throws PlanningException {
        Object result = null;
        if (expr instanceof UnaryOperator) {
            this.preHook(ctx, stack, expr);
            result = this.visitUnaryOperator(ctx, stack, (UnaryOperator)expr);
            this.postHook(ctx, stack, expr, result);
        } else if (expr instanceof BinaryOperator) {
            this.preHook(ctx, stack, expr);
            result = this.visitBinaryOperator(ctx, stack, (BinaryOperator)expr);
            this.postHook(ctx, stack, expr, result);
        } else {
            result = super.visit(ctx, stack, expr);
        }
        return result;
    }

    public RESULT visitUnaryOperator(CONTEXT ctx, Stack<Expr> stack, UnaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        RESULT result = this.visit(ctx, stack, expr.getChild());
        stack.pop();
        return result;
    }

    public RESULT visitBinaryOperator(CONTEXT ctx, Stack<Expr> stack, BinaryOperator expr) throws PlanningException {
        stack.push((Expr)expr);
        this.visit(ctx, stack, expr.getLeft());
        RESULT result = this.visit(ctx, stack, expr.getRight());
        stack.pop();
        return result;
    }

    @Override
    public RESULT visitProjection(CONTEXT ctx, Stack<Expr> stack, Projection expr) throws PlanningException {
        return super.visitProjection(ctx, stack, expr);
    }

    @Override
    public RESULT visitLimit(CONTEXT ctx, Stack<Expr> stack, Limit expr) throws PlanningException {
        return super.visitLimit(ctx, stack, expr);
    }

    @Override
    public RESULT visitSort(CONTEXT ctx, Stack<Expr> stack, Sort expr) throws PlanningException {
        return super.visitSort(ctx, stack, expr);
    }

    @Override
    public RESULT visitHaving(CONTEXT ctx, Stack<Expr> stack, Having expr) throws PlanningException {
        return super.visitHaving(ctx, stack, expr);
    }

    @Override
    public RESULT visitGroupBy(CONTEXT ctx, Stack<Expr> stack, Aggregation expr) throws PlanningException {
        return super.visitGroupBy(ctx, stack, expr);
    }

    @Override
    public RESULT visitFilter(CONTEXT ctx, Stack<Expr> stack, Selection expr) throws PlanningException {
        return super.visitFilter(ctx, stack, expr);
    }

    @Override
    public RESULT visitJoin(CONTEXT ctx, Stack<Expr> stack, Join expr) throws PlanningException {
        return super.visitJoin(ctx, stack, expr);
    }

    @Override
    public RESULT visitTableSubQuery(CONTEXT ctx, Stack<Expr> stack, TablePrimarySubQuery expr) throws PlanningException {
        return super.visitTableSubQuery(ctx, stack, expr);
    }

    @Override
    public RESULT visitRelationList(CONTEXT ctx, Stack<Expr> stack, RelationList expr) throws PlanningException {
        return super.visitRelationList(ctx, stack, expr);
    }

    @Override
    public RESULT visitCreateTable(CONTEXT ctx, Stack<Expr> stack, CreateTable expr) throws PlanningException {
        return super.visitCreateTable(ctx, stack, expr);
    }

    @Override
    public RESULT visitDropTable(CONTEXT ctx, Stack<Expr> stack, DropTable expr) throws PlanningException {
        return super.visitDropTable(ctx, stack, expr);
    }

    @Override
    public RESULT visitAlterTable(CONTEXT ctx, Stack<Expr> stack, AlterTable expr) throws PlanningException {
        return super.visitAlterTable(ctx, stack, expr);
    }

    @Override
    public RESULT visitInsert(CONTEXT ctx, Stack<Expr> stack, Insert expr) throws PlanningException {
        return super.visitInsert(ctx, stack, expr);
    }

    @Override
    public RESULT visitBetween(CONTEXT ctx, Stack<Expr> stack, BetweenPredicate expr) throws PlanningException {
        return super.visitBetween(ctx, stack, expr);
    }

    @Override
    public RESULT visitCaseWhen(CONTEXT ctx, Stack<Expr> stack, CaseWhenPredicate expr) throws PlanningException {
        return super.visitCaseWhen(ctx, stack, expr);
    }

    @Override
    public RESULT visitValueListExpr(CONTEXT ctx, Stack<Expr> stack, ValueListExpr expr) throws PlanningException {
        return super.visitValueListExpr(ctx, stack, expr);
    }

    @Override
    public RESULT visitFunction(CONTEXT ctx, Stack<Expr> stack, FunctionExpr expr) throws PlanningException {
        return super.visitFunction(ctx, stack, expr);
    }

    @Override
    public RESULT visitCountRowsFunction(CONTEXT ctx, Stack<Expr> stack, CountRowsFunctionExpr expr) throws PlanningException {
        return super.visitCountRowsFunction(ctx, stack, expr);
    }

    @Override
    public RESULT visitGeneralSetFunction(CONTEXT ctx, Stack<Expr> stack, GeneralSetFunctionExpr expr) throws PlanningException {
        return super.visitGeneralSetFunction(ctx, stack, expr);
    }

    @Override
    public RESULT visitWindowFunction(CONTEXT ctx, Stack<Expr> stack, WindowFunctionExpr expr) throws PlanningException {
        return super.visitWindowFunction(ctx, stack, expr);
    }

    @Override
    public RESULT visitDataType(CONTEXT ctx, Stack<Expr> stack, DataTypeExpr expr) throws PlanningException {
        return super.visitDataType(ctx, stack, expr);
    }

    @Override
    public RESULT visitLiteral(CONTEXT ctx, Stack<Expr> stack, LiteralValue expr) throws PlanningException {
        return super.visitLiteral(ctx, stack, expr);
    }

    @Override
    public RESULT visitNullLiteral(CONTEXT ctx, Stack<Expr> stack, NullLiteral expr) throws PlanningException {
        return super.visitNullLiteral(ctx, stack, expr);
    }

    @Override
    public RESULT visitTimestampLiteral(CONTEXT ctx, Stack<Expr> stack, TimestampLiteral expr) throws PlanningException {
        return super.visitTimestampLiteral(ctx, stack, expr);
    }

    @Override
    public RESULT visitTimeLiteral(CONTEXT ctx, Stack<Expr> stack, TimeLiteral expr) throws PlanningException {
        return super.visitTimeLiteral(ctx, stack, expr);
    }
}

