/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import org.apache.tapestry5.internal.jpa.JpaInternalUtils;
import org.apache.tapestry5.ioc.Invocation;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.jpa.EntityManagerManager;

public class CommitAfterMethodAdvice
implements MethodAdvice {
    private final EntityManagerManager manager;

    public CommitAfterMethodAdvice(EntityManagerManager manager) {
        this.manager = manager;
    }

    public void advise(Invocation invocation) {
        EntityTransaction transaction = this.getTransaction(invocation);
        if (transaction != null && !transaction.isActive()) {
            transaction.begin();
        }
        try {
            invocation.proceed();
        }
        catch (RuntimeException e) {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            throw e;
        }
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
        }
    }

    private EntityTransaction getTransaction(Invocation invocation) {
        PersistenceContext annotation = (PersistenceContext)invocation.getMethodAnnotation(PersistenceContext.class);
        EntityManager em = JpaInternalUtils.getEntityManager(this.manager, annotation);
        if (em == null) {
            return null;
        }
        return em.getTransaction();
    }
}

