/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.tapestry5.internal.jpa.PersistenceParser;
import org.apache.tapestry5.internal.jpa.PersistenceUnitInfoImpl;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.jpa.EntityManagerSource;
import org.apache.tapestry5.jpa.PersistenceUnitConfigurer;
import org.apache.tapestry5.jpa.TapestryPersistenceUnitInfo;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerSourceImpl
implements EntityManagerSource,
RegistryShutdownListener {
    private final Map<String, EntityManagerFactory> entityManagerFactories = CollectionFactory.newMap();
    private final Logger logger;
    private final List<TapestryPersistenceUnitInfo> persistenceUnitInfos;

    public EntityManagerSourceImpl(Logger logger, Resource persistenceDescriptor, PersistenceUnitConfigurer packageNamePersistenceUnitConfigurer, Map<String, PersistenceUnitConfigurer> configuration) {
        this.logger = logger;
        List<TapestryPersistenceUnitInfo> persistenceUnitInfos = this.parsePersistenceUnitInfos(persistenceDescriptor);
        Map<String, PersistenceUnitConfigurer> remainingConfigurations = this.configure(configuration, persistenceUnitInfos);
        this.configureRemaining(persistenceUnitInfos, remainingConfigurations);
        if (persistenceUnitInfos.size() == 1) {
            packageNamePersistenceUnitConfigurer.configure(persistenceUnitInfos.get(0));
        }
        this.persistenceUnitInfos = persistenceUnitInfos;
    }

    private List<TapestryPersistenceUnitInfo> parsePersistenceUnitInfos(Resource persistenceDescriptor) {
        List<TapestryPersistenceUnitInfo> persistenceUnitInfos = CollectionFactory.newList();
        if (persistenceDescriptor.exists()) {
            PersistenceParser parser = new PersistenceParser();
            InputStream inputStream = null;
            try {
                inputStream = persistenceDescriptor.openStream();
                persistenceUnitInfos = parser.parse(inputStream);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                InternalUtils.close((Closeable)inputStream);
            }
        }
        return persistenceUnitInfos;
    }

    private Map<String, PersistenceUnitConfigurer> configure(Map<String, PersistenceUnitConfigurer> configuration, List<TapestryPersistenceUnitInfo> persistenceUnitInfos) {
        Map remainingConfigurations = CollectionFactory.newMap(configuration);
        for (TapestryPersistenceUnitInfo info : persistenceUnitInfos) {
            String unitName = info.getPersistenceUnitName();
            PersistenceUnitConfigurer configurer = configuration.get(unitName);
            if (configurer == null) continue;
            configurer.configure(info);
            remainingConfigurations.remove(unitName);
        }
        return remainingConfigurations;
    }

    private void configureRemaining(List<TapestryPersistenceUnitInfo> persistenceUnitInfos, Map<String, PersistenceUnitConfigurer> remainingConfigurations) {
        for (Map.Entry<String, PersistenceUnitConfigurer> entry : remainingConfigurations.entrySet()) {
            PersistenceUnitInfoImpl info = new PersistenceUnitInfoImpl(entry.getKey());
            PersistenceUnitConfigurer configurer = entry.getValue();
            configurer.configure(info);
            persistenceUnitInfos.add(info);
        }
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(String persistenceUnitName) {
        EntityManagerFactory emf = this.entityManagerFactories.get(persistenceUnitName);
        if (emf == null) {
            emf = this.createEntityManagerFactory(persistenceUnitName);
            this.entityManagerFactories.put(persistenceUnitName, emf);
        }
        return emf;
    }

    private EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        PersistenceProvider persistenceProvider = this.getPersistenceProvider();
        for (TapestryPersistenceUnitInfo info : this.persistenceUnitInfos) {
            if (!info.getPersistenceUnitName().equals(persistenceUnitName)) continue;
            Map properties = CollectionFactory.newCaseInsensitiveMap();
            properties.put("tapestry.persistence-unit-name", persistenceUnitName);
            return persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)info, properties);
        }
        throw new IllegalStateException(String.format("Failed to create EntityManagerFactory for persistence unit '%s'", persistenceUnitName));
    }

    private PersistenceProvider getPersistenceProvider() {
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List providers = resolver.getPersistenceProviders();
        if (providers.isEmpty()) {
            throw new IllegalStateException("No PersistenceProvider implementation available in the runtime environment.");
        }
        return (PersistenceProvider)providers.get(0);
    }

    @Override
    public EntityManager create(String persistenceUnitName) {
        return this.getEntityManagerFactory(persistenceUnitName).createEntityManager();
    }

    public void registryDidShutdown() {
        Set<Map.Entry<String, EntityManagerFactory>> entrySet = this.entityManagerFactories.entrySet();
        for (Map.Entry<String, EntityManagerFactory> entry : entrySet) {
            EntityManagerFactory emf = entry.getValue();
            try {
                emf.close();
            }
            catch (Exception e) {
                this.logger.error(String.format("Failed to close EntityManagerFactory for persistence unit '%s'", entry.getKey()), (Throwable)e);
            }
        }
        this.entityManagerFactories.clear();
    }

    @Override
    public List<PersistenceUnitInfo> getPersistenceUnitInfos() {
        return Collections.unmodifiableList(this.persistenceUnitInfos);
    }
}

