/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import javax.persistence.PersistenceContext;
import org.apache.tapestry5.internal.jpa.JpaInternalUtils;
import org.apache.tapestry5.ioc.services.FieldValueConduit;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.ComponentClassTransformWorker;
import org.apache.tapestry5.services.TransformField;

public class PersistenceContextWorker
implements ComponentClassTransformWorker {
    private final EntityManagerManager entityManagerManager;

    public PersistenceContextWorker(EntityManagerManager entityManagerManager) {
        this.entityManagerManager = entityManagerManager;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        for (final TransformField field : transformation.matchFieldsWithAnnotation(PersistenceContext.class)) {
            final PersistenceContext annotation = (PersistenceContext)field.getAnnotation(PersistenceContext.class);
            field.claim((Object)annotation);
            field.replaceAccess(new FieldValueConduit(){

                public Object get() {
                    return JpaInternalUtils.getEntityManager(PersistenceContextWorker.this.entityManagerManager, annotation);
                }

                public void set(Object newValue) {
                    throw new UnsupportedOperationException(String.format("It is not possible to assign a new value to '%s' field", field.getName()));
                }
            });
        }
    }
}

