/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import org.apache.tapestry5.internal.jpa.JpaInternalUtils;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;

public class CommitAfterMethodAdvice
implements MethodAdvice {
    private final EntityManagerManager manager;
    private final PersistenceContext annotation;

    public CommitAfterMethodAdvice(EntityManagerManager manager, PersistenceContext annotation) {
        this.manager = manager;
        this.annotation = annotation;
    }

    public void advise(MethodInvocation invocation) {
        EntityTransaction transaction = this.getTransaction();
        if (transaction != null && !transaction.isActive()) {
            transaction.begin();
        }
        try {
            invocation.proceed();
        }
        catch (RuntimeException e) {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            throw e;
        }
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
        }
    }

    private EntityTransaction getTransaction() {
        EntityManager em = JpaInternalUtils.getEntityManager(this.manager, this.annotation);
        if (em == null) {
            return null;
        }
        return em.getTransaction();
    }
}

