/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import org.apache.tapestry5.internal.jpa.JpaInternalUtils;
import org.apache.tapestry5.internal.jpa.PersistedEntity;
import org.apache.tapestry5.internal.services.SessionApplicationStatePersistenceStrategy;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.services.ApplicationStateCreator;
import org.apache.tapestry5.services.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityApplicationStatePersistenceStrategy
extends SessionApplicationStatePersistenceStrategy {
    private final EntityManagerManager entityManagerManager;

    public EntityApplicationStatePersistenceStrategy(Request request, EntityManagerManager entityManagerManager) {
        super(request);
        this.entityManagerManager = entityManagerManager;
    }

    public <T> T get(Class<T> ssoClass, ApplicationStateCreator<T> creator) {
        Object persistedValue = this.getOrCreate(ssoClass, creator);
        if (persistedValue instanceof PersistedEntity) {
            PersistedEntity persisted = (PersistedEntity)persistedValue;
            Object restored = persisted.restore(this.entityManagerManager);
            if (restored == null) {
                this.set(ssoClass, null);
                return (T)this.getOrCreate(ssoClass, creator);
            }
            return (T)restored;
        }
        return (T)persistedValue;
    }

    public <T> void set(Class<T> ssoClass, T sso) {
        Object entity;
        String key = this.buildKey(ssoClass);
        if (sso != null) {
            try {
                entity = JpaInternalUtils.convertApplicationValueToPersisted(this.entityManagerManager, sso);
            }
            catch (RuntimeException ex) {
                entity = sso;
            }
        } else {
            entity = sso;
        }
        this.getSession().setAttribute(key, entity);
    }
}

