/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.apache.tapestry5.internal.jpa.PersistedEntity;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.jpa.EntityManagerManager;

public class JpaInternalUtils {
    public static PersistedEntity convertApplicationValueToPersisted(EntityManagerManager entityManagerManager, Object newValue) {
        EntityManager em = JpaInternalUtils.getEntityManagerFactory(entityManagerManager, newValue);
        EntityManagerFactory emf = em.getEntityManagerFactory();
        Map properties = emf.getProperties();
        String persistenceUnitName = (String)properties.get("tapestry.persistence-unit-name");
        Object id = emf.getPersistenceUnitUtil().getIdentifier(newValue);
        return new PersistedEntity(newValue.getClass(), id, persistenceUnitName);
    }

    private static EntityManager getEntityManagerFactory(EntityManagerManager entityManagerManager, Object entity) {
        Map<String, EntityManager> entityManagers = entityManagerManager.getEntityManagers();
        for (EntityManager em : entityManagers.values()) {
            EntityManagerFactory emf = em.getEntityManagerFactory();
            Metamodel metamodel = emf.getMetamodel();
            Set entities = metamodel.getEntities();
            for (EntityType entityType : entities) {
                if (entityType.getJavaType() != entity.getClass() || !em.contains(entity)) continue;
                return em;
            }
        }
        throw new IllegalArgumentException(String.format("Failed persisting the entity. The entity '%s' does not belong to any of the existing persistence contexts.", entity));
    }

    public static EntityManager getEntityManager(EntityManagerManager entityManagerManager, PersistenceContext annotation) {
        String unitName;
        String string = unitName = annotation == null ? null : annotation.unitName();
        if (InternalUtils.isNonBlank((String)unitName)) {
            return entityManagerManager.getEntityManager(unitName);
        }
        Map<String, EntityManager> entityManagers = entityManagerManager.getEntityManagers();
        if (entityManagers.size() == 1) {
            return entityManagers.values().iterator().next();
        }
        throw new RuntimeException("Unable to locate a single EntityManager. You must provide the persistence unit name as defined in the persistence.xml using the @PersistenceContext annotation.");
    }
}

