/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.jpa.modules;

import java.util.Collection;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.internal.jpa.CommitAfterWorker;
import org.apache.tapestry5.internal.jpa.EntityApplicationStatePersistenceStrategy;
import org.apache.tapestry5.internal.jpa.EntityManagerManagerImpl;
import org.apache.tapestry5.internal.jpa.EntityManagerObjectProvider;
import org.apache.tapestry5.internal.jpa.EntityManagerSourceImpl;
import org.apache.tapestry5.internal.jpa.EntityPersistentFieldStrategy;
import org.apache.tapestry5.internal.jpa.JpaTransactionAdvisorImpl;
import org.apache.tapestry5.internal.jpa.JpaValueEncoder;
import org.apache.tapestry5.internal.jpa.PackageNamePersistenceUnitConfigurer;
import org.apache.tapestry5.internal.jpa.PersistenceContextWorker;
import org.apache.tapestry5.internal.services.PersistentFieldManager;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.annotations.Startup;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.ioc.services.ThreadCleanupListener;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.jpa.EntityManagerSource;
import org.apache.tapestry5.jpa.JpaEntityPackageManager;
import org.apache.tapestry5.jpa.JpaTransactionAdvisor;
import org.apache.tapestry5.jpa.PersistenceUnitConfigurer;
import org.apache.tapestry5.services.ApplicationStateContribution;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.apache.tapestry5.services.ApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.ApplicationStatePersistenceStrategySource;
import org.apache.tapestry5.services.PersistentFieldStrategy;
import org.apache.tapestry5.services.ValueEncoderFactory;
import org.apache.tapestry5.services.ValueEncoderSource;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(JpaTransactionAdvisor.class, JpaTransactionAdvisorImpl.class);
        binder.bind(PersistenceUnitConfigurer.class, PackageNamePersistenceUnitConfigurer.class).withSimpleId();
        binder.bind(EntityManagerSource.class, EntityManagerSourceImpl.class);
    }

    public static JpaEntityPackageManager buildJpaEntityPackageManager(final Collection<String> packageNames) {
        return new JpaEntityPackageManager(){

            @Override
            public Collection<String> getPackageNames() {
                return packageNames;
            }
        };
    }

    @Scope(value="perthread")
    public static EntityManagerManager buildEntityManagerManager(EntityManagerSource entityManagerSource, PerthreadManager perthreadManager, Logger logger) {
        EntityManagerManagerImpl service = new EntityManagerManagerImpl(entityManagerSource, logger);
        perthreadManager.addThreadCleanupListener((ThreadCleanupListener)service);
        return service;
    }

    @Contribute(value=JpaEntityPackageManager.class)
    public static void provideEntityPackages(Configuration<String> configuration, @Symbol(value="tapestry.app-package") String appRootPackage) {
        configuration.add((Object)(appRootPackage + ".entities"));
    }

    @Contribute(value=PersistentFieldManager.class)
    public static void provideEntityPersistentFieldStrategies(MappedConfiguration<String, PersistentFieldStrategy> configuration) {
        configuration.addInstance((Object)"entity", EntityPersistentFieldStrategy.class);
    }

    @Contribute(value=ApplicationStatePersistenceStrategySource.class)
    public void provideApplicationStatePersistenceStrategies(MappedConfiguration<String, ApplicationStatePersistenceStrategy> configuration) {
        configuration.addInstance((Object)"entity", EntityApplicationStatePersistenceStrategy.class);
    }

    @Contribute(value=ComponentClassTransformWorker2.class)
    @Primary
    public static void provideClassTransformWorkers(OrderedConfiguration<ComponentClassTransformWorker2> configuration) {
        configuration.addInstance("PersistenceContext", PersistenceContextWorker.class, new String[]{"after:Property"});
        configuration.addInstance("JPACommitAfter", CommitAfterWorker.class, new String[]{"after:Log"});
    }

    @Contribute(value=MasterObjectProvider.class)
    public static void provideObjectProviders(OrderedConfiguration<ObjectProvider> configuration) {
        configuration.addInstance("EntityManager", EntityManagerObjectProvider.class, new String[]{"before:AnnotationBasedContributions"});
    }

    @Contribute(value=SymbolProvider.class)
    @FactoryDefaults
    public static void provideFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.jpa.provide-entity-value-encoders", (Object)"true");
        configuration.add((Object)"tapestry.jpa.early-startup", (Object)"true");
        configuration.add((Object)"tapestry.jpa.entity-session-state-persistence-strategy-enabled", (Object)"true");
        configuration.add((Object)"tapestry.jpa.persistence-descriptor", (Object)"/META-INF/persistence.xml");
    }

    @Contribute(value=ValueEncoderSource.class)
    public static void provideValueEncoders(MappedConfiguration<Class, ValueEncoderFactory> configuration, @Symbol(value="tapestry.jpa.provide-entity-value-encoders") boolean provideEncoders, EntityManagerSource entityManagerSource, final EntityManagerManager entityManagerManager, final TypeCoercer typeCoercer, final PropertyAccess propertyAccess, final LoggerSource loggerSource) {
        if (!provideEncoders) {
            return;
        }
        for (final PersistenceUnitInfo info : entityManagerSource.getPersistenceUnitInfos()) {
            EntityManagerFactory emf = entityManagerSource.getEntityManagerFactory(info.getPersistenceUnitName());
            Metamodel metamodel = emf.getMetamodel();
            for (final EntityType entity : metamodel.getEntities()) {
                final Class javaType = entity.getJavaType();
                ValueEncoderFactory factory = new ValueEncoderFactory(){

                    public ValueEncoder create(Class type) {
                        return new JpaValueEncoder(entity, entityManagerManager, info.getPersistenceUnitName(), propertyAccess, typeCoercer, loggerSource.getLogger(javaType));
                    }
                };
                configuration.add((Object)javaType, (Object)factory);
            }
        }
    }

    @Contribute(value=ApplicationStateManager.class)
    public static void provideApplicationStateContributions(MappedConfiguration<Class, ApplicationStateContribution> configuration, EntityManagerSource entityManagerSource, @Symbol(value="tapestry.jpa.entity-session-state-persistence-strategy-enabled") boolean entitySessionStatePersistenceStrategyEnabled) {
        if (!entitySessionStatePersistenceStrategyEnabled) {
            return;
        }
        for (PersistenceUnitInfo info : entityManagerSource.getPersistenceUnitInfos()) {
            EntityManagerFactory emf = entityManagerSource.getEntityManagerFactory(info.getPersistenceUnitName());
            Metamodel metamodel = emf.getMetamodel();
            for (EntityType entity : metamodel.getEntities()) {
                configuration.add((Object)entity.getJavaType(), (Object)new ApplicationStateContribution("entity"));
            }
        }
    }

    @Startup
    public static void startupEarly(EntityManagerManager entityManagerManager, @Symbol(value="tapestry.jpa.early-startup") boolean earlyStartup) {
        if (earlyStartup) {
            entityManagerManager.getEntityManagers();
        }
    }
}

