/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.spring;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringModuleDef
implements ModuleDef {
    private static final String CONTEXT_SERVICE_ID = WebApplicationContext.class.getSimpleName();
    private final ApplicationContext _context;
    private final Map<String, ServiceDef> _serviceDefs = CollectionFactory.newCaseInsensitiveMap();

    public SpringModuleDef(ApplicationContext context) {
        this._context = context;
        for (final String beanName : BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)this._context)) {
            ServiceDef serviceDef = new ServiceDef(){

                private Object getBean() {
                    return SpringModuleDef.this._context.getBean(beanName);
                }

                private Class getBeanType() {
                    return SpringModuleDef.this._context.getType(beanName);
                }

                public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                    return new ObjectCreator(){

                        public Object createObject() {
                            return this.getBean();
                        }
                    };
                }

                public String getServiceId() {
                    return beanName;
                }

                public Class getServiceInterface() {
                    return this.getBeanType();
                }

                public String getServiceScope() {
                    return "singleton";
                }

                public boolean isEagerLoad() {
                    return false;
                }

                public Set<Class> getMarkers() {
                    return Collections.emptySet();
                }
            };
            this._serviceDefs.put(beanName, serviceDef);
        }
        ServiceDef serviceDef = new ServiceDef(){

            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                return new ObjectCreator(){

                    public Object createObject() {
                        return SpringModuleDef.this._context;
                    }
                };
            }

            public String getServiceId() {
                return CONTEXT_SERVICE_ID;
            }

            public Class getServiceInterface() {
                return WebApplicationContext.class;
            }

            public String getServiceScope() {
                return "singleton";
            }

            public boolean isEagerLoad() {
                return false;
            }

            public Set<Class> getMarkers() {
                return Collections.emptySet();
            }
        };
        this._serviceDefs.put(CONTEXT_SERVICE_ID, serviceDef);
    }

    public Class getBuilderClass() {
        return null;
    }

    public Set<ContributionDef> getContributionDefs() {
        return Collections.emptySet();
    }

    public Set<DecoratorDef> getDecoratorDefs() {
        return Collections.emptySet();
    }

    public String getLoggerName() {
        return "Spring";
    }

    public ServiceDef getServiceDef(String serviceId) {
        return this._serviceDefs.get(serviceId);
    }

    public Set<String> getServiceIds() {
        return this._serviceDefs.keySet();
    }
}

