/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.test;

import java.io.File;
import org.mortbay.http.HttpListener;
import org.mortbay.http.NCSARequestLog;
import org.mortbay.http.RequestLog;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class JettyRunner {
    public static final String DEFAULT_CONTEXT_PATH = "/";
    public static final int DEFAULT_PORT = 80;
    private final File _workingDir;
    private final String _contextPath;
    private final int _port;
    private final String _warPath;
    private final Server _jetty;

    public JettyRunner(File workingDir, String contextPath, int port, String warPath) {
        this._workingDir = workingDir;
        this._contextPath = contextPath;
        this._port = port;
        this._warPath = warPath;
        this._jetty = this.createAndStart();
    }

    public void stop() {
        System.out.printf("Stopping Jetty instance on port %d\n", this._port);
        try {
            this._jetty.stop(false);
            while (this._jetty.isStarted()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stopping Jetty instance: " + ex.toString(), ex);
        }
        System.out.println("Jetty instance has stopped.");
    }

    public String toString() {
        return String.format("<JettyRunner %s:%d (%s)>", this._contextPath, this._port, this._warPath);
    }

    private Server createAndStart() {
        try {
            String warPath = new File(this._workingDir, this._warPath).getPath();
            String webDefaults = new File(this._workingDir, "src/test/conf/webdefault.xml").getPath();
            System.out.printf("Starting Jetty instance on port %d (%s mapped to %s)\n", this._port, this._contextPath, warPath);
            Server server = new Server();
            SocketListener socketListener = new SocketListener();
            socketListener.setPort(this._port);
            server.addListener((HttpListener)socketListener);
            NCSARequestLog log = new NCSARequestLog();
            server.setRequestLog((RequestLog)log);
            WebApplicationContext context = server.addWebApplication(this._contextPath, warPath);
            context.setDefaultsDescriptor(webDefaults);
            server.start();
            return server;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure starting Jetty instance: " + ex.toString(), ex);
        }
    }
}

