/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.File;
import org.mortbay.http.HttpListener;
import org.mortbay.http.NCSARequestLog;
import org.mortbay.http.RequestLog;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SunJsseListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class JettyRunner {
    public static final String DEFAULT_CONTEXT_PATH = "/";
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_SECURE_PORT = 8443;
    private final File workingDir;
    private final String contextPath;
    private final int port;
    private final String warPath;
    private final Server jetty;

    public JettyRunner(File workingDir, String contextPath, int port, String warPath) {
        this.workingDir = workingDir;
        this.contextPath = contextPath;
        this.port = port;
        this.warPath = warPath;
        this.jetty = this.createAndStart();
    }

    public void stop() {
        System.out.printf("Stopping Jetty instance on port %d\n", this.port);
        try {
            this.jetty.stop(false);
            while (this.jetty.isStarted()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stopping Jetty instance: " + ex.toString(), ex);
        }
        System.out.println("Jetty instance has stopped.");
    }

    public String toString() {
        return String.format("<JettyRunner %s:%d (%s)>", this.contextPath, this.port, this.warPath);
    }

    private Server createAndStart() {
        try {
            File warPathFile = new File(this.warPath);
            String webappPath = warPathFile.isAbsolute() ? this.warPath : new File(this.workingDir, this.warPath).getPath();
            String webDefaults = new File(this.workingDir, "src/test/conf/webdefault.xml").getPath();
            File keystoreFile = new File(this.workingDir, "src/test/conf/keystore");
            String keystore = keystoreFile.getPath();
            System.out.printf("Starting Jetty instance on port %d (%s mapped to %s)\n", this.port, this.contextPath, webappPath);
            Server server = new Server();
            SocketListener socketListener = new SocketListener();
            socketListener.setPort(this.port);
            server.addListener((HttpListener)socketListener);
            if (keystoreFile.exists()) {
                SunJsseListener secureListener = new SunJsseListener();
                secureListener.setPort(8443);
                secureListener.setKeystore(keystore);
                secureListener.setPassword("tapestry");
                secureListener.setKeyPassword("tapestry");
                server.addListener((HttpListener)secureListener);
            }
            NCSARequestLog log = new NCSARequestLog();
            server.setRequestLog((RequestLog)log);
            WebApplicationContext context = server.addWebApplication(this.contextPath, webappPath);
            context.setDefaultsDescriptor(webDefaults);
            server.start();
            return server;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failure starting Jetty instance: " + ex.toString(), ex);
        }
    }
}

