/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import com.thoughtworks.selenium.CommandProcessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.tapestry5.test.ErrorReporter;
import org.testng.ITestContext;

public class ErrorReporterImpl
implements ErrorReporter {
    private final CommandProcessor commandProcessor;
    private final ITestContext testContext;
    private int uid = 0;
    private final Set<String> previousNames = new HashSet<String>();

    public ErrorReporterImpl(CommandProcessor commandProcessor, ITestContext testContext) {
        this.commandProcessor = commandProcessor;
        this.testContext = testContext;
    }

    public void writeErrorReport() {
        String baseFileName;
        String htmlSource = this.commandProcessor.getString("getHtmlSource", new String[0]);
        File dir = new File(this.testContext.getOutputDirectory());
        dir.mkdirs();
        Method testMethod = (Method)this.testContext.getAttribute("tapestry.current-test-method");
        String string = baseFileName = testMethod == null ? "Unknown-test" : testMethod.getDeclaringClass().getSimpleName() + "." + testMethod.getName();
        if (this.previousNames.contains(baseFileName)) {
            baseFileName = baseFileName + "-" + this.uid++;
        } else {
            this.previousNames.add(baseFileName);
        }
        File report = new File(dir, baseFileName + "-page-content.html");
        System.err.println("Writing current page's HTML source to: " + report);
        try {
            FileWriter fw = new FileWriter(report);
            fw.write(htmlSource);
            fw.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

