/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import com.thoughtworks.selenium.Selenium;
import java.lang.reflect.Method;
import org.apache.tapestry5.test.ErrorReporter;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class SeleniumTestCase
extends Assert
implements Selenium {
    public static final String PAGE_LOAD_TIMEOUT = "15000";
    private Selenium delegate;
    private String baseURL;
    private ErrorReporter errorReporter;
    private ITestContext testContext;

    @BeforeClass
    public void setup(ITestContext context) {
        this.testContext = context;
        this.delegate = (Selenium)context.getAttribute("tapestry.selenium");
        this.baseURL = (String)context.getAttribute("tapestry.base-url");
        this.errorReporter = (ErrorReporter)context.getAttribute("tapestry.error-reporter");
    }

    @AfterClass
    public void cleanup() {
        this.delegate = null;
        this.baseURL = null;
        this.errorReporter = null;
        this.testContext = null;
    }

    protected void writeErrorReport() {
        this.errorReporter.writeErrorReport();
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @BeforeMethod
    public void indicateTestMethodName(Method testMethod) {
        this.testContext.setAttribute("tapestry.current-test-method", (Object)testMethod);
        String className = testMethod.getDeclaringClass().getSimpleName();
        String testName = testMethod.getName().replace("_", " ");
        this.delegate.setContext(className + ": " + testName);
    }

    @AfterMethod
    public void cleanupTestMethod() {
        this.testContext.setAttribute("tapestry.current-test-method", null);
    }

    public void addCustomRequestHeader(String key, String value) {
        this.delegate.addCustomRequestHeader(key, value);
    }

    public void addLocationStrategy(String strategyName, String functionDefinition) {
        this.delegate.addLocationStrategy(strategyName, functionDefinition);
    }

    public void addScript(String scriptContent, String scriptTagId) {
        this.delegate.addScript(scriptContent, scriptTagId);
    }

    public void addSelection(String locator, String optionLocator) {
        this.delegate.addSelection(locator, optionLocator);
    }

    public void allowNativeXpath(String allow) {
        this.delegate.allowNativeXpath(allow);
    }

    public void altKeyDown() {
        this.delegate.altKeyDown();
    }

    public void altKeyUp() {
        this.delegate.altKeyUp();
    }

    public void answerOnNextPrompt(String answer) {
        this.delegate.answerOnNextPrompt(answer);
    }

    public void assignId(String locator, String identifier) {
        this.delegate.assignId(locator, identifier);
    }

    public void attachFile(String fieldLocator, String fileLocator) {
        this.delegate.attachFile(fieldLocator, fileLocator);
    }

    public void captureEntirePageScreenshot(String filename, String kwargs) {
        this.delegate.captureEntirePageScreenshot(filename, kwargs);
    }

    public String captureEntirePageScreenshotToString(String kwargs) {
        return this.delegate.captureEntirePageScreenshotToString(kwargs);
    }

    public String captureNetworkTraffic(String type) {
        return this.delegate.captureNetworkTraffic(type);
    }

    public void captureScreenshot(String filename) {
        this.delegate.captureScreenshot(filename);
    }

    public String captureScreenshotToString() {
        return this.delegate.captureScreenshotToString();
    }

    public void check(String locator) {
        this.delegate.check(locator);
    }

    public void chooseCancelOnNextConfirmation() {
        this.delegate.chooseCancelOnNextConfirmation();
    }

    public void chooseOkOnNextConfirmation() {
        this.delegate.chooseOkOnNextConfirmation();
    }

    public void click(String locator) {
        this.delegate.click(locator);
    }

    public void clickAt(String locator, String coordString) {
        this.delegate.clickAt(locator, coordString);
    }

    public void close() {
        this.delegate.close();
    }

    public void contextMenu(String locator) {
        this.delegate.contextMenu(locator);
    }

    public void contextMenuAt(String locator, String coordString) {
        this.delegate.contextMenuAt(locator, coordString);
    }

    public void controlKeyDown() {
        this.delegate.controlKeyDown();
    }

    public void controlKeyUp() {
        this.delegate.controlKeyUp();
    }

    public void createCookie(String nameValuePair, String optionsString) {
        this.delegate.createCookie(nameValuePair, optionsString);
    }

    public void deleteAllVisibleCookies() {
        this.delegate.deleteAllVisibleCookies();
    }

    public void deleteCookie(String name, String optionsString) {
        this.delegate.deleteCookie(name, optionsString);
    }

    public void deselectPopUp() {
        this.delegate.deselectPopUp();
    }

    public void doubleClick(String locator) {
        this.delegate.doubleClick(locator);
    }

    public void doubleClickAt(String locator, String coordString) {
        this.delegate.doubleClickAt(locator, coordString);
    }

    public void dragAndDrop(String locator, String movementsString) {
        this.delegate.dragAndDrop(locator, movementsString);
    }

    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        this.delegate.dragAndDropToObject(locatorOfObjectToBeDragged, locatorOfDragDestinationObject);
    }

    public void dragdrop(String locator, String movementsString) {
        this.delegate.dragdrop(locator, movementsString);
    }

    public void fireEvent(String locator, String eventName) {
        this.delegate.fireEvent(locator, eventName);
    }

    public void focus(String locator) {
        this.delegate.focus(locator);
    }

    public String getAlert() {
        return this.delegate.getAlert();
    }

    public String[] getAllButtons() {
        return this.delegate.getAllButtons();
    }

    public String[] getAllFields() {
        return this.delegate.getAllFields();
    }

    public String[] getAllLinks() {
        return this.delegate.getAllLinks();
    }

    public String[] getAllWindowIds() {
        return this.delegate.getAllWindowIds();
    }

    public String[] getAllWindowNames() {
        return this.delegate.getAllWindowNames();
    }

    public String[] getAllWindowTitles() {
        return this.delegate.getAllWindowTitles();
    }

    public String getAttribute(String attributeLocator) {
        return this.delegate.getAttribute(attributeLocator);
    }

    public String[] getAttributeFromAllWindows(String attributeName) {
        return this.delegate.getAttributeFromAllWindows(attributeName);
    }

    public String getBodyText() {
        return this.delegate.getBodyText();
    }

    public String getConfirmation() {
        return this.delegate.getConfirmation();
    }

    public String getCookie() {
        return this.delegate.getCookie();
    }

    public String getCookieByName(String name) {
        return this.delegate.getCookieByName(name);
    }

    public Number getCursorPosition(String locator) {
        return this.delegate.getCursorPosition(locator);
    }

    public Number getElementHeight(String locator) {
        return this.delegate.getElementHeight(locator);
    }

    public Number getElementIndex(String locator) {
        return this.delegate.getElementIndex(locator);
    }

    public Number getElementPositionLeft(String locator) {
        return this.delegate.getElementPositionLeft(locator);
    }

    public Number getElementPositionTop(String locator) {
        return this.delegate.getElementPositionTop(locator);
    }

    public Number getElementWidth(String locator) {
        return this.delegate.getElementWidth(locator);
    }

    public String getEval(String script) {
        return this.delegate.getEval(script);
    }

    public String getExpression(String expression) {
        return this.delegate.getExpression(expression);
    }

    public String getHtmlSource() {
        return this.delegate.getHtmlSource();
    }

    public String getLocation() {
        return this.delegate.getLocation();
    }

    public String getLog() {
        return this.delegate.getLog();
    }

    public Number getMouseSpeed() {
        return this.delegate.getMouseSpeed();
    }

    public String getPrompt() {
        return this.delegate.getPrompt();
    }

    public String getSelectedId(String selectLocator) {
        return this.delegate.getSelectedId(selectLocator);
    }

    public String[] getSelectedIds(String selectLocator) {
        return this.delegate.getSelectedIds(selectLocator);
    }

    public String getSelectedIndex(String selectLocator) {
        return this.delegate.getSelectedIndex(selectLocator);
    }

    public String[] getSelectedIndexes(String selectLocator) {
        return this.delegate.getSelectedIndexes(selectLocator);
    }

    public String getSelectedLabel(String selectLocator) {
        return this.delegate.getSelectedLabel(selectLocator);
    }

    public String[] getSelectedLabels(String selectLocator) {
        return this.delegate.getSelectedLabels(selectLocator);
    }

    public String getSelectedValue(String selectLocator) {
        return this.delegate.getSelectedValue(selectLocator);
    }

    public String[] getSelectedValues(String selectLocator) {
        return this.delegate.getSelectedValues(selectLocator);
    }

    public String[] getSelectOptions(String selectLocator) {
        return this.delegate.getSelectOptions(selectLocator);
    }

    public String getSpeed() {
        return this.delegate.getSpeed();
    }

    public String getTable(String tableCellAddress) {
        return this.delegate.getTable(tableCellAddress);
    }

    public String getText(String locator) {
        return this.delegate.getText(locator);
    }

    public String getTitle() {
        return this.delegate.getTitle();
    }

    public String getValue(String locator) {
        return this.delegate.getValue(locator);
    }

    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        return this.delegate.getWhetherThisFrameMatchFrameExpression(currentFrameString, target);
    }

    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        return this.delegate.getWhetherThisWindowMatchWindowExpression(currentWindowString, target);
    }

    public Number getXpathCount(String xpath) {
        return this.delegate.getXpathCount(xpath);
    }

    public void goBack() {
        this.delegate.goBack();
    }

    public void highlight(String locator) {
        this.delegate.highlight(locator);
    }

    public void ignoreAttributesWithoutValue(String ignore) {
        this.delegate.ignoreAttributesWithoutValue(ignore);
    }

    public boolean isAlertPresent() {
        return this.delegate.isAlertPresent();
    }

    public boolean isChecked(String locator) {
        return this.delegate.isChecked(locator);
    }

    public boolean isConfirmationPresent() {
        return this.delegate.isConfirmationPresent();
    }

    public boolean isCookiePresent(String name) {
        return this.delegate.isCookiePresent(name);
    }

    public boolean isEditable(String locator) {
        return this.delegate.isEditable(locator);
    }

    public boolean isElementPresent(String locator) {
        return this.delegate.isElementPresent(locator);
    }

    public boolean isOrdered(String locator1, String locator2) {
        return this.delegate.isOrdered(locator1, locator2);
    }

    public boolean isPromptPresent() {
        return this.delegate.isPromptPresent();
    }

    public boolean isSomethingSelected(String selectLocator) {
        return this.delegate.isSomethingSelected(selectLocator);
    }

    public boolean isTextPresent(String pattern) {
        return this.delegate.isTextPresent(pattern);
    }

    public boolean isVisible(String locator) {
        return this.delegate.isVisible(locator);
    }

    public void keyDown(String locator, String keySequence) {
        this.delegate.keyDown(locator, keySequence);
    }

    public void keyDownNative(String keycode) {
        this.delegate.keyDownNative(keycode);
    }

    public void keyPress(String locator, String keySequence) {
        this.delegate.keyPress(locator, keySequence);
    }

    public void keyPressNative(String keycode) {
        this.delegate.keyPressNative(keycode);
    }

    public void keyUp(String locator, String keySequence) {
        this.delegate.keyUp(locator, keySequence);
    }

    public void keyUpNative(String keycode) {
        this.delegate.keyUpNative(keycode);
    }

    public void metaKeyDown() {
        this.delegate.metaKeyDown();
    }

    public void metaKeyUp() {
        this.delegate.metaKeyUp();
    }

    public void mouseDown(String locator) {
        this.delegate.mouseDown(locator);
    }

    public void mouseDownAt(String locator, String coordString) {
        this.delegate.mouseDownAt(locator, coordString);
    }

    public void mouseDownRight(String locator) {
        this.delegate.mouseDownRight(locator);
    }

    public void mouseDownRightAt(String locator, String coordString) {
        this.delegate.mouseDownRightAt(locator, coordString);
    }

    public void mouseMove(String locator) {
        this.delegate.mouseMove(locator);
    }

    public void mouseMoveAt(String locator, String coordString) {
        this.delegate.mouseMoveAt(locator, coordString);
    }

    public void mouseOut(String locator) {
        this.delegate.mouseOut(locator);
    }

    public void mouseOver(String locator) {
        this.delegate.mouseOver(locator);
    }

    public void mouseUp(String locator) {
        this.delegate.mouseUp(locator);
    }

    public void mouseUpAt(String locator, String coordString) {
        this.delegate.mouseUpAt(locator, coordString);
    }

    public void mouseUpRight(String locator) {
        this.delegate.mouseUpRight(locator);
    }

    public void mouseUpRightAt(String locator, String coordString) {
        this.delegate.mouseUpRightAt(locator, coordString);
    }

    public void open(String url) {
        this.delegate.open(url);
    }

    public void open(String url, String ignoreResponseCode) {
        this.delegate.open(url, ignoreResponseCode);
    }

    public void openWindow(String url, String windowID) {
        this.delegate.openWindow(url, windowID);
    }

    public void refresh() {
        this.delegate.refresh();
    }

    public void removeAllSelections(String locator) {
        this.delegate.removeAllSelections(locator);
    }

    public void removeScript(String scriptTagId) {
        this.delegate.removeScript(scriptTagId);
    }

    public void removeSelection(String locator, String optionLocator) {
        this.delegate.removeSelection(locator, optionLocator);
    }

    public String retrieveLastRemoteControlLogs() {
        return this.delegate.retrieveLastRemoteControlLogs();
    }

    public void rollup(String rollupName, String kwargs) {
        this.delegate.rollup(rollupName, kwargs);
    }

    public void runScript(String script) {
        this.delegate.runScript(script);
    }

    public void select(String selectLocator, String optionLocator) {
        this.delegate.select(selectLocator, optionLocator);
    }

    public void selectFrame(String locator) {
        this.delegate.selectFrame(locator);
    }

    public void selectPopUp(String windowID) {
        this.delegate.selectPopUp(windowID);
    }

    public void selectWindow(String windowID) {
        this.delegate.selectWindow(windowID);
    }

    public void setBrowserLogLevel(String logLevel) {
        this.delegate.setBrowserLogLevel(logLevel);
    }

    public void setContext(String context) {
        this.delegate.setContext(context);
    }

    public void setCursorPosition(String locator, String position) {
        this.delegate.setCursorPosition(locator, position);
    }

    public void setExtensionJs(String extensionJs) {
        this.delegate.setExtensionJs(extensionJs);
    }

    public void setMouseSpeed(String pixels) {
        this.delegate.setMouseSpeed(pixels);
    }

    public void setSpeed(String value) {
        this.delegate.setSpeed(value);
    }

    public void setTimeout(String timeout) {
        this.delegate.setTimeout(timeout);
    }

    public void shiftKeyDown() {
        this.delegate.shiftKeyDown();
    }

    public void shiftKeyUp() {
        this.delegate.shiftKeyUp();
    }

    public void showContextualBanner() {
        this.delegate.showContextualBanner();
    }

    public void showContextualBanner(String className, String methodName) {
        this.delegate.showContextualBanner(className, methodName);
    }

    public void shutDownSeleniumServer() {
        this.delegate.shutDownSeleniumServer();
    }

    public void start() {
        this.delegate.start();
    }

    public void start(Object optionsObject) {
        this.delegate.start(optionsObject);
    }

    public void start(String optionsString) {
        this.delegate.start(optionsString);
    }

    public void stop() {
        this.delegate.stop();
    }

    public void submit(String formLocator) {
        this.delegate.submit(formLocator);
    }

    public void type(String locator, String value) {
        this.delegate.type(locator, value);
    }

    public void typeKeys(String locator, String value) {
        this.delegate.typeKeys(locator, value);
    }

    public void uncheck(String locator) {
        this.delegate.uncheck(locator);
    }

    public void useXpathLibrary(String libraryName) {
        this.delegate.useXpathLibrary(libraryName);
    }

    public void waitForCondition(String script, String timeout) {
        this.delegate.waitForCondition(script, timeout);
    }

    public void waitForFrameToLoad(String frameAddress, String timeout) {
        this.delegate.waitForFrameToLoad(frameAddress, timeout);
    }

    public void waitForPageToLoad(String timeout) {
        this.delegate.waitForPageToLoad(timeout);
    }

    public void waitForPopUp(String windowID, String timeout) {
        this.delegate.waitForPopUp(windowID, timeout);
    }

    public void windowFocus() {
        this.delegate.windowFocus();
    }

    public void windowMaximize() {
        this.delegate.windowMaximize();
    }

    protected final void unreachable() {
        this.writeErrorReport();
        throw new AssertionError((Object)"This statement should not be reachable.");
    }

    protected final void openBaseURL() {
        this.open(this.baseURL);
    }

    protected final void assertText(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getText(locator);
        }
        catch (RuntimeException ex) {
            System.err.printf("Error accessing %s: %s, in:\n\n%s\n\n", locator, ex.getMessage(), this.getHtmlSource());
            throw ex;
        }
        if (actual.equals(expected)) {
            return;
        }
        this.writeErrorReport();
        throw new AssertionError((Object)String.format("%s was '%s' not '%s'", locator, actual, expected));
    }

    protected final void assertTextPresent(String ... text) {
        for (String item : text) {
            if (this.isTextPresent(item)) continue;
            this.writeErrorReport();
            throw new AssertionError((Object)("Page did not contain '" + item + "'."));
        }
    }

    protected final void assertSourcePresent(String ... expected) {
        String source = this.getHtmlSource();
        for (String snippet : expected) {
            if (source.contains(snippet)) continue;
            this.writeErrorReport();
            throw new AssertionError((Object)("Page did not contain source '" + snippet + "'."));
        }
    }

    protected final void clickAndWait(String locator) {
        this.click(locator);
        this.waitForPageToLoad();
    }

    protected final void waitForPageToLoad() {
        this.waitForPageToLoad(PAGE_LOAD_TIMEOUT);
    }

    protected final void assertAttribute(String locator, String expected) {
        String actual = null;
        try {
            actual = this.getAttribute(locator);
        }
        catch (RuntimeException ex) {
            System.err.printf("Error accessing %s: %s", locator, ex.getMessage());
            this.writeErrorReport();
            throw ex;
        }
        if (actual.equals(expected)) {
            return;
        }
        this.writeErrorReport();
        throw new AssertionError((Object)String.format("%s was '%s' not '%s'", locator, actual, expected));
    }

    protected final void assertFieldValue(String locator, String expected) {
        try {
            SeleniumTestCase.assertEquals((String)this.getValue(locator), (String)expected);
        }
        catch (AssertionError ex) {
            System.err.printf("%s:\n%s\n\n", ((Throwable)((Object)ex)).getMessage(), this.getHtmlSource());
            throw ex;
        }
    }
}

