/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import com.github.sommeri.less4j.LessSource;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.ResourceDependencies;

public class ResourceLessSource
extends LessSource {
    private final Resource resource;
    private final ResourceDependencies dependencies;

    ResourceLessSource(Resource resource, ResourceDependencies dependencies) {
        this.resource = resource;
        this.dependencies = dependencies;
    }

    public LessSource relativeSource(String filename) throws LessSource.FileNotFound, LessSource.CannotReadFile, LessSource.StringSourceException {
        Resource relative = this.resource.forFile(filename);
        if (!relative.exists()) {
            throw new LessSource.FileNotFound();
        }
        this.dependencies.addDependency(relative);
        return new ResourceLessSource(relative, this.dependencies);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        String string;
        InputStreamReader input = null;
        try {
            String content;
            input = new InputStreamReader(this.resource.openStream());
            string = content = IOUtils.toString((Reader)input).replace("\r\n", "\n");
        }
        catch (FileNotFoundException ex) {
            try {
                throw new LessSource.FileNotFound();
                catch (IOException ex2) {
                    throw new LessSource.CannotReadFile();
                }
            }
            catch (Throwable throwable) {
                InternalUtils.close(input);
                throw throwable;
            }
        }
        InternalUtils.close((Closeable)input);
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        byte[] byArray;
        InputStreamReader input = null;
        try {
            input = new InputStreamReader(this.resource.openStream());
            byArray = IOUtils.toByteArray((Reader)input);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new LessSource.FileNotFound();
                catch (IOException ex2) {
                    throw new LessSource.CannotReadFile();
                }
            }
            catch (Throwable throwable) {
                InternalUtils.close(input);
                throw throwable;
            }
        }
        InternalUtils.close((Closeable)input);
        return byArray;
    }
}

