/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.internal.webresources.AbstractMinimizer;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.slf4j.Logger;

public class GoogleClosureMinimizer
extends AbstractMinimizer {
    private final List<SourceFile> EXTERNS = Collections.emptyList();

    public GoogleClosureMinimizer(Logger logger, OperationTracker tracker, AssetChecksumGenerator checksumGenerator) {
        super(logger, tracker, checksumGenerator, "text/javascript");
    }

    protected InputStream doMinimize(StreamableResource resource) throws IOException {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setOutputCharset("utf-8");
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        SourceFile input = SourceFile.fromInputStream((String)resource.toString(), (InputStream)resource.openStream());
        List<SourceFile> inputs = Collections.singletonList(input);
        Result result = compiler.compile(this.EXTERNS, inputs, options);
        if (result.success) {
            return IOUtils.toInputStream((String)compiler.toSource());
        }
        throw new RuntimeException(String.format("Compilation failed: %s.", InternalUtils.join((List)CollectionFactory.newList((Object[])result.errors), (String)";")));
    }

    static {
        Compiler.setLoggingLevel((Level)Level.SEVERE);
    }
}

