/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskLocationHint {
    ContainerId containerId;
    private Set<String> hosts;
    private Set<String> racks;

    private TaskLocationHint(ContainerId containerId) {
        Preconditions.checkNotNull((Object)containerId);
        this.containerId = containerId;
    }

    private TaskLocationHint(Set<String> hosts, Set<String> racks) {
        this.hosts = hosts != null ? Collections.unmodifiableSet(hosts) : null;
        this.racks = racks != null ? Collections.unmodifiableSet(racks) : null;
    }

    public static TaskLocationHint createTaskLocationHint(ContainerId containerId) {
        return new TaskLocationHint(containerId);
    }

    public static TaskLocationHint createTaskLocationHint(Set<String> hosts, Set<String> racks) {
        return new TaskLocationHint(hosts, racks);
    }

    public ContainerId getAffinitizedContainer() {
        return this.containerId;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public Set<String> getRacks() {
        return this.racks;
    }

    public int hashCode() {
        int prime = 9397;
        int result = 1;
        result = this.hosts != null ? 9397 * result + this.hosts.hashCode() : result + 9397;
        result = this.racks != null ? 9397 * result + this.racks.hashCode() : result + 9397;
        result = this.containerId != null ? 9397 * result + this.containerId.hashCode() : result + 9397;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskLocationHint other = (TaskLocationHint)obj;
        if (this.hosts != null ? !this.hosts.equals(other.hosts) : other.hosts != null) {
            return false;
        }
        if (this.racks != null ? !this.racks.equals(other.racks) : other.racks != null) {
            return false;
        }
        return !(this.containerId != null ? !this.containerId.equals((Object)other.containerId) : other.containerId != null);
    }
}

