/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;

public class IDUtils {
    public static TezTaskID toTaskId(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        String exceptionMsg = null;
        try {
            String[] parts = str.split("_");
            if (parts.length == 6) {
                if (parts[0].equals("task")) {
                    ApplicationId appId = ApplicationId.newInstance((long)Long.valueOf(parts[1]), (int)Integer.parseInt(parts[2]));
                    TezDAGID dagId = new TezDAGID(appId, Integer.parseInt(parts[3]));
                    TezVertexID vId = new TezVertexID(dagId, Integer.parseInt(parts[4]));
                    return new TezTaskID(vId, Integer.parseInt(parts[5]));
                }
                exceptionMsg = "Bad TaskType identifier. TaskId string : " + str + " is not properly formed.";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exceptionMsg == null) {
            exceptionMsg = "TaskId string : " + str + " is not properly formed";
        }
        throw new IllegalArgumentException(exceptionMsg);
    }

    public static TezTaskAttemptID toTaskAttemptId(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        String exceptionMsg = null;
        try {
            String[] parts = str.split(Character.toString('_'));
            if (parts.length == 7) {
                if (parts[0].equals("attempt")) {
                    ApplicationId appId = ApplicationId.newInstance((long)Long.valueOf(parts[1]), (int)Integer.parseInt(parts[2]));
                    TezDAGID dagId = new TezDAGID(appId, Integer.parseInt(parts[3]));
                    TezVertexID vId = new TezVertexID(dagId, Integer.parseInt(parts[4]));
                    TezTaskID tId = new TezTaskID(vId, Integer.parseInt(parts[5]));
                    return new TezTaskAttemptID(tId, Integer.parseInt(parts[6]));
                }
                exceptionMsg = "Bad TaskType identifier. TaskAttemptId string : " + str + " is not properly formed.";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exceptionMsg == null) {
            exceptionMsg = "TaskAttemptId string : " + str + " is not properly formed";
        }
        throw new IllegalArgumentException(exceptionMsg);
    }
}

