/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.records.DAGProtos;

public class TezUtils {
    private static final Log LOG = LogFactory.getLog(TezUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUserSpecifiedTezConfiguration(Configuration conf) throws IOException {
        FileInputStream confPBBinaryStream = null;
        DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
        try {
            confPBBinaryStream = new FileInputStream("tez-conf.pb");
            confProtoBuilder.mergeFrom((InputStream)confPBBinaryStream);
        }
        finally {
            if (confPBBinaryStream != null) {
                confPBBinaryStream.close();
            }
        }
        DAGProtos.ConfigurationProto confProto = confProtoBuilder.build();
        List kvPairList = confProto.getConfKeyValuesList();
        if (kvPairList != null && !kvPairList.isEmpty()) {
            for (DAGProtos.PlanKeyValuePair kvPair : kvPairList) {
                conf.set(kvPair.getKey(), kvPair.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteString createByteStringFromConf(Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration must be specified");
        ByteString.Output os = ByteString.newOutput();
        DeflaterOutputStream compressOs = new DeflaterOutputStream((OutputStream)os, new Deflater(1));
        try {
            TezUtils.writeConfInPB(compressOs, conf);
        }
        finally {
            if (compressOs != null) {
                compressOs.close();
            }
        }
        return os.toByteString();
    }

    public static byte[] createUserPayloadFromConf(Configuration conf) throws IOException {
        return TezUtils.createByteStringFromConf(conf).toByteArray();
    }

    public static Configuration createConfFromByteString(ByteString byteString) throws IOException {
        Preconditions.checkNotNull((Object)byteString, (Object)"ByteString must be specified");
        InflaterInputStream uncompressIs = new InflaterInputStream(byteString.newInput());
        DAGProtos.ConfigurationProto confProto = DAGProtos.ConfigurationProto.parseFrom((InputStream)uncompressIs);
        Configuration conf = new Configuration(false);
        TezUtils.readConfFromPB(confProto, conf);
        return conf;
    }

    public static Configuration createConfFromUserPayload(byte[] bb) throws IOException {
        return TezUtils.createConfFromByteString(ByteString.copyFrom((byte[])bb));
    }

    private static void writeConfInPB(OutputStream dos, Configuration conf) throws IOException {
        DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
        for (Map.Entry entry : conf) {
            DAGProtos.PlanKeyValuePair.Builder kvp = DAGProtos.PlanKeyValuePair.newBuilder();
            kvp.setKey((String)entry.getKey());
            kvp.setValue((String)entry.getValue());
            confProtoBuilder.addConfKeyValues(kvp);
        }
        DAGProtos.ConfigurationProto confProto = confProtoBuilder.build();
        confProto.writeTo(dos);
    }

    private static void readConfFromPB(DAGProtos.ConfigurationProto confProto, Configuration conf) {
        List settingList = confProto.getConfKeyValuesList();
        for (DAGProtos.PlanKeyValuePair setting : settingList) {
            conf.set(setting.getKey(), setting.getValue());
        }
    }

    public static byte[] compressBytes(byte[] inBytes) throws IOException {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        byte[] compressed = TezUtils.compressBytesInflateDeflate(inBytes);
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("UncompressedSize: " + inBytes.length + ", CompressedSize: " + compressed.length + ", CompressTime: " + sw.elapsedMillis()));
        }
        return compressed;
    }

    public static byte[] uncompressBytes(byte[] inBytes) throws IOException {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        byte[] uncompressed = TezUtils.uncompressBytesInflateDeflate(inBytes);
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("CompressedSize: " + inBytes.length + ", UncompressedSize: " + uncompressed.length + ", UncompressTimeTaken: " + sw.elapsedMillis()));
        }
        return uncompressed;
    }

    private static byte[] compressBytesInflateDeflate(byte[] inBytes) {
        Deflater deflater = new Deflater(1);
        deflater.setInput(inBytes);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inBytes.length);
        deflater.finish();
        byte[] buffer = new byte[8192];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            bos.write(buffer, 0, count);
        }
        byte[] output = bos.toByteArray();
        return output;
    }

    private static byte[] uncompressBytesInflateDeflate(byte[] inBytes) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(inBytes);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inBytes.length);
        byte[] buffer = new byte[8192];
        while (!inflater.finished()) {
            int count;
            try {
                count = inflater.inflate(buffer);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            bos.write(buffer, 0, count);
        }
        byte[] output = bos.toByteArray();
        return output;
    }
}

