/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezID;

public class TezDAGID
extends TezID {
    private static LoadingCache<TezDAGID, TezDAGID> dagIdCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<TezDAGID, TezDAGID>(){

        public TezDAGID load(TezDAGID key) throws Exception {
            return key;
        }
    });
    private ApplicationId applicationId;
    public static final String DAG = "dag";
    static final ThreadLocal<NumberFormat> tezAppIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };
    static final ThreadLocal<NumberFormat> tezDagIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(1);
            return fmt;
        }
    };

    public static TezDAGID getInstance(ApplicationId applicationId, int id) {
        Preconditions.checkArgument((applicationId != null ? 1 : 0) != 0, (Object)"ApplicationID cannot be null");
        return (TezDAGID)dagIdCache.getUnchecked((Object)new TezDAGID(applicationId, id));
    }

    public static TezDAGID getInstance(String yarnRMIdentifier, int appId, int id) {
        Preconditions.checkArgument((yarnRMIdentifier != null ? 1 : 0) != 0, (Object)"yarnRMIdentifier cannot be null");
        return (TezDAGID)dagIdCache.getUnchecked((Object)new TezDAGID(yarnRMIdentifier, appId, id));
    }

    public TezDAGID() {
    }

    private TezDAGID(ApplicationId applicationId, int id) {
        super(id);
        this.applicationId = applicationId;
    }

    private TezDAGID(String yarnRMIdentifier, int appId, int id) {
        this(ApplicationId.newInstance((long)Long.valueOf(yarnRMIdentifier), (int)appId), id);
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezDAGID that = (TezDAGID)o;
        return this.applicationId.equals((Object)that.applicationId);
    }

    @Override
    public int compareTo(TezID o) {
        TezDAGID that = (TezDAGID)o;
        return this.applicationId.compareTo(that.applicationId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.applicationId = ApplicationId.newInstance((long)in.readLong(), (int)in.readInt());
        super.readFields(in);
    }

    public static TezDAGID readTezDAGID(DataInput in) throws IOException {
        long clusterId = in.readLong();
        int appId = in.readInt();
        int dagIdInt = TezID.readID(in);
        TezDAGID dagID = TezDAGID.getInstance(ApplicationId.newInstance((long)clusterId, (int)appId), dagIdInt);
        return dagID;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.applicationId.getClusterTimestamp());
        out.writeInt(this.applicationId.getId());
        super.write(out);
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(DAG)).toString();
    }

    public static TezDAGID fromString(String dagId) {
        try {
            String[] split = dagId.split("_");
            String rmId = split[1];
            int appId = tezAppIdFormat.get().parse(split[2]).intValue();
            int id = tezDagIdFormat.get().parse(split[3]).intValue();
            return TezDAGID.getInstance(rmId, appId, id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return builder.append('_').append(this.applicationId.getClusterTimestamp()).append('_').append(tezAppIdFormat.get().format(this.applicationId.getId())).append('_').append(tezDagIdFormat.get().format(this.id));
    }

    @Override
    public int hashCode() {
        return this.applicationId.hashCode() * 524287 + this.id;
    }
}

