/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.tez.common.TezContainerLogAppender;
import org.apache.tez.dag.api.records.DAGProtos;

@InterfaceAudience.Private
public class TezUtilsInternal {
    private static final Log LOG = LogFactory.getLog(TezUtilsInternal.class);
    private static final Random RANDOM = new Random();
    private static final Pattern pattern = Pattern.compile("\\W");
    @InterfaceAudience.Private
    public static final int MAX_VERTEX_NAME_LENGTH = 40;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUserSpecifiedTezConfiguration(String baseDir, Configuration conf) throws IOException {
        FileInputStream confPBBinaryStream = null;
        DAGProtos.ConfigurationProto.Builder confProtoBuilder = DAGProtos.ConfigurationProto.newBuilder();
        try {
            confPBBinaryStream = new FileInputStream(new File(baseDir, "tez-conf.pb"));
            confProtoBuilder.mergeFrom((InputStream)confPBBinaryStream);
        }
        finally {
            if (confPBBinaryStream != null) {
                confPBBinaryStream.close();
            }
        }
        DAGProtos.ConfigurationProto confProto = confProtoBuilder.build();
        List kvPairList = confProto.getConfKeyValuesList();
        if (kvPairList != null && !kvPairList.isEmpty()) {
            for (DAGProtos.PlanKeyValuePair kvPair : kvPairList) {
                conf.set(kvPair.getKey(), kvPair.getValue());
            }
        }
    }

    public static byte[] compressBytes(byte[] inBytes) throws IOException {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        byte[] compressed = TezUtilsInternal.compressBytesInflateDeflate(inBytes);
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("UncompressedSize: " + inBytes.length + ", CompressedSize: " + compressed.length + ", CompressTime: " + sw.elapsedMillis()));
        }
        return compressed;
    }

    public static byte[] uncompressBytes(byte[] inBytes) throws IOException {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        byte[] uncompressed = TezUtilsInternal.uncompressBytesInflateDeflate(inBytes);
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("CompressedSize: " + inBytes.length + ", UncompressedSize: " + uncompressed.length + ", UncompressTimeTaken: " + sw.elapsedMillis()));
        }
        return uncompressed;
    }

    private static byte[] compressBytesInflateDeflate(byte[] inBytes) {
        Deflater deflater = new Deflater(1);
        deflater.setInput(inBytes);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inBytes.length);
        deflater.finish();
        byte[] buffer = new byte[8192];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            bos.write(buffer, 0, count);
        }
        byte[] output = bos.toByteArray();
        return output;
    }

    private static byte[] uncompressBytesInflateDeflate(byte[] inBytes) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(inBytes);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(inBytes.length);
        byte[] buffer = new byte[8192];
        while (!inflater.finished()) {
            int count;
            try {
                count = inflater.inflate(buffer);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            bos.write(buffer, 0, count);
        }
        byte[] output = bos.toByteArray();
        return output;
    }

    @InterfaceAudience.Private
    public static String cleanVertexName(String vertexName) {
        return TezUtilsInternal.sanitizeString(vertexName).substring(0, vertexName.length() > 40 ? 40 : vertexName.length());
    }

    private static String sanitizeString(String srcString) {
        Matcher matcher = pattern.matcher(srcString);
        String res = matcher.replaceAll("_");
        return res;
    }

    public static void updateLoggers(String addend) throws FileNotFoundException {
        LOG.info((Object)("Redirecting log file based on addend: " + addend));
        Appender appender = Logger.getRootLogger().getAppender("CLA");
        if (appender != null) {
            if (appender instanceof TezContainerLogAppender) {
                TezContainerLogAppender claAppender = (TezContainerLogAppender)appender;
                claAppender.setLogFileName(TezUtilsInternal.constructLogFileName("syslog", addend));
                claAppender.activateOptions();
            } else {
                LOG.warn((Object)("Appender is a " + appender.getClass() + "; require an instance of " + TezContainerLogAppender.class.getName() + " to reconfigure the logger output"));
            }
        } else {
            LOG.warn((Object)"Not configured with appender named: CLA. Cannot reconfigure logger output");
        }
    }

    private static String constructLogFileName(String base, String addend) {
        if (addend == null || addend.isEmpty()) {
            return base;
        }
        return base + "_" + addend;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        if (bytes == null) {
            return new BitSet();
        }
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits) {
        if (bits == null) {
            return null;
        }
        byte[] bytes = new byte[bits.length() / 8 + 1];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static String getContainerLogDir() {
        String logDirsStr = System.getenv(ApplicationConstants.Environment.LOG_DIRS.name());
        if (logDirsStr == null || logDirsStr.isEmpty()) {
            return null;
        }
        String[] logDirs = StringUtils.split((String)logDirsStr, (char)',');
        if (logDirs.length == 0) {
            return null;
        }
        int logIndex = RANDOM.nextInt(logDirs.length);
        return logDirs[logIndex];
    }
}

