/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.counters.AbstractCounters;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.DAGStatusBuilder;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGReport;
import org.apache.tez.dag.app.dag.DAGScheduler;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.DAGTerminationCause;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.VertexTerminationCause;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventDAGFinished;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventCounterUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdateTAAssigned;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.DAGEventVertexCompleted;
import org.apache.tez.dag.app.dag.event.DAGEventVertexReRunning;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventTermination;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrder;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TezBuilderUtils;
import org.apache.tez.runtime.library.common.security.JobTokenSecretManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAGImpl
implements DAG,
EventHandler<DAGEvent> {
    private static final Log LOG = LogFactory.getLog(DAGImpl.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final TezDAGID dagId;
    private final Clock clock;
    private final ApplicationACLsManager aclsManager;
    private final Lock readLock;
    private final Lock writeLock;
    private final String dagName;
    private final TaskAttemptListener taskAttemptListener;
    private final TaskHeartbeatHandler taskHeartbeatHandler;
    private final Object tasksSyncHandle = new Object();
    @VisibleForTesting
    DAGScheduler dagScheduler;
    private final EventHandler eventHandler;
    private final String userName;
    private final String queueName;
    private final AppContext appContext;
    volatile Map<TezVertexID, Vertex> vertices = new HashMap<TezVertexID, Vertex>();
    private Map<String, Edge> edges = new HashMap<String, Edge>();
    private TezCounters dagCounters = new TezCounters();
    private Object fullCountersLock = new Object();
    private TezCounters fullCounters = null;
    private Set<TezVertexID> reRunningVertices = new HashSet<TezVertexID>();
    public final Configuration conf;
    private final DAGProtos.DAGPlan jobPlan;
    private final List<String> diagnostics = new ArrayList<String>();
    private static final DiagnosticsUpdateTransition DIAGNOSTIC_UPDATE_TRANSITION = new DiagnosticsUpdateTransition();
    private static final InternalErrorTransition INTERNAL_ERROR_TRANSITION = new InternalErrorTransition();
    private static final CounterUpdateTransition COUNTER_UPDATE_TRANSITION = new CounterUpdateTransition();
    private static final DAGSchedulerUpdateTransition DAG_SCHEDULER_UPDATE_TRANSITION = new DAGSchedulerUpdateTransition();
    protected static final StateMachineFactory<DAGImpl, DAGState, DAGEventType, DAGEvent> stateMachineFactory = new StateMachineFactory((Enum)DAGState.NEW).addTransition((Enum)DAGState.NEW, (Enum)DAGState.NEW, (Enum)DAGEventType.DAG_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)DAGState.NEW, (Enum)DAGState.NEW, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)DAGState.NEW, EnumSet.of(DAGState.INITED, DAGState.FAILED), (Enum)DAGEventType.DAG_INIT, (MultipleArcTransition)new InitTransition()).addTransition((Enum)DAGState.NEW, (Enum)DAGState.KILLED, (Enum)DAGEventType.DAG_KILL, (SingleArcTransition)new KillNewJobTransition()).addTransition((Enum)DAGState.NEW, (Enum)DAGState.ERROR, (Enum)DAGEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)DAGState.INITED, (Enum)DAGState.INITED, (Enum)DAGEventType.DAG_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)DAGState.INITED, (Enum)DAGState.INITED, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)DAGState.INITED, (Enum)DAGState.RUNNING, (Enum)DAGEventType.DAG_START, (SingleArcTransition)new StartTransition()).addTransition((Enum)DAGState.INITED, (Enum)DAGState.KILLED, (Enum)DAGEventType.DAG_KILL, (SingleArcTransition)new KillInitedJobTransition()).addTransition((Enum)DAGState.INITED, (Enum)DAGState.ERROR, (Enum)DAGEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)DAGState.RUNNING, EnumSet.of(DAGState.RUNNING, DAGState.SUCCEEDED, DAGState.TERMINATING, DAGState.FAILED), (Enum)DAGEventType.DAG_VERTEX_COMPLETED, (MultipleArcTransition)new VertexCompletedTransition()).addTransition((Enum)DAGState.RUNNING, (Enum)DAGState.RUNNING, (Enum)DAGEventType.DAG_VERTEX_RERUNNING, (SingleArcTransition)new VertexReRunningTransition()).addTransition((Enum)DAGState.RUNNING, (Enum)DAGState.TERMINATING, (Enum)DAGEventType.DAG_KILL, (SingleArcTransition)new DAGKilledTransition()).addTransition((Enum)DAGState.RUNNING, (Enum)DAGState.RUNNING, (Enum)DAGEventType.DAG_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)DAGState.RUNNING, (Enum)DAGState.RUNNING, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)DAGState.RUNNING, (Enum)DAGState.RUNNING, (Enum)DAGEventType.DAG_SCHEDULER_UPDATE, (SingleArcTransition)DAG_SCHEDULER_UPDATE_TRANSITION).addTransition((Enum)DAGState.RUNNING, (Enum)DAGState.ERROR, (Enum)DAGEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)DAGState.TERMINATING, EnumSet.of(DAGState.TERMINATING, DAGState.KILLED, DAGState.FAILED), (Enum)DAGEventType.DAG_VERTEX_COMPLETED, (MultipleArcTransition)new VertexCompletedTransition()).addTransition((Enum)DAGState.TERMINATING, (Enum)DAGState.TERMINATING, (Enum)DAGEventType.DAG_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)DAGState.TERMINATING, (Enum)DAGState.TERMINATING, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)DAGState.TERMINATING, (Enum)DAGState.ERROR, (Enum)DAGEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)DAGState.TERMINATING, (Enum)DAGState.TERMINATING, EnumSet.of(DAGEventType.DAG_KILL, DAGEventType.DAG_VERTEX_RERUNNING, DAGEventType.DAG_SCHEDULER_UPDATE)).addTransition((Enum)DAGState.SUCCEEDED, (Enum)DAGState.SUCCEEDED, (Enum)DAGEventType.DAG_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)DAGState.SUCCEEDED, (Enum)DAGState.SUCCEEDED, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)DAGState.SUCCEEDED, (Enum)DAGState.ERROR, (Enum)DAGEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)DAGState.SUCCEEDED, (Enum)DAGState.SUCCEEDED, EnumSet.of(DAGEventType.DAG_KILL, DAGEventType.DAG_SCHEDULER_UPDATE, DAGEventType.DAG_VERTEX_COMPLETED)).addTransition((Enum)DAGState.FAILED, (Enum)DAGState.FAILED, (Enum)DAGEventType.DAG_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)DAGState.FAILED, (Enum)DAGState.FAILED, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)DAGState.FAILED, (Enum)DAGState.ERROR, (Enum)DAGEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)DAGState.FAILED, (Enum)DAGState.FAILED, EnumSet.of(DAGEventType.DAG_KILL, DAGEventType.DAG_VERTEX_RERUNNING, DAGEventType.DAG_SCHEDULER_UPDATE, DAGEventType.DAG_VERTEX_COMPLETED)).addTransition((Enum)DAGState.KILLED, (Enum)DAGState.KILLED, (Enum)DAGEventType.DAG_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)DAGState.KILLED, (Enum)DAGState.KILLED, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)DAGState.KILLED, (Enum)DAGState.ERROR, (Enum)DAGEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)DAGState.KILLED, (Enum)DAGState.KILLED, EnumSet.of(DAGEventType.DAG_KILL, DAGEventType.DAG_START, DAGEventType.DAG_VERTEX_RERUNNING, DAGEventType.DAG_SCHEDULER_UPDATE, DAGEventType.DAG_VERTEX_COMPLETED)).addTransition((Enum)DAGState.ERROR, (Enum)DAGState.ERROR, EnumSet.of(DAGEventType.DAG_KILL, new DAGEventType[]{DAGEventType.DAG_INIT, DAGEventType.DAG_START, DAGEventType.DAG_VERTEX_COMPLETED, DAGEventType.DAG_VERTEX_RERUNNING, DAGEventType.DAG_SCHEDULER_UPDATE, DAGEventType.DAG_COMPLETED, DAGEventType.DAG_DIAGNOSTIC_UPDATE, DAGEventType.INTERNAL_ERROR, DAGEventType.DAG_COUNTER_UPDATE})).addTransition((Enum)DAGState.ERROR, (Enum)DAGState.ERROR, (Enum)DAGEventType.DAG_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).installTopology();
    private final StateMachine<DAGState, DAGEventType, DAGEvent> stateMachine;
    @VisibleForTesting
    int numCompletedVertices = 0;
    private int numVertices;
    private int numSuccessfulVertices = 0;
    private int numFailedVertices = 0;
    private int numKilledVertices = 0;
    private boolean isUber = false;
    private DAGTerminationCause terminationCause;
    private Credentials credentials;
    private long initTime;
    private long startTime;
    private long finishTime;
    Map<String, Vertex> vertexMap = new HashMap<String, Vertex>();

    public DAGImpl(TezDAGID dagId, Configuration conf, DAGProtos.DAGPlan jobPlan, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, JobTokenSecretManager jobTokenSecretManager, Credentials fsTokenCredentials, Clock clock, String appUserName, TaskHeartbeatHandler thh, AppContext appContext) {
        this.dagId = dagId;
        this.jobPlan = jobPlan;
        this.conf = conf;
        this.dagName = jobPlan.getName() != null ? jobPlan.getName() : "<missing app name>";
        this.userName = appUserName;
        this.clock = clock;
        this.appContext = appContext;
        this.queueName = conf.get("mapreduce.job.queuename", "default");
        this.taskAttemptListener = taskAttemptListener;
        this.taskHeartbeatHandler = thh;
        this.eventHandler = eventHandler;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.credentials = fsTokenCredentials;
        this.aclsManager = new ApplicationACLsManager(conf);
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    protected StateMachine<DAGState, DAGEventType, DAGEvent> getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public TezDAGID getID() {
        return this.dagId;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public DAGProtos.DAGPlan getJobPlan() {
        return this.jobPlan;
    }

    EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, ApplicationAccessType jobOperation) {
        return this.aclsManager.checkAccess(callerUGI, jobOperation, this.userName, this.dagId.getApplicationId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vertex getVertex(TezVertexID vertexID) {
        this.readLock.lock();
        try {
            Vertex vertex = this.vertices.get(vertexID);
            return vertex;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isUber() {
        return this.isUber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TezCounters getAllCounters() {
        this.readLock.lock();
        try {
            DAGState state = this.getInternalState();
            if (state == DAGState.ERROR || state == DAGState.FAILED || state == DAGState.KILLED || state == DAGState.SUCCEEDED) {
                this.mayBeConstructFinalFullCounters();
                TezCounters tezCounters = this.fullCounters;
                return tezCounters;
            }
            TezCounters counters = new TezCounters();
            counters.incrAllCounters((AbstractCounters)this.dagCounters);
            TezCounters tezCounters = DAGImpl.incrTaskCounters(counters, this.vertices.values());
            return tezCounters;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static TezCounters incrTaskCounters(TezCounters counters, Collection<Vertex> vertices) {
        for (Vertex vertex : vertices) {
            counters.incrAllCounters((AbstractCounters)vertex.getAllCounters());
        }
        return counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List<String> list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DAGReport getReport() {
        this.readLock.lock();
        try {
            DAGReport dAGReport;
            StringBuilder diagsb = new StringBuilder();
            for (String s : this.getDiagnostics()) {
                diagsb.append(s).append("\n");
            }
            if (this.getInternalState() == DAGState.NEW) {
                dAGReport = TezBuilderUtils.newDAGReport();
                return dAGReport;
            }
            dAGReport = TezBuilderUtils.newDAGReport();
            return dAGReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float progress = 0.0f;
            for (Vertex v : this.getVertices().values()) {
                progress += v.getProgress();
            }
            float f = progress / (float)this.getTotalVertices();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TezVertexID, Vertex> getVertices() {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            return Collections.unmodifiableMap(this.vertices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DAGState getState() {
        this.readLock.lock();
        try {
            DAGState dAGState = (DAGState)this.getStateMachine().getCurrentState();
            return dAGState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DAGStatusBuilder getDAGStatus(Set<StatusGetOpts> statusOptions) {
        DAGStatusBuilder status = new DAGStatusBuilder();
        int totalTaskCount = 0;
        int totalSucceededTaskCount = 0;
        int totalRunningTaskCount = 0;
        int totalFailedTaskCount = 0;
        int totalKilledTaskCount = 0;
        this.readLock.lock();
        try {
            for (Map.Entry<String, Vertex> entry : this.vertexMap.entrySet()) {
                ProgressBuilder progress = entry.getValue().getVertexProgress();
                status.addVertexProgress(entry.getKey(), progress);
                totalTaskCount += progress.getTotalTaskCount();
                totalSucceededTaskCount += progress.getSucceededTaskCount();
                totalRunningTaskCount += progress.getRunningTaskCount();
                totalFailedTaskCount += progress.getFailedTaskCount();
                totalKilledTaskCount += progress.getKilledTaskCount();
            }
            ProgressBuilder dagProgress = new ProgressBuilder();
            dagProgress.setTotalTaskCount(totalTaskCount);
            dagProgress.setSucceededTaskCount(totalSucceededTaskCount);
            dagProgress.setRunningTaskCount(totalRunningTaskCount);
            dagProgress.setFailedTaskCount(totalFailedTaskCount);
            dagProgress.setKilledTaskCount(totalKilledTaskCount);
            status.setState(this.getState());
            status.setDiagnostics(this.diagnostics);
            status.setDAGProgress(dagProgress);
            if (statusOptions.contains(StatusGetOpts.GET_COUNTERS)) {
                status.setDAGCounters(this.getAllCounters());
            }
            DAGStatusBuilder dAGStatusBuilder = status;
            return dAGStatusBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public VertexStatusBuilder getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) {
        Vertex vertex = this.vertexMap.get(vertexName);
        if (vertex == null) {
            return null;
        }
        return vertex.getVertexStatus(statusOptions);
    }

    protected void initializeVerticesAndStart() {
        for (Vertex v : this.vertices.values()) {
            if (v.getInputVerticesCount() != 0) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initing root vertex " + v.getName()));
            }
            this.eventHandler.handle((Event)new VertexEvent(v.getVertexId(), VertexEventType.V_INIT));
        }
        for (Vertex v : this.vertices.values()) {
            if (v.getInputVerticesCount() != 0) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Starting root vertex " + v.getName()));
            }
            this.eventHandler.handle((Event)new VertexEvent(v.getVertexId(), VertexEventType.V_START));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(DAGEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing DAGEvent " + event.getDAGId() + " of type " + event.getType() + " while in state " + (Object)((Object)this.getInternalState()) + ". Event: " + (Object)((Object)event)));
        }
        try {
            this.writeLock.lock();
            DAGState oldState = this.getInternalState();
            try {
                this.getStateMachine().doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                this.addDiagnostic("Invalid event " + event.getType() + " on Job " + this.dagId);
                this.eventHandler.handle((Event)new DAGEvent(this.dagId, DAGEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.dagId + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public DAGState getInternalState() {
        this.readLock.lock();
        try {
            DAGState dAGState = (DAGState)this.getStateMachine().getCurrentState();
            return dAGState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void setFinishTime() {
        this.finishTime = this.clock.getTime();
    }

    void logJobHistoryFinishedEvent() {
        this.setFinishTime();
        DAGFinishedEvent finishEvt = new DAGFinishedEvent(this.dagId, this.startTime, this.finishTime, DAGStatus.State.SUCCEEDED, "", this.getAllCounters());
        this.eventHandler.handle((Event)new DAGHistoryEvent(finishEvt));
    }

    void logJobHistoryInitedEvent() {
        DAGStartedEvent startEvt = new DAGStartedEvent(this.dagId, this.initTime, this.startTime);
        this.eventHandler.handle((Event)new DAGHistoryEvent(startEvt));
    }

    void logJobHistoryUnsuccesfulEvent(DAGStatus.State state) {
        DAGFinishedEvent finishEvt = new DAGFinishedEvent(this.dagId, this.startTime, this.clock.getTime(), state, StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()), this.getAllCounters());
        this.eventHandler.handle((Event)new DAGHistoryEvent(finishEvt));
    }

    static DAGState checkDAGForCompletion(DAGImpl dag) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking dag completion, numCompletedVertices=" + dag.numCompletedVertices + ", numSuccessfulVertices=" + dag.numSuccessfulVertices + ", numFailedVertices=" + dag.numFailedVertices + ", numKilledVertices=" + dag.numKilledVertices + ", numVertices=" + dag.numVertices + ", terminationCause=" + (Object)((Object)dag.terminationCause)));
        }
        if (dag.numCompletedVertices > dag.numVertices) {
            LOG.error((Object)("vertex completion accounting issue: numCompletedVertices > numVertices, numCompletedVertices=" + dag.numCompletedVertices + ", numVertices=" + dag.numVertices));
        }
        if (dag.numCompletedVertices == dag.numVertices) {
            if (dag.numSuccessfulVertices == dag.numVertices && dag.terminationCause == null) {
                dag.setFinishTime();
                dag.logJobHistoryFinishedEvent();
                return dag.finished(DAGState.SUCCEEDED);
            }
            if (dag.terminationCause == DAGTerminationCause.DAG_KILL) {
                dag.setFinishTime();
                String diagnosticMsg = "DAG killed due to user-initiated kill. failedVertices:" + dag.numFailedVertices + " killedVertices:" + dag.numKilledVertices;
                LOG.info((Object)diagnosticMsg);
                dag.addDiagnostic(diagnosticMsg);
                dag.abortJob(DAGStatus.State.KILLED);
                return dag.finished(DAGState.KILLED);
            }
            if (dag.terminationCause == DAGTerminationCause.VERTEX_FAILURE) {
                dag.setFinishTime();
                String diagnosticMsg = "DAG failed due to vertex failure. failedVertices:" + dag.numFailedVertices + " killedVertices:" + dag.numKilledVertices;
                LOG.info((Object)diagnosticMsg);
                dag.addDiagnostic(diagnosticMsg);
                dag.abortJob(DAGStatus.State.FAILED);
                return dag.finished(DAGState.FAILED);
            }
            throw new TezUncheckedException("All vertices complete, but cannot determine final state of DAG, numCompletedVertices=" + dag.numCompletedVertices + ", numSuccessfulVertices=" + dag.numSuccessfulVertices + ", numFailedVertices=" + dag.numFailedVertices + ", numKilledVertices=" + dag.numKilledVertices + ", numVertices=" + dag.numVertices + ", terminationCause=" + (Object)((Object)dag.terminationCause));
        }
        return dag.getInternalState();
    }

    DAGState finished(DAGState finalState) {
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.eventHandler.handle((Event)new DAGAppMasterEventDAGFinished(this.getID(), finalState));
        return finalState;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getName() {
        return this.dagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalVertices() {
        this.readLock.lock();
        try {
            int n = this.numVertices;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSuccessfulVertices() {
        this.readLock.lock();
        try {
            int n = this.numSuccessfulVertices;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    boolean trySetTerminationCause(DAGTerminationCause trigger) {
        if (this.terminationCause == null) {
            this.terminationCause = trigger;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DAGTerminationCause getTerminationCause() {
        this.readLock.lock();
        try {
            DAGTerminationCause dAGTerminationCause = this.terminationCause;
            return dAGTerminationCause;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<ApplicationAccessType, String> getJobACLs() {
        return null;
    }

    private void abortJob(DAGStatus.State abortState) {
        this.logJobHistoryUnsuccesfulEvent(abortState);
    }

    void addVertex(Vertex v) {
        this.vertices.put(v.getVertexId(), v);
        this.vertexMap.put(v.getName(), v);
    }

    @Override
    public Vertex getVertex(String vertexName) {
        return this.vertexMap.get(vertexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayBeConstructFinalFullCounters() {
        Object object = this.fullCountersLock;
        synchronized (object) {
            if (this.fullCounters != null) {
                return;
            }
            this.constructFinalFullcounters();
        }
    }

    @InterfaceAudience.Private
    public void constructFinalFullcounters() {
        this.fullCounters = new TezCounters();
        this.fullCounters.incrAllCounters((AbstractCounters)this.dagCounters);
        for (Vertex v : this.vertices.values()) {
            this.fullCounters.incrAllCounters((AbstractCounters)v.getAllCounters());
        }
    }

    void enactKill(DAGTerminationCause dagTerminationCause, VertexTerminationCause vertexTerminationCause) {
        if (this.trySetTerminationCause(dagTerminationCause)) {
            for (Vertex v : this.vertices.values()) {
                this.eventHandler.handle((Event)new VertexEventTermination(v.getVertexId(), vertexTerminationCause));
            }
        }
    }

    private void vertexSucceeded(Vertex vertex) {
        ++this.numSuccessfulVertices;
    }

    private void vertexReRunning(Vertex vertex) {
        this.reRunningVertices.add(vertex.getVertexId());
        --this.numSuccessfulVertices;
        this.addDiagnostic("Vertex re-running, vertexName=" + vertex.getName() + ", vertexId=" + vertex.getVertexId());
    }

    private void vertexFailed(Vertex vertex) {
        ++this.numFailedVertices;
        this.addDiagnostic("Vertex failed, vertexName=" + vertex.getName() + ", vertexId=" + vertex.getVertexId() + ", diagnostics=" + vertex.getDiagnostics());
    }

    private void vertexKilled(Vertex vertex) {
        ++this.numKilledVertices;
        this.addDiagnostic("Vertex killed, vertexName=" + vertex.getName() + ", vertexId=" + vertex.getVertexId() + ", diagnostics=" + vertex.getDiagnostics());
    }

    private void addDiagnostic(String diag) {
        this.diagnostics.add(diag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        this.readLock.lock();
        try {
            DAGState state = this.getState();
            if (state.equals((Object)DAGState.SUCCEEDED) || state.equals((Object)DAGState.FAILED) || state.equals((Object)DAGState.KILLED) || state.equals((Object)DAGState.ERROR)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalErrorTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private InternalErrorTransition() {
        }

        public void transition(DAGImpl job, DAGEvent event) {
            LOG.info((Object)(job.getID() + " terminating due to internal error"));
            job.enactKill(DAGTerminationCause.INTERNAL_ERROR, VertexTerminationCause.INTERNAL_ERROR);
            job.setFinishTime();
            job.logJobHistoryUnsuccesfulEvent(DAGStatus.State.FAILED);
            job.finished(DAGState.ERROR);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DAGSchedulerUpdateTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private DAGSchedulerUpdateTransition() {
        }

        public void transition(DAGImpl dag, DAGEvent event) {
            DAGEventSchedulerUpdate sEvent = (DAGEventSchedulerUpdate)event;
            switch (sEvent.getUpdateType()) {
                case TA_SCHEDULE: {
                    dag.dagScheduler.scheduleTask(sEvent);
                    break;
                }
                case TA_SCHEDULED: {
                    DAGEventSchedulerUpdateTAAssigned taEvent = (DAGEventSchedulerUpdateTAAssigned)sEvent;
                    dag.dagScheduler.taskScheduled(taEvent);
                    break;
                }
                case TA_SUCCEEDED: {
                    dag.dagScheduler.taskSucceeded(sEvent);
                    break;
                }
                default: {
                    throw new TezUncheckedException("Unknown DAGEventSchedulerUpdate:" + (Object)((Object)sEvent.getUpdateType()));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CounterUpdateTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private CounterUpdateTransition() {
        }

        public void transition(DAGImpl job, DAGEvent event) {
            DAGEventCounterUpdate jce = (DAGEventCounterUpdate)event;
            for (DAGEventCounterUpdate.CounterIncrementalUpdate ci : jce.getCounterUpdates()) {
                job.dagCounters.findCounter(ci.getCounterKey()).increment(ci.getIncrementValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiagnosticsUpdateTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private DiagnosticsUpdateTransition() {
        }

        public void transition(DAGImpl job, DAGEvent event) {
            job.addDiagnostic(((DAGEventDiagnosticsUpdate)event).getDiagnosticUpdate());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VertexReRunningTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private VertexReRunningTransition() {
        }

        public void transition(DAGImpl job, DAGEvent event) {
            DAGEventVertexReRunning vertexEvent = (DAGEventVertexReRunning)event;
            Vertex vertex = job.vertices.get(vertexEvent.getVertexId());
            --job.numCompletedVertices;
            job.vertexReRunning(vertex);
            LOG.info((Object)("Vertex " + vertex.getVertexId() + " re-running." + ", numCompletedVertices=" + job.numCompletedVertices + ", numSuccessfulVertices=" + job.numSuccessfulVertices + ", numFailedVertices=" + job.numFailedVertices + ", numKilledVertices=" + job.numKilledVertices + ", numVertices=" + job.numVertices));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VertexCompletedTransition
    implements MultipleArcTransition<DAGImpl, DAGEvent, DAGState> {
        private VertexCompletedTransition() {
        }

        public DAGState transition(DAGImpl job, DAGEvent event) {
            boolean forceTransitionToKillWait = false;
            DAGEventVertexCompleted vertexEvent = (DAGEventVertexCompleted)event;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received a vertex completion event, vertexId=" + vertexEvent.getVertexId() + ", vertexState=" + (Object)((Object)vertexEvent.getVertexState())));
            }
            Vertex vertex = job.vertices.get(vertexEvent.getVertexId());
            ++job.numCompletedVertices;
            if (vertexEvent.getVertexState() == VertexState.SUCCEEDED) {
                if (!job.reRunningVertices.contains(vertex.getVertexId())) {
                    job.dagScheduler.vertexCompleted(vertex);
                }
                job.vertexSucceeded(vertex);
            } else if (vertexEvent.getVertexState() == VertexState.FAILED) {
                job.enactKill(DAGTerminationCause.VERTEX_FAILURE, vertexEvent.getVertexTerminationCause() == null ? VertexTerminationCause.OTHER_VERTEX_FAILURE : vertexEvent.getVertexTerminationCause());
                job.vertexFailed(vertex);
                forceTransitionToKillWait = true;
            } else if (vertexEvent.getVertexState() == VertexState.KILLED) {
                job.vertexKilled(vertex);
                forceTransitionToKillWait = true;
            }
            job.reRunningVertices.remove(vertex.getVertexId());
            LOG.info((Object)("Vertex " + vertex.getVertexId() + " completed." + ", numCompletedVertices=" + job.numCompletedVertices + ", numSuccessfulVertices=" + job.numSuccessfulVertices + ", numFailedVertices=" + job.numFailedVertices + ", numKilledVertices=" + job.numKilledVertices + ", numVertices=" + job.numVertices));
            DAGState state = DAGImpl.checkDAGForCompletion(job);
            if (state == DAGState.RUNNING && forceTransitionToKillWait) {
                return DAGState.TERMINATING;
            }
            return state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DAGKilledTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private DAGKilledTransition() {
        }

        public void transition(DAGImpl job, DAGEvent event) {
            job.addDiagnostic("Job received Kill while in RUNNING state.");
            job.enactKill(DAGTerminationCause.DAG_KILL, VertexTerminationCause.DAG_KILL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KillInitedJobTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private KillInitedJobTransition() {
        }

        public void transition(DAGImpl job, DAGEvent event) {
            job.trySetTerminationCause(DAGTerminationCause.DAG_KILL);
            job.abortJob(DAGStatus.State.KILLED);
            job.addDiagnostic("Job received Kill in INITED state.");
            job.finished(DAGState.KILLED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KillNewJobTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        private KillNewJobTransition() {
        }

        public void transition(DAGImpl job, DAGEvent event) {
            job.setFinishTime();
            job.logJobHistoryUnsuccesfulEvent(DAGStatus.State.KILLED);
            job.trySetTerminationCause(DAGTerminationCause.DAG_KILL);
            job.finished(DAGState.KILLED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartTransition
    implements SingleArcTransition<DAGImpl, DAGEvent> {
        public void transition(DAGImpl dag, DAGEvent event) {
            dag.startTime = dag.clock.getTime();
            dag.logJobHistoryInitedEvent();
            dag.initializeVerticesAndStart();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitTransition
    implements MultipleArcTransition<DAGImpl, DAGEvent, DAGState> {
        public DAGState transition(DAGImpl dag, DAGEvent event) {
            dag.initTime = dag.clock.getTime();
            dag.numVertices = dag.getJobPlan().getVertexCount();
            if (dag.numVertices == 0) {
                dag.addDiagnostic("No vertices for dag");
                dag.trySetTerminationCause(DAGTerminationCause.ZERO_VERTICES);
                dag.abortJob(DAGStatus.State.FAILED);
                return dag.finished(DAGState.FAILED);
            }
            this.checkTaskLimits();
            for (int i = 0; i < dag.numVertices; ++i) {
                String vertexName = dag.getJobPlan().getVertex(i).getName();
                VertexImpl vertexImpl = this.createVertex(dag, vertexName, i);
                dag.addVertex(vertexImpl);
            }
            this.createDAGEdges(dag);
            Map edgePlans = DagTypeConverters.createEdgePlanMapFromDAGPlan((List)dag.getJobPlan().getEdgeList());
            for (Vertex vertex : dag.vertices.values()) {
                this.parseVertexEdges(dag, edgePlans, vertex);
            }
            this.assignDAGScheduler(dag);
            return DAGState.INITED;
        }

        private void createDAGEdges(DAGImpl dag) {
            for (DAGProtos.EdgePlan edgePlan : dag.getJobPlan().getEdgeList()) {
                EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)edgePlan);
                dag.edges.put(edgePlan.getId(), new Edge(edgeProperty, dag.getEventHandler()));
            }
        }

        private void assignDAGScheduler(DAGImpl dag) {
            LOG.info((Object)"Using Natural order dag scheduler");
            dag.dagScheduler = new DAGSchedulerNaturalOrder(dag, dag.eventHandler);
        }

        private VertexImpl createVertex(DAGImpl dag, String vertexName, int vId) {
            TezVertexID vertexId = TezBuilderUtils.newVertexID(dag.getID(), vId);
            DAGProtos.VertexPlan vertexPlan = dag.getJobPlan().getVertex(vId);
            VertexLocationHint vertexLocationHint = DagTypeConverters.convertFromDAGPlan((List)vertexPlan.getTaskLocationHintList());
            VertexImpl v = new VertexImpl(vertexId, vertexPlan, vertexName, dag.conf, dag.eventHandler, dag.taskAttemptListener, dag.credentials, dag.clock, dag.taskHeartbeatHandler, dag.appContext, vertexLocationHint);
            return v;
        }

        private void parseVertexEdges(DAGImpl dag, Map<String, DAGProtos.EdgePlan> edgePlans, Vertex vertex) {
            Edge edge;
            DAGProtos.EdgePlan edgePlan;
            DAGProtos.VertexPlan vertexPlan = vertex.getVertexPlan();
            HashMap<Vertex, Edge> inVertices = new HashMap<Vertex, Edge>();
            HashMap<Vertex, Edge> outVertices = new HashMap<Vertex, Edge>();
            for (String inEdgeId : vertexPlan.getInEdgeIdList()) {
                edgePlan = edgePlans.get(inEdgeId);
                Vertex inVertex = dag.vertexMap.get(edgePlan.getInputVertexName());
                edge = (Edge)dag.edges.get(inEdgeId);
                edge.setSourceVertex(inVertex);
                edge.setDestinationVertex(vertex);
                inVertices.put(inVertex, edge);
            }
            for (String outEdgeId : vertexPlan.getOutEdgeIdList()) {
                edgePlan = edgePlans.get(outEdgeId);
                Vertex outVertex = dag.vertexMap.get(edgePlan.getOutputVertexName());
                edge = (Edge)dag.edges.get(outEdgeId);
                edge.setSourceVertex(vertex);
                edge.setDestinationVertex(outVertex);
                outVertices.put(outVertex, edge);
            }
            vertex.setInputVertices(inVertices);
            vertex.setOutputVertices(outVertices);
        }

        private void checkTaskLimits() {
        }
    }
}

