/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.dag.EdgeManager;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventOutputFailed;
import org.apache.tez.dag.app.dag.event.TaskEventAddTezEvent;
import org.apache.tez.dag.app.dag.impl.BroadcastEdgeManager;
import org.apache.tez.dag.app.dag.impl.OneToOneEdgeManager;
import org.apache.tez.dag.app.dag.impl.ScatterGatherEdgeManager;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TezEvent;

public class Edge {
    private EdgeProperty edgeProperty;
    private EdgeManager edgeManager;
    private EventHandler eventHandler;
    private AtomicBoolean bufferEvents = new AtomicBoolean(false);
    private List<TezEvent> destinationEventBuffer = new ArrayList<TezEvent>();
    private List<TezEvent> sourceEventBuffer = new ArrayList<TezEvent>();
    private Vertex sourceVertex;
    private Vertex destinationVertex;

    public Edge(EdgeProperty edgeProperty, EventHandler eventHandler) {
        this.edgeProperty = edgeProperty;
        this.eventHandler = eventHandler;
        switch (edgeProperty.getDataMovementType()) {
            case ONE_TO_ONE: {
                this.edgeManager = new OneToOneEdgeManager();
                break;
            }
            case BROADCAST: {
                this.edgeManager = new BroadcastEdgeManager();
                break;
            }
            case SCATTER_GATHER: {
                this.edgeManager = new ScatterGatherEdgeManager();
                break;
            }
            default: {
                String message = "Unknown edge data movement type: " + edgeProperty.getDataMovementType();
                throw new TezUncheckedException(message);
            }
        }
    }

    public EdgeProperty getEdgeProperty() {
        return this.edgeProperty;
    }

    public EdgeManager getEdgeManager() {
        return this.edgeManager;
    }

    public void setEdgeManager(EdgeManager edgeManager) {
        if (edgeManager == null) {
            throw new TezUncheckedException("Edge manager cannot be null");
        }
        this.edgeManager = edgeManager;
    }

    public void setSourceVertex(Vertex sourceVertex) {
        if (this.sourceVertex != null && this.sourceVertex != sourceVertex) {
            throw new TezUncheckedException("Source vertex exists: " + sourceVertex.getName());
        }
        this.sourceVertex = sourceVertex;
    }

    public void setDestinationVertex(Vertex destinationVertex) {
        if (this.destinationVertex != null && this.destinationVertex != destinationVertex) {
            throw new TezUncheckedException("Destination vertex exists: " + destinationVertex.getName());
        }
        this.destinationVertex = destinationVertex;
    }

    public InputSpec getDestinationSpec(int destinationTaskIndex) {
        return new InputSpec(this.sourceVertex.getName(), this.edgeProperty.getEdgeDestination(), this.edgeManager.getNumDestinationTaskInputs(this.sourceVertex.getTotalTasks(), destinationTaskIndex));
    }

    public OutputSpec getSourceSpec(int sourceTaskIndex) {
        return new OutputSpec(this.destinationVertex.getName(), this.edgeProperty.getEdgeSource(), this.edgeManager.getNumSourceTaskOutputs(this.destinationVertex.getTotalTasks(), sourceTaskIndex));
    }

    public void startEventBuffering() {
        this.bufferEvents.set(true);
    }

    public void stopEventBuffering() {
        this.bufferEvents.set(false);
        for (TezEvent event : this.destinationEventBuffer) {
            this.sendTezEventToDestinationTasks(event);
        }
        this.destinationEventBuffer.clear();
        for (TezEvent event : this.sourceEventBuffer) {
            this.sendTezEventToSourceTasks(event);
        }
        this.sourceEventBuffer.clear();
    }

    public void sendTezEventToSourceTasks(TezEvent tezEvent) {
        if (!this.bufferEvents.get()) {
            switch (tezEvent.getEventType()) {
                case INPUT_READ_ERROR_EVENT: {
                    InputReadErrorEvent event = (InputReadErrorEvent)tezEvent.getEvent();
                    TezTaskAttemptID destAttemptId = tezEvent.getSourceInfo().getTaskAttemptID();
                    int destTaskIndex = destAttemptId.getTaskID().getId();
                    int srcTaskIndex = this.edgeManager.routeEventToSourceTasks(destTaskIndex, event);
                    int numConsumers = this.edgeManager.getDestinationConsumerTaskNumber(srcTaskIndex, this.destinationVertex.getTotalTasks());
                    Task srcTask = this.sourceVertex.getTask(srcTaskIndex);
                    if (srcTask == null) {
                        throw new TezUncheckedException("Unexpected null task. sourceVertex=" + this.sourceVertex.getVertexId() + " srcIndex = " + srcTaskIndex + " destAttemptId=" + destAttemptId + " destIndex=" + destTaskIndex + " edgeManager=" + this.edgeManager.getClass().getName());
                    }
                    TezTaskID srcTaskId = srcTask.getTaskId();
                    int taskAttemptIndex = event.getVersion();
                    TezTaskAttemptID srcTaskAttemptId = new TezTaskAttemptID(srcTaskId, taskAttemptIndex);
                    this.eventHandler.handle((Event)new TaskAttemptEventOutputFailed(srcTaskAttemptId, tezEvent, numConsumers));
                    break;
                }
                default: {
                    throw new TezUncheckedException("Unhandled tez event type: " + tezEvent.getEventType());
                }
            }
        } else {
            this.sourceEventBuffer.add(tezEvent);
        }
    }

    public void sendTezEventToDestinationTasks(TezEvent tezEvent) {
        block11: {
            block10: {
                if (this.bufferEvents.get()) break block10;
                ArrayList<Integer> destTaskIndices = new ArrayList<Integer>();
                boolean isDataMovementEvent = true;
                switch (tezEvent.getEventType()) {
                    case INPUT_FAILED_EVENT: {
                        isDataMovementEvent = false;
                    }
                    case DATA_MOVEMENT_EVENT: {
                        org.apache.tez.runtime.api.Event event = tezEvent.getEvent();
                        TezTaskAttemptID sourceAttemptId = tezEvent.getSourceInfo().getTaskAttemptID();
                        int sourceTaskIndex = sourceAttemptId.getTaskID().getId();
                        if (isDataMovementEvent) {
                            this.edgeManager.routeEventToDestinationTasks((DataMovementEvent)event, sourceTaskIndex, this.destinationVertex.getTotalTasks(), destTaskIndices);
                        } else {
                            this.edgeManager.routeEventToDestinationTasks((InputFailedEvent)event, sourceTaskIndex, this.destinationVertex.getTotalTasks(), destTaskIndices);
                        }
                        for (Integer destTaskIndex : destTaskIndices) {
                            EventMetaData destMeta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, this.destinationVertex.getName(), this.sourceVertex.getName(), null);
                            if (isDataMovementEvent) {
                                destMeta.setIndex(((DataMovementEvent)event).getTargetIndex());
                            } else {
                                destMeta.setIndex(((InputFailedEvent)event).getTargetIndex());
                            }
                            tezEvent.setDestinationInfo(destMeta);
                            Task destTask = this.destinationVertex.getTask(destTaskIndex);
                            if (destTask == null) {
                                throw new TezUncheckedException("Unexpected null task. sourceVertex=" + this.sourceVertex.getVertexId() + " srcIndex = " + sourceTaskIndex + " destAttemptId=" + this.destinationVertex.getVertexId() + " destIndex=" + destTaskIndex + " edgeManager=" + this.edgeManager.getClass().getName());
                            }
                            TezTaskID destTaskId = destTask.getTaskId();
                            this.sendEventToTask(destTaskId, tezEvent);
                        }
                        break block11;
                    }
                    default: {
                        throw new TezUncheckedException("Unhandled tez event type: " + tezEvent.getEventType());
                    }
                }
            }
            this.destinationEventBuffer.add(tezEvent);
        }
    }

    private void sendEventToTask(TezTaskID taskId, TezEvent tezEvent) {
        this.eventHandler.handle((Event)new TaskEventAddTezEvent(taskId, tezEvent));
    }
}

