/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.MRVertexOutputCommitter;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.counters.AbstractCounters;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.committer.NullVertexOutputCommitter;
import org.apache.tez.dag.api.committer.VertexContext;
import org.apache.tez.dag.api.committer.VertexOutputCommitter;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.EdgeManager;
import org.apache.tez.dag.app.dag.RootInputInitializerRunner;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.TaskTerminationCause;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexScheduler;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.VertexTerminationCause;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.DAGEventVertexCompleted;
import org.apache.tez.dag.app.dag.event.DAGEventVertexReRunning;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventAttemptFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventTermination;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventOneToOneSourceSplit;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputFailed;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputInitialized;
import org.apache.tez.dag.app.dag.event.VertexEventRouteEvent;
import org.apache.tez.dag.app.dag.event.VertexEventSourceTaskAttemptCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventSourceVertexStarted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskAttemptCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskReschedule;
import org.apache.tez.dag.app.dag.event.VertexEventTermination;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.app.dag.impl.ImmediateStartVertexScheduler;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.app.dag.impl.RootInputVertexManager;
import org.apache.tez.dag.app.dag.impl.ShuffleVertexManager;
import org.apache.tez.dag.app.dag.impl.TaskImpl;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TezEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexImpl
implements Vertex,
EventHandler<VertexEvent> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Log LOG = LogFactory.getLog(VertexImpl.class);
    private final Clock clock;
    private final Lock readLock;
    private final Lock writeLock;
    private final TaskAttemptListener taskAttemptListener;
    private final TaskHeartbeatHandler taskHeartbeatHandler;
    private final Object tasksSyncHandle = new Object();
    private final EventHandler eventHandler;
    private final AppContext appContext;
    private boolean lazyTasksCopyNeeded = false;
    volatile LinkedHashMap<TezTaskID, Task> tasks = new LinkedHashMap();
    private Object fullCountersLock = new Object();
    private TezCounters fullCounters = null;
    private Resource taskResource;
    private Configuration conf;
    private int numStartedSourceVertices = 0;
    private int numInitedSourceVertices = 0;
    private int distanceFromRoot = 0;
    private final List<String> diagnostics = new ArrayList<String>();
    @VisibleForTesting
    int numSuccessSourceAttemptCompletions = 0;
    List<InputSpec> inputSpecList;
    List<OutputSpec> outputSpecList;
    private static final InternalErrorTransition INTERNAL_ERROR_TRANSITION = new InternalErrorTransition();
    private static final RouteEventTransition ROUTE_EVENT_TRANSITION = new RouteEventTransition();
    private static final TaskAttemptCompletedEventTransition TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION = new TaskAttemptCompletedEventTransition();
    private static final SourceTaskAttemptCompletedEventTransition SOURCE_TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION = new SourceTaskAttemptCompletedEventTransition();
    protected static final StateMachineFactory<VertexImpl, VertexState, VertexEventType, VertexEvent> stateMachineFactory = new StateMachineFactory((Enum)VertexState.NEW).addTransition((Enum)VertexState.NEW, EnumSet.of(VertexState.NEW, VertexState.INITED, VertexState.INITIALIZING, VertexState.FAILED), (Enum)VertexEventType.V_INIT, (MultipleArcTransition)new InitTransition()).addTransition((Enum)VertexState.NEW, (Enum)VertexState.KILLED, (Enum)VertexEventType.V_TERMINATE, (SingleArcTransition)new TerminateNewVertexTransition()).addTransition((Enum)VertexState.NEW, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.INITIALIZING, EnumSet.of(VertexState.INITIALIZING, VertexState.INITED, VertexState.RUNNING, VertexState.FAILED), (Enum)VertexEventType.V_ROOT_INPUT_INITIALIZED, (MultipleArcTransition)new RootInputInitializedTransition()).addTransition((Enum)VertexState.INITIALIZING, EnumSet.of(VertexState.FAILED, VertexState.INITED), (Enum)VertexEventType.V_ONE_TO_ONE_SOURCE_SPLIT, (MultipleArcTransition)new OneToOneSourceSplitTransition()).addTransition((Enum)VertexState.INITIALIZING, (Enum)VertexState.FAILED, (Enum)VertexEventType.V_ROOT_INPUT_FAILED, (SingleArcTransition)new RootInputInitFailedTransition()).addTransition((Enum)VertexState.INITIALIZING, (Enum)VertexState.INITIALIZING, (Enum)VertexEventType.V_START, (SingleArcTransition)new StartWhileInitializingTransition()).addTransition((Enum)VertexState.INITIALIZING, (Enum)VertexState.INITIALIZING, (Enum)VertexEventType.V_SOURCE_VERTEX_STARTED, (SingleArcTransition)new SourceVertexStartedTransition()).addTransition((Enum)VertexState.INITIALIZING, (Enum)VertexState.INITIALIZING, (Enum)VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)SOURCE_TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)VertexState.INITIALIZING, (Enum)VertexState.INITIALIZING, (Enum)VertexEventType.V_ROUTE_EVENT, (SingleArcTransition)new RouteEventsWhileInitializingTransition()).addTransition((Enum)VertexState.INITIALIZING, (Enum)VertexState.KILLED, (Enum)VertexEventType.V_TERMINATE, (SingleArcTransition)new TerminateInitingVertexTransition()).addTransition((Enum)VertexState.INITIALIZING, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.INITED, (Enum)VertexState.INITED, (Enum)VertexEventType.V_SOURCE_VERTEX_STARTED, (SingleArcTransition)new SourceVertexStartedTransition()).addTransition((Enum)VertexState.INITED, EnumSet.of(VertexState.INITED), (Enum)VertexEventType.V_ONE_TO_ONE_SOURCE_SPLIT, (MultipleArcTransition)new OneToOneSourceSplitTransition()).addTransition((Enum)VertexState.INITED, (Enum)VertexState.INITED, (Enum)VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)SOURCE_TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)VertexState.INITED, (Enum)VertexState.RUNNING, (Enum)VertexEventType.V_START, (SingleArcTransition)new StartTransition()).addTransition((Enum)VertexState.INITED, (Enum)VertexState.INITED, (Enum)VertexEventType.V_ROUTE_EVENT, (SingleArcTransition)ROUTE_EVENT_TRANSITION).addTransition((Enum)VertexState.INITED, (Enum)VertexState.KILLED, (Enum)VertexEventType.V_TERMINATE, (SingleArcTransition)new TerminateInitedVertexTransition()).addTransition((Enum)VertexState.INITED, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.RUNNING, (Enum)VertexState.RUNNING, (Enum)VertexEventType.V_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)VertexState.RUNNING, (Enum)VertexState.RUNNING, (Enum)VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)SOURCE_TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)VertexState.RUNNING, EnumSet.of(VertexState.RUNNING, VertexState.SUCCEEDED, VertexState.TERMINATING, VertexState.FAILED), (Enum)VertexEventType.V_TASK_COMPLETED, (MultipleArcTransition)new TaskCompletedTransition()).addTransition((Enum)VertexState.RUNNING, (Enum)VertexState.TERMINATING, (Enum)VertexEventType.V_TERMINATE, (SingleArcTransition)new VertexKilledTransition()).addTransition((Enum)VertexState.RUNNING, (Enum)VertexState.RUNNING, (Enum)VertexEventType.V_TASK_RESCHEDULED, (SingleArcTransition)new TaskRescheduledTransition()).addTransition((Enum)VertexState.RUNNING, EnumSet.of(VertexState.RUNNING, VertexState.SUCCEEDED, VertexState.FAILED), (Enum)VertexEventType.V_COMPLETED, (MultipleArcTransition)new VertexNoTasksCompletedTransition()).addTransition((Enum)VertexState.RUNNING, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.RUNNING, (Enum)VertexState.RUNNING, (Enum)VertexEventType.V_ROUTE_EVENT, (SingleArcTransition)ROUTE_EVENT_TRANSITION).addTransition((Enum)VertexState.TERMINATING, EnumSet.of(VertexState.TERMINATING, VertexState.KILLED, VertexState.FAILED), (Enum)VertexEventType.V_TASK_COMPLETED, (MultipleArcTransition)new TaskCompletedTransition()).addTransition((Enum)VertexState.TERMINATING, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.TERMINATING, (Enum)VertexState.TERMINATING, EnumSet.of(VertexEventType.V_TERMINATE, VertexEventType.V_ROUTE_EVENT, VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, VertexEventType.V_TASK_ATTEMPT_COMPLETED, VertexEventType.V_TASK_RESCHEDULED)).addTransition((Enum)VertexState.SUCCEEDED, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.SUCCEEDED, EnumSet.of(VertexState.RUNNING, VertexState.FAILED), (Enum)VertexEventType.V_TASK_RESCHEDULED, (MultipleArcTransition)new TaskRescheduledAfterVertexSuccessTransition()).addTransition((Enum)VertexState.SUCCEEDED, (Enum)VertexState.SUCCEEDED, EnumSet.of(VertexEventType.V_TERMINATE, VertexEventType.V_TASK_ATTEMPT_COMPLETED, VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, VertexEventType.V_ROUTE_EVENT, VertexEventType.V_TASK_COMPLETED)).addTransition((Enum)VertexState.FAILED, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.FAILED, (Enum)VertexState.FAILED, EnumSet.of(VertexEventType.V_TERMINATE, new VertexEventType[]{VertexEventType.V_TASK_RESCHEDULED, VertexEventType.V_START, VertexEventType.V_ROUTE_EVENT, VertexEventType.V_TASK_ATTEMPT_COMPLETED, VertexEventType.V_TASK_COMPLETED, VertexEventType.V_ONE_TO_ONE_SOURCE_SPLIT, VertexEventType.V_ROOT_INPUT_INITIALIZED, VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, VertexEventType.V_ROOT_INPUT_FAILED})).addTransition((Enum)VertexState.KILLED, (Enum)VertexState.ERROR, (Enum)VertexEventType.V_INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)VertexState.KILLED, (Enum)VertexState.KILLED, EnumSet.of(VertexEventType.V_TERMINATE, new VertexEventType[]{VertexEventType.V_INIT, VertexEventType.V_SOURCE_VERTEX_STARTED, VertexEventType.V_START, VertexEventType.V_ROUTE_EVENT, VertexEventType.V_TASK_RESCHEDULED, VertexEventType.V_TASK_ATTEMPT_COMPLETED, VertexEventType.V_ONE_TO_ONE_SOURCE_SPLIT, VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, VertexEventType.V_TASK_COMPLETED, VertexEventType.V_ROOT_INPUT_INITIALIZED, VertexEventType.V_ROOT_INPUT_FAILED})).addTransition((Enum)VertexState.ERROR, (Enum)VertexState.ERROR, EnumSet.of(VertexEventType.V_INIT, new VertexEventType[]{VertexEventType.V_SOURCE_VERTEX_STARTED, VertexEventType.V_START, VertexEventType.V_ROUTE_EVENT, VertexEventType.V_TERMINATE, VertexEventType.V_TASK_COMPLETED, VertexEventType.V_TASK_ATTEMPT_COMPLETED, VertexEventType.V_ONE_TO_ONE_SOURCE_SPLIT, VertexEventType.V_SOURCE_TASK_ATTEMPT_COMPLETED, VertexEventType.V_TASK_RESCHEDULED, VertexEventType.V_INTERNAL_ERROR, VertexEventType.V_ROOT_INPUT_INITIALIZED, VertexEventType.V_ROOT_INPUT_FAILED})).installTopology();
    private final StateMachine<VertexState, VertexEventType, VertexEvent> stateMachine;
    private int numTasks;
    private int completedTaskCount = 0;
    private int succeededTaskCount = 0;
    private int failedTaskCount = 0;
    private int killedTaskCount = 0;
    private long initTimeRequested;
    private long initedTime;
    private long startTimeRequested;
    private long startedTime;
    private long finishTime;
    private float progress;
    private Credentials credentials;
    private final TezVertexID vertexId;
    private final DAGProtos.VertexPlan vertexPlan;
    private final String vertexName;
    private final ProcessorDescriptor processorDescriptor;
    private final VertexContext vertexContext;
    @VisibleForTesting
    Map<Vertex, Edge> sourceVertices;
    private Map<Vertex, Edge> targetVertices;
    private Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> additionalInputs;
    private Map<String, RootInputLeafOutputDescriptor<OutputDescriptor>> additionalOutputs;
    private final List<InputSpec> additionalInputSpecs = new ArrayList<InputSpec>();
    private final List<OutputSpec> additionalOutputSpecs = new ArrayList<OutputSpec>();
    private Set<String> inputsWithInitializers;
    private int numInitializedInputs;
    private boolean startSignalPending = false;
    List<TezEvent> pendingRouteEvents = null;
    List<TezTaskAttemptID> pendingReportedSrcCompletions = Lists.newLinkedList();
    private RootInputInitializerRunner rootInputInitializer;
    private VertexScheduler vertexScheduler;
    private boolean parallelismSet = false;
    private TezVertexID originalOneToOneSplitSource = null;
    private VertexOutputCommitter committer;
    private AtomicBoolean committed = new AtomicBoolean(false);
    private VertexLocationHint vertexLocationHint;
    private Map<String, LocalResource> localResources;
    private Map<String, String> environment;
    private final String javaOpts;
    private final ContainerContext containerContext;
    private VertexTerminationCause terminationCause;
    private String logIdentifier;

    public VertexImpl(TezVertexID vertexId, DAGProtos.VertexPlan vertexPlan, String vertexName, Configuration conf, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Credentials credentials, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, VertexLocationHint vertexLocationHint) {
        this.vertexId = vertexId;
        this.vertexPlan = vertexPlan;
        this.vertexName = vertexName;
        this.conf = conf;
        this.clock = clock;
        this.appContext = appContext;
        this.taskAttemptListener = taskAttemptListener;
        this.taskHeartbeatHandler = thh;
        this.eventHandler = eventHandler;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.credentials = credentials;
        this.committer = new NullVertexOutputCommitter();
        this.vertexLocationHint = vertexLocationHint;
        if (LOG.isDebugEnabled()) {
            VertexImpl.logLocationHints(this.vertexLocationHint);
        }
        this.taskResource = DagTypeConverters.createResourceRequestFromTaskConfig((DAGProtos.PlanTaskConfiguration)vertexPlan.getTaskConfig());
        this.processorDescriptor = DagTypeConverters.convertProcessorDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)vertexPlan.getProcessorDescriptor());
        this.localResources = DagTypeConverters.createLocalResourceMapFromDAGPlan((List)vertexPlan.getTaskConfig().getLocalResourceList());
        this.localResources.putAll(appContext.getSessionResources());
        this.environment = DagTypeConverters.createEnvironmentMapFromDAGPlan((List)vertexPlan.getTaskConfig().getEnvironmentSettingList());
        this.javaOpts = vertexPlan.getTaskConfig().hasJavaOpts() ? vertexPlan.getTaskConfig().getJavaOpts() : null;
        this.vertexContext = new VertexContext(this.getDAGId(), this.processorDescriptor.getUserPayload(), this.vertexId, this.getApplicationAttemptId());
        this.containerContext = new ContainerContext(this.localResources, this.credentials, this.environment, this.javaOpts, this);
        if (vertexPlan.getInputsCount() > 0) {
            this.setAdditionalInputs(vertexPlan.getInputsList());
        }
        if (vertexPlan.getOutputsCount() > 0) {
            this.setAdditionalOutputs(vertexPlan.getOutputsList());
        }
        this.logIdentifier = this.getVertexId() + " [" + this.getName() + "]";
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    protected StateMachine<VertexState, VertexEventType, VertexEvent> getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public TezVertexID getVertexId() {
        return this.vertexId;
    }

    @Override
    public DAGProtos.VertexPlan getVertexPlan() {
        return this.vertexPlan;
    }

    @Override
    public int getDistanceFromRoot() {
        return this.distanceFromRoot;
    }

    @Override
    public String getName() {
        return this.vertexName;
    }

    EventHandler getEventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task getTask(TezTaskID taskID) {
        this.readLock.lock();
        try {
            Task task = this.tasks.get(taskID);
            return task;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task getTask(int taskIndex) {
        this.readLock.lock();
        try {
            LinkedHashMap<TezTaskID, Task> taskList = this.tasks;
            int i = 0;
            for (Map.Entry<TezTaskID, Task> entry : taskList.entrySet()) {
                if (taskIndex == i) {
                    Task task = entry.getValue();
                    return task;
                }
                ++i;
            }
            Task task = null;
            return task;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getTotalTasks() {
        return this.numTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCompletedTasks() {
        this.readLock.lock();
        try {
            int n = this.succeededTaskCount + this.failedTaskCount + this.killedTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSucceededTasks() {
        this.readLock.lock();
        try {
            int n = this.succeededTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRunningTasks() {
        this.readLock.lock();
        try {
            int num = 0;
            for (Task task : this.tasks.values()) {
                if (task.getState() != TaskState.RUNNING) continue;
                ++num;
            }
            int n = num;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TezCounters getAllCounters() {
        this.readLock.lock();
        try {
            VertexState state = this.getInternalState();
            if (state == VertexState.ERROR || state == VertexState.FAILED || state == VertexState.KILLED || state == VertexState.SUCCEEDED) {
                this.mayBeConstructFinalFullCounters();
                TezCounters tezCounters = this.fullCounters;
                return tezCounters;
            }
            TezCounters counters = new TezCounters();
            TezCounters tezCounters = VertexImpl.incrTaskCounters(counters, this.tasks.values());
            return tezCounters;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static TezCounters incrTaskCounters(TezCounters counters, Collection<Task> tasks) {
        for (Task task : tasks) {
            counters.incrAllCounters((AbstractCounters)task.getCounters());
        }
        return counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List<String> list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            this.computeProgress();
            float f = this.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressBuilder getVertexProgress() {
        this.readLock.lock();
        try {
            ProgressBuilder progress = new ProgressBuilder();
            progress.setTotalTaskCount(this.numTasks);
            progress.setSucceededTaskCount(this.succeededTaskCount);
            progress.setRunningTaskCount(this.getRunningTasks());
            progress.setFailedTaskCount(this.failedTaskCount);
            progress.setKilledTaskCount(this.killedTaskCount);
            ProgressBuilder progressBuilder = progress;
            return progressBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VertexStatusBuilder getVertexStatus(Set<StatusGetOpts> statusOptions) {
        this.readLock.lock();
        try {
            VertexStatusBuilder status = new VertexStatusBuilder();
            status.setState(this.getInternalState());
            status.setDiagnostics(this.diagnostics);
            status.setProgress(this.getVertexProgress());
            if (statusOptions.contains(StatusGetOpts.GET_COUNTERS)) {
                status.setVertexCounters(this.getAllCounters());
            }
            VertexStatusBuilder vertexStatusBuilder = status;
            return vertexStatusBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeProgress() {
        this.readLock.lock();
        try {
            float progress = 0.0f;
            for (Task task : this.tasks.values()) {
                progress += task.isFinished() ? 1.0f : task.getProgress();
            }
            if (this.numTasks != 0) {
                progress /= (float)this.numTasks;
            }
            this.progress = progress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TezTaskID, Task> getTasks() {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            this.lazyTasksCopyNeeded = true;
            return Collections.unmodifiableMap(this.tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VertexState getState() {
        this.readLock.lock();
        try {
            VertexState vertexState = (VertexState)this.getStateMachine().getCurrentState();
            return vertexState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    boolean trySetTerminationCause(VertexTerminationCause trigger) {
        if (this.terminationCause == null) {
            this.terminationCause = trigger;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VertexTerminationCause getTerminationCause() {
        this.readLock.lock();
        try {
            VertexTerminationCause vertexTerminationCause = this.terminationCause;
            return vertexTerminationCause;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleTasks(Collection<TezTaskID> taskIDs) {
        this.readLock.lock();
        try {
            for (TezTaskID taskID : taskIDs) {
                this.eventHandler.handle((Event)new TaskEvent(taskID, TaskEventType.T_SCHEDULE));
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParallelism(int parallelism, Map<Vertex, EdgeManager> sourceEdgeManagers) {
        this.writeLock.lock();
        try {
            Preconditions.checkState((!this.parallelismSet ? 1 : 0) != 0, (Object)"Parallelism can only be set dynamically once per vertex");
            this.parallelismSet = true;
            if (this.numTasks == -1) {
                Preconditions.checkArgument((sourceEdgeManagers == null ? 1 : 0) != 0, (Object)"SourceEdge managers cannot be set when determining initial parallelism");
                this.numTasks = parallelism;
                this.createTasks();
                LOG.info((Object)("Vertex " + this.getVertexId() + " parallelism set to " + parallelism));
            } else {
                if (parallelism >= this.numTasks) {
                    throw new TezUncheckedException("Increasing parallelism is not supported");
                }
                if (parallelism == this.numTasks) {
                    LOG.info((Object)("Ingoring setParallelism to current value: " + parallelism));
                    return;
                }
                for (Edge edge : this.sourceVertices.values()) {
                    edge.startEventBuffering();
                }
                HashSet<TezEvent> pendingEvents = new HashSet<TezEvent>();
                LOG.info((Object)("Vertex " + this.getVertexId() + " parallelism set to " + parallelism + " from " + this.numTasks));
                LinkedHashMap<TezTaskID, Task> linkedHashMap = this.tasks;
                Iterator<Map.Entry<TezTaskID, Task>> iter = linkedHashMap.entrySet().iterator();
                int i = 0;
                while (iter.hasNext()) {
                    ++i;
                    Map.Entry<TezTaskID, Task> entry = iter.next();
                    Task task = entry.getValue();
                    if (task.getState() != TaskState.NEW) {
                        throw new TezUncheckedException("All tasks must be in initial state when changing parallelism for vertex: " + this.getVertexId() + " name: " + this.getName());
                    }
                    pendingEvents.addAll(task.getAndClearTaskTezEvents());
                    if (i <= parallelism) continue;
                    LOG.info((Object)("Removing task: " + entry.getKey()));
                    iter.remove();
                }
                this.numTasks = parallelism;
                assert (this.tasks.size() == this.numTasks);
                if (sourceEdgeManagers != null) {
                    for (Map.Entry<Vertex, EdgeManager> entry : sourceEdgeManagers.entrySet()) {
                        Vertex sourceVertex = entry.getKey();
                        EdgeManager edgeManager = entry.getValue();
                        Edge edge = this.sourceVertices.get(sourceVertex);
                        LOG.info((Object)("Replacing edge manager for source:" + sourceVertex.getVertexId() + " destination: " + this.getVertexId()));
                        edge.setEdgeManager(edgeManager);
                    }
                }
                DAG dag = this.getDAG();
                for (TezEvent event : pendingEvents) {
                    TezVertexID sourceVertexId = event.getSourceInfo().getTaskAttemptID().getTaskID().getVertexID();
                    Vertex sourceVertex = dag.getVertex(sourceVertexId);
                    Edge sourceEdge = this.sourceVertices.get(sourceVertex);
                    sourceEdge.sendTezEventToDestinationTasks(event);
                }
                for (Edge edge : this.sourceVertices.values()) {
                    edge.stopEventBuffering();
                }
            }
            for (Map.Entry entry : this.targetVertices.entrySet()) {
                Edge edge = (Edge)entry.getValue();
                if (edge.getEdgeProperty().getDataMovementType() != EdgeProperty.DataMovementType.ONE_TO_ONE) continue;
                VertexEventOneToOneSourceSplit event = new VertexEventOneToOneSourceSplit(((Vertex)entry.getKey()).getVertexId(), this.getVertexId(), this.originalOneToOneSplitSource != null ? this.originalOneToOneSplitSource : this.getVertexId(), this.numTasks);
                this.getEventHandler().handle((Event)event);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVertexLocationHint(VertexLocationHint vertexLocationHint) {
        this.writeLock.lock();
        try {
            this.vertexLocationHint = vertexLocationHint;
            if (LOG.isDebugEnabled()) {
                VertexImpl.logLocationHints(this.vertexLocationHint);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(VertexEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing VertexEvent " + event.getVertexId() + " of type " + event.getType() + " while in state " + (Object)((Object)this.getInternalState()) + ". Event: " + (Object)((Object)event)));
        }
        try {
            this.writeLock.lock();
            VertexState oldState = this.getInternalState();
            try {
                this.getStateMachine().doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                String message = "Invalid event " + event.getType() + " on vertex " + this.vertexName + " with vertexId " + this.vertexId + " at current state " + (Object)((Object)oldState);
                LOG.error((Object)("Can't handle " + message), (Throwable)e);
                this.addDiagnostic(message);
                this.eventHandler.handle((Event)new VertexEvent(this.vertexId, VertexEventType.V_INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.vertexId + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VertexState getInternalState() {
        this.readLock.lock();
        try {
            VertexState vertexState = (VertexState)this.getStateMachine().getCurrentState();
            return vertexState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(Task task) {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            if (this.lazyTasksCopyNeeded) {
                LinkedHashMap<TezTaskID, Task> newTasks = new LinkedHashMap<TezTaskID, Task>();
                newTasks.putAll(this.tasks);
                this.tasks = newTasks;
                this.lazyTasksCopyNeeded = false;
            }
        }
        this.tasks.put(task.getTaskId(), task);
    }

    void setFinishTime() {
        this.finishTime = this.clock.getTime();
    }

    void logJobHistoryVertexStartedEvent() {
        VertexStartedEvent startEvt = new VertexStartedEvent(this.vertexId, this.vertexName, this.initTimeRequested, this.initedTime, this.startTimeRequested, this.startedTime, this.numTasks, this.getProcessorName());
        this.eventHandler.handle((Event)new DAGHistoryEvent(startEvt));
    }

    void logJobHistoryVertexFinishedEvent() {
        this.setFinishTime();
        VertexFinishedEvent finishEvt = new VertexFinishedEvent(this.vertexId, this.vertexName, this.initTimeRequested, this.initedTime, this.startTimeRequested, this.startedTime, this.finishTime, VertexStatus.State.SUCCEEDED, "", this.getAllCounters());
        this.eventHandler.handle((Event)new DAGHistoryEvent(finishEvt));
    }

    void logJobHistoryVertexFailedEvent(VertexStatus.State state) {
        VertexFinishedEvent finishEvt = new VertexFinishedEvent(this.vertexId, this.vertexName, this.initTimeRequested, this.initedTime, this.startTimeRequested, this.startedTime, this.clock.getTime(), state, StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()), this.getAllCounters());
        this.eventHandler.handle((Event)new DAGHistoryEvent(finishEvt));
    }

    static VertexState checkVertexForCompletion(VertexImpl vertex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for vertex completion, failedTaskCount=" + vertex.failedTaskCount + ", killedTaskCount=" + vertex.killedTaskCount + ", successfulTaskCount=" + vertex.succeededTaskCount + ", completedTaskCount=" + vertex.completedTaskCount + ", terminationCause=" + (Object)((Object)vertex.terminationCause)));
        }
        if (vertex.completedTaskCount > vertex.tasks.size()) {
            LOG.error((Object)("task completion accounting issue: completedTaskCount > nTasks:, failedTaskCount=" + vertex.failedTaskCount + ", killedTaskCount=" + vertex.killedTaskCount + ", successfulTaskCount=" + vertex.succeededTaskCount + ", completedTaskCount=" + vertex.completedTaskCount + ", terminationCause=" + (Object)((Object)vertex.terminationCause)));
        }
        if (vertex.completedTaskCount == vertex.tasks.size()) {
            if (vertex.succeededTaskCount == vertex.tasks.size() && vertex.terminationCause == null) {
                try {
                    if (!vertex.committed.getAndSet(true)) {
                        vertex.committer.commitVertex();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to do commit on vertex, name=" + vertex.getName()), (Throwable)e);
                    vertex.trySetTerminationCause(VertexTerminationCause.COMMIT_FAILURE);
                    return vertex.finished(VertexState.FAILED);
                }
                return vertex.finished(VertexState.SUCCEEDED);
            }
            if (vertex.terminationCause == VertexTerminationCause.DAG_KILL) {
                vertex.setFinishTime();
                String diagnosticMsg = "Vertex killed due to user-initiated job kill. failedTasks:" + vertex.failedTaskCount;
                LOG.info((Object)diagnosticMsg);
                vertex.addDiagnostic(diagnosticMsg);
                vertex.abortVertex(VertexStatus.State.KILLED);
                return vertex.finished(VertexState.KILLED);
            }
            if (vertex.terminationCause == VertexTerminationCause.OTHER_VERTEX_FAILURE) {
                vertex.setFinishTime();
                String diagnosticMsg = "Vertex killed as other vertex failed. failedTasks:" + vertex.failedTaskCount;
                LOG.info((Object)diagnosticMsg);
                vertex.addDiagnostic(diagnosticMsg);
                vertex.abortVertex(VertexStatus.State.KILLED);
                return vertex.finished(VertexState.KILLED);
            }
            if (vertex.terminationCause == VertexTerminationCause.OWN_TASK_FAILURE) {
                if (vertex.failedTaskCount == 0) {
                    LOG.error((Object)"task failure accounting error.  terminationCause=TASK_FAILURE but vertex.failedTaskCount == 0");
                }
                vertex.setFinishTime();
                String diagnosticMsg = "Vertex failed as one or more tasks failed. failedTasks:" + vertex.failedTaskCount;
                LOG.info((Object)diagnosticMsg);
                vertex.addDiagnostic(diagnosticMsg);
                vertex.abortVertex(VertexStatus.State.FAILED);
                return vertex.finished(VertexState.FAILED);
            }
            throw new TezUncheckedException("All tasks complete, but cannot determine final state of vertex, failedTaskCount=" + vertex.failedTaskCount + ", killedTaskCount=" + vertex.killedTaskCount + ", successfulTaskCount=" + vertex.succeededTaskCount + ", completedTaskCount=" + vertex.completedTaskCount + ", terminationCause=" + (Object)((Object)vertex.terminationCause));
        }
        return vertex.getInternalState();
    }

    void enactKill(VertexTerminationCause trigger, TaskTerminationCause taskterminationCause) {
        if (this.trySetTerminationCause(trigger)) {
            for (Task task : this.tasks.values()) {
                this.eventHandler.handle((Event)new TaskEventTermination(task.getTaskId(), taskterminationCause));
            }
        }
    }

    VertexState finished(VertexState finalState, VertexTerminationCause terminationCause) {
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        switch (finalState) {
            case KILLED: {
                this.eventHandler.handle((Event)new DAGEventVertexCompleted(this.getVertexId(), finalState, terminationCause));
                this.logJobHistoryVertexFailedEvent(VertexStatus.State.KILLED);
                break;
            }
            case ERROR: {
                this.eventHandler.handle((Event)new DAGEvent(this.getDAGId(), DAGEventType.INTERNAL_ERROR));
                this.logJobHistoryVertexFailedEvent(VertexStatus.State.FAILED);
                break;
            }
            case FAILED: {
                this.eventHandler.handle((Event)new DAGEventVertexCompleted(this.getVertexId(), finalState, terminationCause));
                this.logJobHistoryVertexFailedEvent(VertexStatus.State.FAILED);
                break;
            }
            case SUCCEEDED: {
                this.eventHandler.handle((Event)new DAGEventVertexCompleted(this.getVertexId(), finalState));
                this.logJobHistoryVertexFinishedEvent();
                break;
            }
            default: {
                throw new TezUncheckedException("Unexpected VertexState: " + (Object)((Object)finalState));
            }
        }
        return finalState;
    }

    VertexState finished(VertexState finalState) {
        return this.finished(finalState, null);
    }

    private VertexState initializeVertex() {
        if (!this.additionalOutputSpecs.isEmpty()) {
            this.committer = new MRVertexOutputCommitter();
        }
        try {
            this.committer.init(this.vertexContext);
            this.committer.setupVertex();
        }
        catch (IOException e) {
            LOG.warn((Object)"Vertex init failed", (Throwable)e);
            this.addDiagnostic("Job init failed : " + StringUtils.stringifyException((Throwable)e));
            this.trySetTerminationCause(VertexTerminationCause.INIT_FAILURE);
            this.abortVertex(VertexStatus.State.FAILED);
            return this.finished(VertexState.FAILED);
        }
        this.initedTime = this.clock.getTime();
        return VertexState.INITED;
    }

    private void checkTaskLimits() {
    }

    private void createTasks() {
        Configuration conf = this.conf;
        boolean useNullLocationHint = true;
        if (this.vertexLocationHint != null && this.vertexLocationHint.getTaskLocationHints() != null && this.vertexLocationHint.getTaskLocationHints().size() == this.numTasks) {
            useNullLocationHint = false;
        }
        for (int i = 0; i < this.numTasks; ++i) {
            VertexLocationHint.TaskLocationHint locHint = null;
            if (!useNullLocationHint) {
                locHint = (VertexLocationHint.TaskLocationHint)this.vertexLocationHint.getTaskLocationHints().get(i);
            }
            TaskImpl task = new TaskImpl(this.getVertexId(), i, this.eventHandler, conf, this.taskAttemptListener, this.clock, this.taskHeartbeatHandler, this.appContext, this.targetVertices != null ? this.targetVertices.isEmpty() : true, locHint, this.taskResource, this.containerContext);
            this.addTask(task);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Created task for vertex " + this.getVertexId() + ": " + task.getTaskId()));
        }
    }

    @VisibleForTesting
    protected RootInputInitializerRunner createRootInputInitializerRunner(String dagName, String vertexName, TezVertexID vertexID, EventHandler eventHandler, int numTasks) {
        return new RootInputInitializerRunner(dagName, vertexName, vertexID, eventHandler, numTasks);
    }

    private VertexState initializeVertexInInitializingState() {
        VertexState vertexState = this.initializeVertex();
        if (vertexState == VertexState.FAILED) {
            return vertexState;
        }
        if (this.pendingRouteEvents != null) {
            ROUTE_EVENT_TRANSITION.transition(this, new VertexEventRouteEvent(this.getVertexId(), this.pendingRouteEvents));
            this.pendingRouteEvents = null;
        }
        return vertexState;
    }

    private void startVertex() {
        this.startedTime = this.clock.getTime();
        this.vertexScheduler.onVertexStarted(this.pendingReportedSrcCompletions);
        this.pendingReportedSrcCompletions.clear();
        this.logJobHistoryVertexStartedEvent();
        if (this.targetVertices != null) {
            for (Vertex targetVertex : this.targetVertices.keySet()) {
                this.eventHandler.handle((Event)new VertexEventSourceVertexStarted(targetVertex.getVertexId(), this.distanceFromRoot));
            }
        }
        if (this.numTasks == 0) {
            this.eventHandler.handle((Event)new VertexEvent(this.vertexId, VertexEventType.V_COMPLETED));
        }
    }

    private void abortVertex(VertexStatus.State finalState) {
        try {
            this.committer.abortVertex(finalState);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not abort vertex, name=" + this.getName()), (Throwable)e);
        }
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayBeConstructFinalFullCounters() {
        Object object = this.fullCountersLock;
        synchronized (object) {
            if (this.fullCounters != null) {
                return;
            }
            this.constructFinalFullcounters();
        }
    }

    @InterfaceAudience.Private
    public void constructFinalFullcounters() {
        this.fullCounters = new TezCounters();
        for (Task t : this.tasks.values()) {
            TezCounters counters = t.getCounters();
            this.fullCounters.incrAllCounters((AbstractCounters)counters);
        }
    }

    private void addDiagnostic(String diag) {
        this.diagnostics.add(diag);
    }

    private static boolean isEventFromVertex(Vertex vertex, EventMetaData sourceMeta) {
        return sourceMeta.getTaskVertexName().equals(vertex.getName());
    }

    private static void checkEventSourceMetadata(Vertex vertex, EventMetaData sourceMeta) {
        if (!VertexImpl.isEventFromVertex(vertex, sourceMeta)) {
            throw new TezUncheckedException("Bad routing of event, Event-vertex=" + sourceMeta.getTaskVertexName() + ", Expected=" + vertex.getName());
        }
    }

    @Override
    public void setInputVertices(Map<Vertex, Edge> inVertices) {
        this.sourceVertices = inVertices;
    }

    @Override
    public void setOutputVertices(Map<Vertex, Edge> outVertices) {
        this.targetVertices = outVertices;
    }

    @Override
    public void setAdditionalInputs(List<DAGProtos.RootInputLeafOutputProto> inputs) {
        Preconditions.checkArgument((inputs.size() < 2 ? 1 : 0) != 0, (Object)"For now, only a single root input can be specified on a Vertex");
        this.additionalInputs = Maps.newHashMapWithExpectedSize((int)inputs.size());
        for (DAGProtos.RootInputLeafOutputProto input : inputs) {
            InputDescriptor id = DagTypeConverters.convertInputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)input.getEntityDescriptor());
            this.additionalInputs.put(input.getName(), new RootInputLeafOutputDescriptor<InputDescriptor>(input.getName(), id, input.hasInitializerClassName() ? input.getInitializerClassName() : null));
            InputSpec inputSpec = new InputSpec(input.getName(), id, 0);
            this.additionalInputSpecs.add(inputSpec);
        }
    }

    @Override
    public void setAdditionalOutputs(List<DAGProtos.RootInputLeafOutputProto> outputs) {
        LOG.info((Object)("setting additional outputs for vertex " + this.vertexName));
        this.additionalOutputs = Maps.newHashMapWithExpectedSize((int)outputs.size());
        for (DAGProtos.RootInputLeafOutputProto output : outputs) {
            OutputDescriptor od = DagTypeConverters.convertOutputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)output.getEntityDescriptor());
            this.additionalOutputs.put(output.getName(), new RootInputLeafOutputDescriptor<OutputDescriptor>(output.getName(), od, output.hasInitializerClassName() ? output.getInitializerClassName() : null));
            OutputSpec outputSpec = new OutputSpec(output.getName(), od, 0);
            this.additionalOutputSpecs.add(outputSpec);
        }
    }

    @Override
    public Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> getAdditionalInputs() {
        return this.additionalInputs;
    }

    @Override
    public Map<String, RootInputLeafOutputDescriptor<OutputDescriptor>> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    @Override
    public int compareTo(Vertex other) {
        return this.vertexId.compareTo((TezID)other.getVertexId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return this.vertexId.equals((Object)other.getVertexId());
    }

    public int hashCode() {
        int prime = 11239;
        return 11239 + 11239 * this.vertexId.hashCode();
    }

    @Override
    public Map<Vertex, Edge> getInputVertices() {
        return Collections.unmodifiableMap(this.sourceVertices);
    }

    @Override
    public Map<Vertex, Edge> getOutputVertices() {
        return Collections.unmodifiableMap(this.targetVertices);
    }

    @Override
    public int getInputVerticesCount() {
        return this.sourceVertices.size();
    }

    @Override
    public int getOutputVerticesCount() {
        return this.targetVertices.size();
    }

    @Override
    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    @Override
    public DAG getDAG() {
        return this.appContext.getCurrentDAG();
    }

    private TezDAGID getDAGId() {
        return this.getDAG().getID();
    }

    private ApplicationAttemptId getApplicationAttemptId() {
        return this.appContext.getApplicationAttemptId();
    }

    @Override
    public Resource getTaskResource() {
        return this.taskResource;
    }

    @VisibleForTesting
    String getProcessorName() {
        return this.processorDescriptor.getClassName();
    }

    @VisibleForTesting
    String getJavaOpts() {
        return this.javaOpts;
    }

    @VisibleForTesting
    RootInputInitializerRunner getRootInputInitializerRunner() {
        return this.rootInputInitializer;
    }

    @VisibleForTesting
    VertexLocationHint getVertexLocationHint() {
        return this.vertexLocationHint;
    }

    @Override
    public synchronized List<InputSpec> getInputSpecList(int taskIndex) {
        this.inputSpecList = new ArrayList<InputSpec>(this.getInputVerticesCount() + this.additionalInputSpecs.size());
        this.inputSpecList.addAll(this.additionalInputSpecs);
        for (Map.Entry<Vertex, Edge> entry : this.getInputVertices().entrySet()) {
            InputSpec inputSpec = entry.getValue().getDestinationSpec(taskIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("For vertex : " + this.getName() + ", Using InputSpec : " + inputSpec));
            }
            this.inputSpecList.add(inputSpec);
        }
        return this.inputSpecList;
    }

    @Override
    public synchronized List<OutputSpec> getOutputSpecList(int taskIndex) {
        if (this.outputSpecList == null) {
            this.outputSpecList = new ArrayList<OutputSpec>(this.getOutputVerticesCount() + this.additionalOutputSpecs.size());
            this.outputSpecList.addAll(this.additionalOutputSpecs);
            for (Map.Entry<Vertex, Edge> entry : this.getOutputVertices().entrySet()) {
                OutputSpec outputSpec = entry.getValue().getSourceSpec(taskIndex);
                this.outputSpecList.add(outputSpec);
            }
        }
        return this.outputSpecList;
    }

    @VisibleForTesting
    VertexOutputCommitter getVertexOutputCommitter() {
        return this.committer;
    }

    @VisibleForTesting
    void setVertexOutputCommitter(VertexOutputCommitter committer) {
        this.committer = committer;
    }

    @VisibleForTesting
    VertexScheduler getVertexScheduler() {
        return this.vertexScheduler;
    }

    private static void logLocationHints(VertexLocationHint locationHint) {
        HashMultiset hosts = HashMultiset.create();
        HashMultiset racks = HashMultiset.create();
        int counter = 0;
        for (VertexLocationHint.TaskLocationHint taskLocationHint : locationHint.getTaskLocationHints()) {
            StringBuilder sb = new StringBuilder();
            if (taskLocationHint.getDataLocalHosts() == null) {
                sb.append("No Hosts");
            } else {
                sb.append("Hosts: ");
                for (String host : taskLocationHint.getDataLocalHosts()) {
                    hosts.add((Object)host);
                    sb.append(host).append(", ");
                }
            }
            if (taskLocationHint.getRacks() == null) {
                sb.append("No Racks");
            } else {
                sb.append("Racks: ");
                for (String rack : taskLocationHint.getRacks()) {
                    racks.add((Object)rack);
                    sb.append(rack).append(", ");
                }
            }
            LOG.debug((Object)("Location: " + counter + " : " + sb.toString()));
            ++counter;
        }
        LOG.debug((Object)"Host Counts");
        for (Multiset.Entry host : hosts.entrySet()) {
            LOG.debug((Object)("host: " + host.toString()));
        }
        LOG.debug((Object)"Rack Counts");
        for (Multiset.Entry rack : racks.entrySet()) {
            LOG.debug((Object)("rack: " + rack.toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalErrorTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private InternalErrorTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            LOG.error((Object)("Invalid event " + event.getType() + " on Vertex " + vertex.getVertexId()));
            vertex.eventHandler.handle((Event)new DAGEventDiagnosticsUpdate(vertex.getDAGId(), "Invalid event " + event.getType() + " on Vertex " + vertex.getVertexId()));
            vertex.setFinishTime();
            vertex.finished(VertexState.ERROR);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RouteEventTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private RouteEventTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventRouteEvent rEvent = (VertexEventRouteEvent)event;
            List<TezEvent> tezEvents = rEvent.getEvents();
            for (TezEvent tezEvent : tezEvents) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Vertex: " + vertex.getName() + " routing event: " + tezEvent.getEventType()));
                }
                EventMetaData sourceMeta = tezEvent.getSourceInfo();
                boolean isDataMovementEvent = true;
                switch (tezEvent.getEventType()) {
                    case INPUT_FAILED_EVENT: {
                        isDataMovementEvent = false;
                    }
                    case DATA_MOVEMENT_EVENT: {
                        if (VertexImpl.isEventFromVertex(vertex, sourceMeta)) {
                            TezTaskAttemptID srcTaId = sourceMeta.getTaskAttemptID();
                            if (isDataMovementEvent) {
                                ((DataMovementEvent)tezEvent.getEvent()).setVersion(srcTaId.getId());
                            } else {
                                ((InputFailedEvent)tezEvent.getEvent()).setVersion(srcTaId.getId());
                            }
                            Vertex destVertex = vertex.getDAG().getVertex(sourceMeta.getEdgeVertexName());
                            Edge destEdge = (Edge)vertex.targetVertices.get(destVertex);
                            if (destEdge == null) {
                                throw new TezUncheckedException("Bad destination vertex: " + sourceMeta.getEdgeVertexName() + " for event vertex: " + vertex.getVertexId());
                            }
                            vertex.eventHandler.handle((Event)new VertexEventRouteEvent(destVertex.getVertexId(), Collections.singletonList(tezEvent)));
                            break;
                        }
                        Edge srcEdge = vertex.sourceVertices.get(vertex.getDAG().getVertex(sourceMeta.getTaskVertexName()));
                        if (srcEdge == null) {
                            throw new TezUncheckedException("Bad source vertex: " + sourceMeta.getTaskVertexName() + " for destination vertex: " + vertex.getVertexId());
                        }
                        srcEdge.sendTezEventToDestinationTasks(tezEvent);
                        break;
                    }
                    case VERTEX_MANAGER_EVENT: {
                        VertexManagerEvent vmEvent = (VertexManagerEvent)tezEvent.getEvent();
                        Vertex target = vertex.getDAG().getVertex(vmEvent.getTargetVertexName());
                        if (target == vertex) {
                            vertex.vertexScheduler.onVertexManagerEventReceived(vmEvent);
                            break;
                        }
                        vertex.eventHandler.handle((Event)new VertexEventRouteEvent(target.getVertexId(), Collections.singletonList(tezEvent)));
                        break;
                    }
                    case INPUT_READ_ERROR_EVENT: {
                        VertexImpl.checkEventSourceMetadata(vertex, sourceMeta);
                        Edge srcEdge = vertex.sourceVertices.get(vertex.getDAG().getVertex(sourceMeta.getEdgeVertexName()));
                        srcEdge.sendTezEventToSourceTasks(tezEvent);
                        break;
                    }
                    case TASK_STATUS_UPDATE_EVENT: {
                        VertexImpl.checkEventSourceMetadata(vertex, sourceMeta);
                        TaskStatusUpdateEvent sEvent = (TaskStatusUpdateEvent)tezEvent.getEvent();
                        vertex.getEventHandler().handle((Event)new TaskAttemptEventStatusUpdate(sourceMeta.getTaskAttemptID(), sEvent));
                        break;
                    }
                    case TASK_ATTEMPT_COMPLETED_EVENT: {
                        VertexImpl.checkEventSourceMetadata(vertex, sourceMeta);
                        vertex.getEventHandler().handle((Event)new TaskAttemptEvent(sourceMeta.getTaskAttemptID(), TaskAttemptEventType.TA_DONE));
                        break;
                    }
                    case TASK_ATTEMPT_FAILED_EVENT: {
                        VertexImpl.checkEventSourceMetadata(vertex, sourceMeta);
                        TaskAttemptFailedEvent taskFailedEvent = (TaskAttemptFailedEvent)tezEvent.getEvent();
                        vertex.getEventHandler().handle((Event)new TaskAttemptEventAttemptFailed(sourceMeta.getTaskAttemptID(), TaskAttemptEventType.TA_FAILED, "Error: " + taskFailedEvent.getDiagnostics()));
                        break;
                    }
                    default: {
                        throw new TezUncheckedException("Unhandled tez event type: " + tezEvent.getEventType());
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RouteEventsWhileInitializingTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private RouteEventsWhileInitializingTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventRouteEvent re = (VertexEventRouteEvent)event;
            if (vertex.pendingRouteEvents == null) {
                vertex.pendingRouteEvents = Lists.newLinkedList();
            }
            vertex.pendingRouteEvents.addAll(re.getEvents());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskRescheduledAfterVertexSuccessTransition
    implements MultipleArcTransition<VertexImpl, VertexEvent, VertexState> {
        private TaskRescheduledAfterVertexSuccessTransition() {
        }

        public VertexState transition(VertexImpl vertex, VertexEvent event) {
            if (vertex.committer instanceof NullVertexOutputCommitter) {
                LOG.info((Object)(vertex.getVertexId() + " back to running due to rescheduling " + ((VertexEventTaskReschedule)event).getTaskID()));
                new TaskRescheduledTransition().transition(vertex, event);
                vertex.eventHandler.handle((Event)new DAGEventVertexReRunning(vertex.getVertexId()));
                return VertexState.RUNNING;
            }
            LOG.info((Object)(vertex.getVertexId() + " failed due to post-commit rescheduling of " + ((VertexEventTaskReschedule)event).getTaskID()));
            vertex.enactKill(VertexTerminationCause.OWN_TASK_FAILURE, TaskTerminationCause.OWN_TASK_FAILURE);
            vertex.eventHandler.handle((Event)new DAGEvent(vertex.getDAGId(), DAGEventType.INTERNAL_ERROR));
            return VertexState.FAILED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VertexNoTasksCompletedTransition
    implements MultipleArcTransition<VertexImpl, VertexEvent, VertexState> {
        VertexNoTasksCompletedTransition() {
        }

        public VertexState transition(VertexImpl vertex, VertexEvent event) {
            return VertexImpl.checkVertexForCompletion(vertex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskRescheduledTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private TaskRescheduledTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            vertex.completedTaskCount--;
            vertex.succeededTaskCount--;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskCompletedTransition
    implements MultipleArcTransition<VertexImpl, VertexEvent, VertexState> {
        private TaskCompletedTransition() {
        }

        public VertexState transition(VertexImpl vertex, VertexEvent event) {
            boolean forceTransitionToKillWait = false;
            vertex.completedTaskCount++;
            LOG.info((Object)("Num completed Tasks for " + vertex.logIdentifier + " : " + vertex.completedTaskCount));
            VertexEventTaskCompleted taskEvent = (VertexEventTaskCompleted)event;
            Task task = vertex.tasks.get(taskEvent.getTaskID());
            if (taskEvent.getState() == TaskState.SUCCEEDED) {
                this.taskSucceeded(vertex, task);
            } else if (taskEvent.getState() == TaskState.FAILED) {
                vertex.enactKill(VertexTerminationCause.OWN_TASK_FAILURE, TaskTerminationCause.OTHER_TASK_FAILURE);
                forceTransitionToKillWait = true;
                this.taskFailed(vertex, task);
            } else if (taskEvent.getState() == TaskState.KILLED) {
                this.taskKilled(vertex, task);
            }
            VertexState state = VertexImpl.checkVertexForCompletion(vertex);
            if (state == VertexState.RUNNING && forceTransitionToKillWait) {
                return VertexState.TERMINATING;
            }
            return state;
        }

        private void taskSucceeded(VertexImpl vertex, Task task) {
            vertex.succeededTaskCount++;
        }

        private void taskFailed(VertexImpl vertex, Task task) {
            vertex.failedTaskCount++;
            vertex.addDiagnostic("Task failed, taskId=" + task.getTaskId() + ", diagnostics=" + task.getDiagnostics());
        }

        private void taskKilled(VertexImpl vertex, Task task) {
            vertex.killedTaskCount++;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskAttemptCompletedEventTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private TaskAttemptCompletedEventTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventTaskAttemptCompleted completionEvent = (VertexEventTaskAttemptCompleted)event;
            if (vertex.targetVertices != null) {
                for (Vertex targetVertex : vertex.targetVertices.keySet()) {
                    vertex.eventHandler.handle((Event)new VertexEventSourceTaskAttemptCompleted(targetVertex.getVertexId(), completionEvent));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceTaskAttemptCompletedEventTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private SourceTaskAttemptCompletedEventTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventTaskAttemptCompleted completionEvent = ((VertexEventSourceTaskAttemptCompleted)event).getCompletionEvent();
            LOG.info((Object)("Source task attempt completed for vertex: " + vertex.getVertexId() + " attempt: " + completionEvent.getTaskAttemptId() + " with state: " + (Object)((Object)completionEvent.getTaskAttemptState()) + " vertexState: " + (Object)((Object)vertex.getState())));
            if (TaskAttemptStateInternal.SUCCEEDED.equals((Object)completionEvent.getTaskAttemptState())) {
                ++vertex.numSuccessSourceAttemptCompletions;
                if (vertex.getState() == VertexState.RUNNING) {
                    vertex.vertexScheduler.onSourceTaskCompleted(completionEvent.getTaskAttemptId());
                } else {
                    vertex.pendingReportedSrcCompletions.add(completionEvent.getTaskAttemptId());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VertexKilledTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private VertexKilledTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            vertex.addDiagnostic("Vertex received Kill while in RUNNING state.");
            VertexEventTermination vet = (VertexEventTermination)event;
            VertexTerminationCause trigger = vet.getTerminationCause();
            switch (trigger) {
                case DAG_KILL: {
                    vertex.enactKill(trigger, TaskTerminationCause.DAG_KILL);
                    break;
                }
                case OTHER_VERTEX_FAILURE: {
                    vertex.enactKill(trigger, TaskTerminationCause.OTHER_VERTEX_FAILURE);
                    break;
                }
                case OWN_TASK_FAILURE: {
                    vertex.enactKill(trigger, TaskTerminationCause.OTHER_TASK_FAILURE);
                    break;
                }
                default: {
                    throw new TezUncheckedException("VertexKilledTransition: event.terminationCause is unexpected: " + (Object)((Object)trigger));
                }
            }
        }
    }

    private static class TerminateInitingVertexTransition
    extends TerminateInitedVertexTransition {
        private TerminateInitingVertexTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            super.transition(vertex, event);
            if (vertex.rootInputInitializer != null) {
                vertex.rootInputInitializer.shutdown();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TerminateInitedVertexTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private TerminateInitedVertexTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventTermination vet = (VertexEventTermination)event;
            vertex.trySetTerminationCause(vet.getTerminationCause());
            vertex.abortVertex(VertexStatus.State.KILLED);
            vertex.addDiagnostic("Vertex received Kill in INITED state.");
            vertex.finished(VertexState.KILLED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TerminateNewVertexTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private TerminateNewVertexTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventTermination vet = (VertexEventTermination)event;
            vertex.trySetTerminationCause(vet.getTerminationCause());
            vertex.setFinishTime();
            vertex.addDiagnostic("Vertex received Kill in NEW state.");
            vertex.finished(VertexState.KILLED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootInputInitFailedTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        private RootInputInitFailedTransition() {
        }

        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventRootInputFailed fe = (VertexEventRootInputFailed)event;
            vertex.trySetTerminationCause(VertexTerminationCause.INIT_FAILURE);
            vertex.addDiagnostic("Vertex Input: " + fe.getInputName() + " initializer failed.");
            if (fe.getError() != null) {
                LOG.error((Object)("Vertex Input: " + fe.getInputName() + " initializer failed"), fe.getError());
                if (fe.getError().getMessage() != null) {
                    vertex.addDiagnostic(fe.getError().getMessage());
                }
            }
            if (vertex.rootInputInitializer != null) {
                vertex.rootInputInitializer.shutdown();
            }
            vertex.finished(VertexState.FAILED, VertexTerminationCause.ROOT_INPUT_INIT_FAILURE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        public void transition(VertexImpl vertex, VertexEvent event) {
            vertex.startTimeRequested = vertex.clock.getTime();
            vertex.startVertex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartWhileInitializingTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        public void transition(VertexImpl vertex, VertexEvent event) {
            vertex.startTimeRequested = vertex.clock.getTime();
            vertex.startSignalPending = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SourceVertexStartedTransition
    implements SingleArcTransition<VertexImpl, VertexEvent> {
        public void transition(VertexImpl vertex, VertexEvent event) {
            VertexEventSourceVertexStarted startEvent = (VertexEventSourceVertexStarted)event;
            int distanceFromRoot = startEvent.getSourceDistanceFromRoot() + 1;
            if (vertex.distanceFromRoot < distanceFromRoot) {
                vertex.distanceFromRoot = distanceFromRoot;
            }
            vertex.numStartedSourceVertices++;
            if (vertex.numStartedSourceVertices == vertex.sourceVertices.size()) {
                LOG.info((Object)("Starting vertex: " + vertex.getVertexId() + " with name: " + vertex.getName() + " with distanceFromRoot: " + vertex.distanceFromRoot));
                vertex.eventHandler.handle((Event)new VertexEvent(vertex.vertexId, VertexEventType.V_START));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OneToOneSourceSplitTransition
    implements MultipleArcTransition<VertexImpl, VertexEvent, VertexState> {
        public VertexState transition(VertexImpl vertex, VertexEvent event) {
            VertexEventOneToOneSourceSplit splitEvent = (VertexEventOneToOneSourceSplit)event;
            TezVertexID originalSplitSource = splitEvent.getOriginalSplitSource();
            if (vertex.originalOneToOneSplitSource != null) {
                Preconditions.checkState((vertex.getState() == VertexState.INITED ? 1 : 0) != 0, (Object)(" Unexpected 1-1 split for vertex " + vertex.getVertexId() + " in state " + (Object)((Object)vertex.getState()) + " . Split in vertex " + originalSplitSource + " sent by vertex " + splitEvent.getSenderVertex() + " numTasks " + splitEvent.getNumTasks()));
                if (vertex.originalOneToOneSplitSource.equals((Object)originalSplitSource)) {
                    LOG.info((Object)("Ignoring split of vertex " + vertex.getVertexId() + " because of split in vertex " + originalSplitSource + " sent by vertex " + splitEvent.getSenderVertex() + " numTasks " + splitEvent.getNumTasks()));
                    return VertexState.INITED;
                }
                throw new TezUncheckedException("Vertex: " + vertex.getVertexId() + " asked to split by: " + originalSplitSource + " but was already split by:" + vertex.originalOneToOneSplitSource);
            }
            Preconditions.checkState((vertex.getState() == VertexState.INITIALIZING ? 1 : 0) != 0, (Object)(" Unexpected 1-1 split for vertex " + vertex.getVertexId() + " in state " + (Object)((Object)vertex.getState()) + " . Split in vertex " + originalSplitSource + " sent by vertex " + splitEvent.getSenderVertex() + " numTasks " + splitEvent.getNumTasks()));
            LOG.info((Object)("Splitting vertex " + vertex.getVertexId() + " because of split in vertex " + originalSplitSource + " sent by vertex " + splitEvent.getSenderVertex() + " numTasks " + splitEvent.getNumTasks()));
            vertex.originalOneToOneSplitSource = originalSplitSource;
            vertex.setParallelism(splitEvent.getNumTasks(), null);
            return vertex.initializeVertexInInitializingState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RootInputInitializedTransition
    implements MultipleArcTransition<VertexImpl, VertexEvent, VertexState> {
        public VertexState transition(VertexImpl vertex, VertexEvent event) {
            VertexEventRootInputInitialized liInitEvent = (VertexEventRootInputInitialized)event;
            vertex.vertexScheduler.onRootVertexInitialized(liInitEvent.getInputName(), vertex.getAdditionalInputs().get(liInitEvent.getInputName()).getDescriptor(), liInitEvent.getEvents());
            vertex.numInitializedInputs++;
            if (vertex.numInitializedInputs == vertex.inputsWithInitializers.size()) {
                vertex.rootInputInitializer.shutdown();
                VertexState vertexState = vertex.initializeVertexInInitializingState();
                if (vertexState == VertexState.FAILED) {
                    return VertexState.FAILED;
                }
                if (vertex.startSignalPending) {
                    vertex.startVertex();
                    return VertexState.RUNNING;
                }
                return vertexState;
            }
            return VertexState.INITIALIZING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitTransition
    implements MultipleArcTransition<VertexImpl, VertexEvent, VertexState> {
        public VertexState transition(VertexImpl vertex, VertexEvent event) {
            VertexState vertexState = VertexState.NEW;
            vertex.numInitedSourceVertices++;
            if ((vertex.sourceVertices == null || vertex.sourceVertices.isEmpty() || vertex.numInitedSourceVertices == vertex.sourceVertices.size()) && (vertexState = this.handleInitEvent(vertex, event)) != VertexState.FAILED && vertex.targetVertices != null && !vertex.targetVertices.isEmpty()) {
                for (Vertex target : vertex.targetVertices.keySet()) {
                    vertex.getEventHandler().handle((Event)new VertexEvent(target.getVertexId(), VertexEventType.V_INIT));
                }
            }
            return vertexState;
        }

        private VertexState handleInitEvent(VertexImpl vertex, VertexEvent event) {
            vertex.initTimeRequested = vertex.clock.getTime();
            if (vertex.additionalInputs != null) {
                LOG.info((Object)("Root Inputs exist for Vertex: " + vertex.getName() + " : " + vertex.additionalInputs));
                for (RootInputLeafOutputDescriptor input : vertex.additionalInputs.values()) {
                    if (input.getInitializerClassName() == null) continue;
                    if (vertex.inputsWithInitializers == null) {
                        vertex.inputsWithInitializers = Sets.newHashSet();
                    }
                    vertex.inputsWithInitializers.add(input.getEntityName());
                    LOG.info((Object)("Starting root input initializer for input: " + input.getEntityName() + ", with class: [" + input.getInitializerClassName() + "]"));
                }
            }
            boolean hasBipartite = false;
            if (vertex.sourceVertices != null) {
                for (Edge edge : vertex.sourceVertices.values()) {
                    if (edge.getEdgeProperty().getDataMovementType() != EdgeProperty.DataMovementType.SCATTER_GATHER) continue;
                    hasBipartite = true;
                    break;
                }
            }
            if (hasBipartite && vertex.inputsWithInitializers != null) {
                LOG.fatal((Object)"A vertex with an Initial Input and a Shuffle Input are not supported at the moment");
                return vertex.finished(VertexState.FAILED);
            }
            if (hasBipartite) {
                LOG.info((Object)("Setting vertexManager to ShuffleVertexManager for " + vertex.logIdentifier));
                vertex.vertexScheduler = new ShuffleVertexManager(vertex);
            } else if (vertex.inputsWithInitializers != null) {
                LOG.info((Object)("Setting vertexManager to RootInputVertexManager for " + vertex.logIdentifier));
                vertex.vertexScheduler = new RootInputVertexManager(vertex, vertex.eventHandler);
            } else {
                LOG.info((Object)("Setting vertexManager to ImmediateStartVertexManager for " + vertex.logIdentifier));
                vertex.vertexScheduler = new ImmediateStartVertexScheduler(vertex);
            }
            vertex.vertexScheduler.initialize(vertex.conf);
            vertex.numTasks = vertex.getVertexPlan().getTaskConfig().getNumTasks();
            if (vertex.numTasks != -1 && vertex.numTasks < 0) {
                vertex.addDiagnostic("Invalid task count for vertex, numTasks=" + vertex.numTasks);
                vertex.trySetTerminationCause(VertexTerminationCause.INVALID_NUM_OF_TASKS);
                vertex.abortVertex(VertexStatus.State.FAILED);
                return vertex.finished(VertexState.FAILED);
            }
            vertex.checkTaskLimits();
            if (vertex.numTasks == -1) {
                LOG.info((Object)("Num tasks is -1. Expecting VertexManager/InputInitializers to set #tasks for the vertex " + vertex.getVertexId()));
                if (vertex.inputsWithInitializers != null) {
                    int totalResource = vertex.appContext.getTaskScheduler().getTotalResources().getMemory();
                    int taskResource = vertex.getTaskResource().getMemory();
                    float waves = vertex.conf.getFloat("tez.am.grouping.split-waves", TezConfiguration.TEZ_AM_GROUPING_SPLIT_WAVES_DEFAULT);
                    int numTasks = (int)((float)totalResource * waves / (float)taskResource);
                    LOG.info((Object)("Vertex " + vertex.getVertexId() + " asking for " + numTasks + " tasks. Headroom: " + totalResource + " Task Resource: " + taskResource + " waves: " + waves));
                    vertex.rootInputInitializer = vertex.createRootInputInitializerRunner(vertex.getDAG().getName(), vertex.getName(), vertex.getVertexId(), vertex.eventHandler, numTasks);
                    ArrayList inputList = Lists.newArrayListWithCapacity((int)vertex.inputsWithInitializers.size());
                    for (String inputName : vertex.inputsWithInitializers) {
                        inputList.add(vertex.additionalInputs.get(inputName));
                    }
                    LOG.info((Object)("Starting root input initializers: " + vertex.inputsWithInitializers.size()));
                    vertex.rootInputInitializer.runInputInitializers(inputList);
                } else {
                    boolean hasOneToOneUninitedSource = false;
                    for (Map.Entry<Vertex, Edge> entry : vertex.sourceVertices.entrySet()) {
                        if (entry.getValue().getEdgeProperty().getDataMovementType() != EdgeProperty.DataMovementType.ONE_TO_ONE || entry.getKey().getTotalTasks() != -1) continue;
                        hasOneToOneUninitedSource = true;
                        break;
                    }
                    if (!hasOneToOneUninitedSource) {
                        throw new TezUncheckedException(vertex.getVertexId() + " has -1 tasks but neither input initializers nor 1-1 uninited sources");
                    }
                }
                return VertexState.INITIALIZING;
            }
            if (vertex.inputsWithInitializers != null) {
                vertex.rootInputInitializer = vertex.createRootInputInitializerRunner(vertex.getDAG().getName(), vertex.getName(), vertex.getVertexId(), vertex.eventHandler, vertex.getTotalTasks());
                ArrayList inputList = Lists.newArrayListWithCapacity((int)vertex.inputsWithInitializers.size());
                for (String inputName : vertex.inputsWithInitializers) {
                    inputList.add(vertex.additionalInputs.get(inputName));
                }
                LOG.info((Object)("Starting root input initializers: " + vertex.inputsWithInitializers.size()));
                vertex.rootInputInitializer.runInputInitializers(inputList);
                vertex.createTasks();
                return VertexState.INITIALIZING;
            }
            vertex.createTasks();
            return vertex.initializeVertex();
        }
    }
}

