/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMContainerMap
extends AbstractService
implements EventHandler<AMContainerEvent> {
    private static final Log LOG = LogFactory.getLog(AMContainerMap.class);
    private final ContainerHeartbeatHandler chh;
    private final TaskAttemptListener tal;
    private final AppContext context;
    private final ConcurrentHashMap<ContainerId, AMContainer> containerMap;

    public AMContainerMap(ContainerHeartbeatHandler chh, TaskAttemptListener tal, AppContext context) {
        super("AMContainerMaps");
        this.chh = chh;
        this.tal = tal;
        this.context = context;
        this.containerMap = new ConcurrentHashMap();
    }

    public void handle(AMContainerEvent event) {
        AMContainer container = this.containerMap.get(event.getContainerId());
        if (container != null) {
            container.handle((Event)event);
        } else {
            LOG.info((Object)("Event for unknown container: " + event.getContainerId()));
        }
    }

    public boolean addContainerIfNew(Container container) {
        AMContainerImpl amc = new AMContainerImpl(container, this.chh, this.tal, this.context);
        return this.containerMap.putIfAbsent(container.getId(), amc) == null;
    }

    public AMContainer get(ContainerId containerId) {
        return this.containerMap.get(containerId);
    }

    public Collection<AMContainer> values() {
        return this.containerMap.values();
    }
}

