/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.avro.HistoryEventType;
import org.apache.tez.dag.history.avro.TaskAttemptFinished;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private TaskAttemptFinished datum = new TaskAttemptFinished();
    private final TezCounters tezCounters;

    public TaskAttemptFinishedEvent(TezTaskAttemptID taId, String vertexName, long startTime, long finishTime, TaskAttemptState state, String diagnostics, TezCounters counters) {
        this.datum.taskAttemptId = taId.toString();
        this.datum.vertexName = vertexName;
        this.datum.startTime = startTime;
        this.datum.finishTime = finishTime;
        this.datum.status = state.name();
        this.datum.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_FINISHED;
    }

    public Object getBlob() {
        return this.toString();
    }

    public void setBlob(Object blob) {
        this.datum = (TaskAttemptFinished)((Object)blob);
    }

    public String toString() {
        return "vertexName=" + this.datum.vertexName + ", taskAttemptId=" + this.datum.taskAttemptId + ", startTime=" + this.datum.startTime + ", finishTime=" + this.datum.finishTime + ", timeTaken=" + (this.datum.finishTime - this.datum.startTime) + ", status=" + this.datum.status + ", diagnostics=" + this.datum.diagnostics + ", counters=" + this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }
}

