/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.avro.HistoryEventType;
import org.apache.tez.dag.history.avro.TaskFinished;
import org.apache.tez.dag.records.TezTaskID;

public class TaskFinishedEvent
implements HistoryEvent {
    private TaskFinished datum = new TaskFinished();
    private final TezCounters tezCounters;

    public TaskFinishedEvent(TezTaskID taskId, String vertexName, long startTime, long finishTime, TaskState state, TezCounters counters) {
        this.datum.vertexName = vertexName;
        this.datum.taskId = taskId.toString();
        this.datum.startTime = startTime;
        this.datum.finishTime = finishTime;
        this.datum.status = state.name();
        this.tezCounters = counters;
    }

    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_FINISHED;
    }

    public Object getBlob() {
        return this.toString();
    }

    public void setBlob(Object blob) {
        this.datum = (TaskFinished)((Object)blob);
    }

    public String toString() {
        return "vertexName=" + this.datum.vertexName + ", taskId=" + this.datum.taskId + ", startTime=" + this.datum.startTime + ", finishTime=" + this.datum.finishTime + ", timeTaken=" + (this.datum.finishTime - this.datum.startTime) + ", status=" + this.datum.status + ", counters=" + this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }
}

