/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.avro.HistoryEventType;
import org.apache.tez.dag.history.avro.VertexFinished;
import org.apache.tez.dag.records.TezVertexID;

public class VertexFinishedEvent
implements HistoryEvent {
    private VertexFinished datum = new VertexFinished();
    private final TezCounters tezCounters;

    public VertexFinishedEvent(TezVertexID vertexId, String vertexName, long initRequestedTime, long initedTime, long startRequestedTime, long startedTime, long finishTime, VertexStatus.State state, String diagnostics, TezCounters counters) {
        this.datum.vertexName = vertexName;
        this.datum.vertexId = vertexId.toString();
        this.datum.initRequestedTime = initRequestedTime;
        this.datum.initedTime = initedTime;
        this.datum.startRequestedTime = startRequestedTime;
        this.datum.startedTime = startedTime;
        this.datum.finishTime = finishTime;
        this.datum.status = state.name();
        this.datum.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_FINISHED;
    }

    public Object getBlob() {
        return this.toString();
    }

    public void setBlob(Object blob) {
        this.datum = (VertexFinished)((Object)blob);
    }

    public String toString() {
        return "vertexName=" + this.datum.vertexName + ", vertexId=" + this.datum.vertexId + ", initRequestedTime=" + this.datum.initRequestedTime + ", initedTime=" + this.datum.initedTime + ", startRequestedTime=" + this.datum.startRequestedTime + ", startedTime=" + this.datum.startedTime + ", finishTime=" + this.datum.finishTime + ", timeTaken=" + (this.datum.finishTime - this.datum.startedTime) + ", status=" + this.datum.status + ", diagnostics=" + this.datum.diagnostics + ", counters=" + this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }
}

