/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.RootInputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.events.RootInputUpdatePayloadEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public class RootInputVertexManager
implements VertexManagerPlugin {
    VertexManagerPluginContext context;

    public void initialize(VertexManagerPluginContext context) {
        this.context = context;
    }

    public void onVertexStarted(Map<String, List<Integer>> completions) {
        int numTasks = this.context.getVertexNumTasks(this.context.getVertexName());
        ArrayList<Integer> scheduledTasks = new ArrayList<Integer>(numTasks);
        for (int i = 0; i < numTasks; ++i) {
            scheduledTasks.add(new Integer(i));
        }
        this.context.scheduleVertexTasks(scheduledTasks);
    }

    public void onSourceTaskCompleted(String srcVertexName, Integer attemptId) {
    }

    public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
        LinkedList riEvents = Lists.newLinkedList();
        boolean dataInformationEventSeen = false;
        for (Event event : events) {
            if (event instanceof RootInputConfigureVertexTasksEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                Preconditions.checkState((this.context.getVertexNumTasks(this.context.getVertexName()) == -1 ? 1 : 0) != 0, (Object)"Parallelism for the vertex should be set to -1 if the InputInitializer is setting parallelism");
                RootInputConfigureVertexTasksEvent cEvent = (RootInputConfigureVertexTasksEvent)event;
                this.context.setVertexParallelism(cEvent.getNumTasks(), new VertexLocationHint(cEvent.getTaskLocationHints()), null);
            }
            if (event instanceof RootInputUpdatePayloadEvent) {
                Preconditions.checkState((!dataInformationEventSeen ? 1 : 0) != 0);
                inputDescriptor.setUserPayload(((RootInputUpdatePayloadEvent)event).getUserPayload());
                continue;
            }
            if (!(event instanceof RootInputDataInformationEvent)) continue;
            dataInformationEventSeen = true;
            Preconditions.checkState((this.context.getVertexNumTasks(this.context.getVertexName()) != 0 ? 1 : 0) != 0);
            RootInputDataInformationEvent rEvent = (RootInputDataInformationEvent)event;
            rEvent.setTargetIndex(rEvent.getSourceIndex());
            riEvents.add(rEvent);
        }
        this.context.addRootInputEvents(inputName, (Collection)riEvents);
    }
}

