/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.rm.TaskSchedulerAppCallbackWrapper;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;

public class TaskScheduler
extends AbstractService
implements AMRMClientAsync.CallbackHandler {
    private static final Log LOG = LogFactory.getLog(TaskScheduler.class);
    final TezAMRMClientAsync<CookieContainerRequest> amRmClient;
    final TaskSchedulerAppCallback realAppClient;
    final TaskSchedulerAppCallback appClientDelegate;
    final ContainerSignatureMatcher containerSignatureMatcher;
    ExecutorService appCallbackExecutor;
    private boolean shouldReuseContainers;
    private boolean reuseRackLocal;
    private boolean reuseNonLocal;
    Map<Object, CookieContainerRequest> taskRequests = new HashMap<Object, CookieContainerRequest>();
    LinkedHashMap<Object, Container> taskAllocations = new LinkedHashMap();
    Map<ContainerId, Object> containerAssignments = new HashMap<ContainerId, Object>();
    HashMap<ContainerId, Object> releasedContainers = new HashMap();
    Map<ContainerId, HeldContainer> heldContainers = new HashMap<ContainerId, HeldContainer>();
    Set<NodeId> blacklistedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    Resource totalResources = Resource.newInstance((int)0, (int)0);
    Resource allocatedResources = Resource.newInstance((int)0, (int)0);
    final String appHostName;
    final int appHostPort;
    final String appTrackingUrl;
    final AppContext appContext;
    boolean isStopped = false;
    private ContainerAssigner NODE_LOCAL_ASSIGNER = new NodeLocalContainerAssigner();
    private ContainerAssigner RACK_LOCAL_ASSIGNER = new RackLocalContainerAssigner();
    private ContainerAssigner NON_LOCAL_ASSIGNER = new NonLocalContainerAssigner();
    DelayedContainerManager delayedContainerManager;
    long localitySchedulingDelay;
    long sessionDelay;

    public TaskScheduler(TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, AppContext appContext) {
        super(TaskScheduler.class.getName());
        this.realAppClient = appClient;
        this.appCallbackExecutor = this.createAppCallbackExecutorService();
        this.containerSignatureMatcher = containerSignatureMatcher;
        this.appClientDelegate = this.createAppCallbackDelegate(appClient);
        this.amRmClient = TezAMRMClientAsync.createAMRMClientAsync(1000, this);
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        this.appContext = appContext;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    TaskScheduler(TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, TezAMRMClientAsync<CookieContainerRequest> client, AppContext appContext) {
        super(TaskScheduler.class.getName());
        this.realAppClient = appClient;
        this.appCallbackExecutor = this.createAppCallbackExecutorService();
        this.containerSignatureMatcher = containerSignatureMatcher;
        this.appClientDelegate = this.createAppCallbackDelegate(appClient);
        this.amRmClient = client;
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        this.appContext = appContext;
    }

    private ExecutorService createAppCallbackExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TaskSchedulerAppCaller #%d").setDaemon(true).build());
    }

    public Resource getAvailableResources() {
        return this.amRmClient.getAvailableResources();
    }

    public int getClusterNodeCount() {
        return this.amRmClient.getClusterNodeCount();
    }

    TaskSchedulerAppCallback createAppCallbackDelegate(TaskSchedulerAppCallback realAppClient) {
        return new TaskSchedulerAppCallbackWrapper(realAppClient, this.appCallbackExecutor);
    }

    public synchronized void serviceInit(Configuration conf) {
        this.amRmClient.init(conf);
        int heartbeatIntervalMax = conf.getInt("tez.am.am-rm.heartbeat.interval-ms.max", 1000);
        this.amRmClient.setHeartbeatInterval(heartbeatIntervalMax);
        this.shouldReuseContainers = conf.getBoolean("tez.am.container.reuse.enabled", true);
        this.reuseRackLocal = conf.getBoolean("tez.am.container.reuse.rack-fallback.enabled", true);
        this.reuseNonLocal = conf.getBoolean("tez.am.container.reuse.non-local-fallback.enabled", false);
        Preconditions.checkArgument((!this.reuseRackLocal && !this.reuseNonLocal || this.reuseRackLocal ? 1 : 0) != 0, (Object)"Re-use Rack-Local cannot be disabled if Re-use Non-Local has been enabled");
        this.localitySchedulingDelay = conf.getLong("tez.am.container.reuse.locality.delay-allocation-millis", 1000L);
        Preconditions.checkArgument((this.localitySchedulingDelay >= 0L ? 1 : 0) != 0, (Object)"Locality Scheduling delay should be >=0");
        this.sessionDelay = conf.getLong("tez.am.container.session.delay-allocation-millis", 10000L);
        Preconditions.checkArgument((this.sessionDelay >= 0L || this.sessionDelay == -1L ? 1 : 0) != 0, (Object)"Session delay should be either -1 or >=0");
        this.delayedContainerManager = new DelayedContainerManager();
        LOG.info((Object)("TaskScheduler initialized with configuration: maxRMHeartbeatInterval: " + heartbeatIntervalMax + ", containerReuseEnabled: " + this.shouldReuseContainers + ", reuseRackLocal: " + this.reuseRackLocal + ", reuseNonLocal: " + this.reuseNonLocal + ", localitySchedulingDelay: " + this.localitySchedulingDelay + ", sessionDelay=" + this.sessionDelay));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStart() {
        try {
            RegisterApplicationMasterResponse response;
            TaskScheduler taskScheduler = this;
            synchronized (taskScheduler) {
                this.amRmClient.start();
                response = this.amRmClient.registerApplicationMaster(this.appHostName, this.appHostPort, this.appTrackingUrl);
            }
            this.appClientDelegate.setApplicationRegistrationData(response.getMaximumResourceCapability(), response.getApplicationACLs(), response.getClientToAMTokenMasterKey());
            this.delayedContainerManager.start();
        }
        catch (YarnException e) {
            LOG.error((Object)"Yarn Exception while registering", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO Exception while registering", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws InterruptedException {
        TaskSchedulerAppCallback.AppFinalStatus status = this.appClientDelegate.getFinalAppStatus();
        try {
            this.delayedContainerManager.shutdown();
            this.delayedContainerManager.join(2000L);
            TaskScheduler taskScheduler = this;
            synchronized (taskScheduler) {
                this.isStopped = true;
                this.amRmClient.unregisterApplicationMaster(status.exitStatus, status.exitMessage, status.postCompletionTrackingUrl);
            }
            this.amRmClient.stop();
            this.appCallbackExecutor.shutdown();
            this.appCallbackExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (YarnException e) {
            LOG.error((Object)"Yarn Exception while unregistering ", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IOException while unregistering ", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContainersCompleted(List<ContainerStatus> statuses) {
        if (this.isStopped) {
            return;
        }
        HashMap<Object, ContainerStatus> appContainerStatus = new HashMap<Object, ContainerStatus>(statuses.size());
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            for (ContainerStatus containerStatus : statuses) {
                ContainerId completedId = containerStatus.getContainerId();
                HeldContainer delayedContainer = this.heldContainers.get(completedId);
                Object task = this.releasedContainers.remove(completedId);
                if (task != null) {
                    if (delayedContainer != null) {
                        LOG.warn((Object)"Held container should be null since releasedContainer is not");
                    }
                    LOG.info((Object)("Released container completed:" + completedId + " last allocated to task: " + task));
                    appContainerStatus.put(task, containerStatus);
                    continue;
                }
                task = this.unAssignContainer(completedId, false);
                if (delayedContainer != null) {
                    this.heldContainers.remove(completedId);
                    Resources.subtract((Resource)this.allocatedResources, (Resource)delayedContainer.getContainer().getResource());
                } else {
                    LOG.warn((Object)"Held container expected to be not null for a non-AM-released container");
                }
                if (task != null) {
                    LOG.info((Object)("Allocated container completed:" + completedId + " last allocated to task: " + task));
                    appContainerStatus.put(task, containerStatus);
                    continue;
                }
                LOG.info((Object)("Ignoring unknown container: " + containerStatus.getContainerId()));
            }
        }
        for (Map.Entry entry : appContainerStatus.entrySet()) {
            this.appClientDelegate.containerCompleted(entry.getKey(), (ContainerStatus)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContainersAllocated(List<Container> containers) {
        Map<CookieContainerRequest, Container> assignedContainers;
        if (this.isStopped) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Container container : containers) {
                sb.append(container.getId()).append(", ");
            }
            LOG.debug((Object)("Assigned New Containers: " + sb.toString()));
        }
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            if (this.shouldReuseContainers) {
                this.pushNewContainerToDelayed(containers);
                return;
            }
            LinkedList modifiableContainerList = Lists.newLinkedList(containers);
            assignedContainers = this.assignNewlyAllocatedContainers(modifiableContainerList);
        }
        this.informAppAboutAssignments(assignedContainers);
    }

    private synchronized Map<CookieContainerRequest, Container> assignNewlyAllocatedContainers(Iterable<Container> containers) {
        HashMap<CookieContainerRequest, Container> assignedContainers = new HashMap<CookieContainerRequest, Container>();
        this.assignNewContainersWithLocation(containers, this.NODE_LOCAL_ASSIGNER, assignedContainers);
        this.assignNewContainersWithLocation(containers, this.RACK_LOCAL_ASSIGNER, assignedContainers);
        this.assignNewContainersWithLocation(containers, this.NON_LOCAL_ASSIGNER, assignedContainers);
        this.releaseUnassignedContainers(containers);
        return assignedContainers;
    }

    private synchronized Map<CookieContainerRequest, Container> tryAssignReUsedContainers(Iterable<Container> containers) {
        HashMap<CookieContainerRequest, Container> assignedContainers = new HashMap<CookieContainerRequest, Container>();
        this.assignReUsedContainersWithLocation(containers, this.NODE_LOCAL_ASSIGNER, assignedContainers, true);
        this.assignReUsedContainersWithLocation(containers, this.RACK_LOCAL_ASSIGNER, assignedContainers, true);
        this.assignReUsedContainersWithLocation(containers, this.NON_LOCAL_ASSIGNER, assignedContainers, true);
        return assignedContainers;
    }

    private synchronized Map<CookieContainerRequest, Container> assignDelayedContainer(HeldContainer heldContainer) {
        DAGAppMasterState state = this.appContext.getAMState();
        boolean isNew = heldContainer.isNew();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to assign a delayed container, containerId=" + heldContainer.getContainer().getId() + ", nextScheduleTime=" + heldContainer.getNextScheduleTime() + ", containerExpiryTime=" + heldContainer.getContainerExpiryTime() + ", AMState=" + (Object)((Object)state) + ", matchLevel=" + (Object)((Object)heldContainer.getLocalityMatchLevel()) + ", taskRequestsCount=" + this.taskRequests.size() + ", heldContainers=" + this.heldContainers.size() + ", delayedContainers=" + this.delayedContainerManager.delayedContainers.size() + ", isNew=" + isNew));
        }
        if (state.equals((Object)DAGAppMasterState.IDLE) || this.taskRequests.isEmpty()) {
            heldContainer.resetLocalityMatchLevel();
            long currentTime = System.currentTimeMillis();
            if (isNew || heldContainer.getContainerExpiryTime() <= currentTime && this.sessionDelay != -1L) {
                LOG.info((Object)("No taskRequests. Container's session delay expired or is new. Releasing container, containerId=" + heldContainer.container.getId() + ", containerExpiryTime=" + heldContainer.getContainerExpiryTime() + ", sessionDelay=" + this.sessionDelay + ", taskRequestsCount=" + this.taskRequests.size() + ", heldContainers=" + this.heldContainers.size() + ", delayedContainers=" + this.delayedContainerManager.delayedContainers.size() + ", isNew=" + isNew));
                this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
            } else if (!this.appContext.isSession()) {
                this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
            } else {
                heldContainer.resetLocalityMatchLevel();
                this.delayedContainerManager.addDelayedContainer(heldContainer.getContainer(), currentTime + this.localitySchedulingDelay);
            }
        } else {
            if (state.equals((Object)DAGAppMasterState.RUNNING)) {
                HeldContainer.LocalityMatchLevel localityMatchLevel = heldContainer.getLocalityMatchLevel();
                HashMap<CookieContainerRequest, Container> assignedContainers = new HashMap<CookieContainerRequest, Container>();
                Container containerToAssign = heldContainer.container;
                if (isNew || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NEW) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NODE) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.RACK) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL)) {
                    this.assignReUsedContainerWithLocation(containerToAssign, this.NODE_LOCAL_ASSIGNER, assignedContainers, true);
                    if (LOG.isDebugEnabled() && assignedContainers.isEmpty()) {
                        LOG.info((Object)("Failed to assign tasks to delayed container using node, containerId=" + heldContainer.getContainer().getId()));
                    }
                }
                if (assignedContainers.isEmpty() && (this.reuseRackLocal || isNew) && (this.localitySchedulingDelay == 0L || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.RACK) || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL))) {
                    this.assignReUsedContainerWithLocation(containerToAssign, this.RACK_LOCAL_ASSIGNER, assignedContainers, false);
                    if (LOG.isDebugEnabled() && assignedContainers.isEmpty()) {
                        LOG.info((Object)("Failed to assign tasks to delayed container using rack, containerId=" + heldContainer.getContainer().getId()));
                    }
                }
                if (assignedContainers.isEmpty() && (this.reuseNonLocal || isNew) && (this.localitySchedulingDelay == 0L || localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL))) {
                    this.assignReUsedContainerWithLocation(containerToAssign, this.NON_LOCAL_ASSIGNER, assignedContainers, false);
                    if (LOG.isDebugEnabled() && assignedContainers.isEmpty()) {
                        LOG.info((Object)("Failed to assign tasks to delayed container using non-local, containerId=" + heldContainer.getContainer().getId()));
                    }
                }
                if (assignedContainers.isEmpty()) {
                    long currentTime = System.currentTimeMillis();
                    if (!isNew && heldContainer.getContainerExpiryTime() <= currentTime && this.sessionDelay != -1L) {
                        LOG.info((Object)("Container's session delay expired. Releasing container, containerId=" + heldContainer.container.getId() + ", containerExpiryTime=" + heldContainer.getContainerExpiryTime() + ", sessionDelay=" + this.sessionDelay));
                        this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
                    } else {
                        boolean hitFinalMatchLevel = localityMatchLevel.equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL);
                        if (!hitFinalMatchLevel) {
                            heldContainer.incrementLocalityMatchLevel();
                            if (this.localitySchedulingDelay == 0L || !this.reuseRackLocal || !this.reuseNonLocal && heldContainer.getLocalityMatchLevel().equals((Object)HeldContainer.LocalityMatchLevel.NON_LOCAL)) {
                                hitFinalMatchLevel = true;
                            }
                            if (this.localitySchedulingDelay > 0L && isNew) {
                                hitFinalMatchLevel = false;
                            }
                        }
                        if (hitFinalMatchLevel) {
                            boolean safeToRelease = true;
                            Priority topPendingPriority = this.amRmClient.getTopPriority();
                            Priority containerPriority = heldContainer.container.getPriority();
                            if (isNew && topPendingPriority != null && containerPriority.compareTo(topPendingPriority) < 0) {
                                safeToRelease = false;
                            }
                            if (!(!safeToRelease || this.taskRequests.isEmpty() && this.appContext.isSession())) {
                                LOG.info((Object)("Releasing held container as either there are pending but  unmatched requests or this is not a session, containerId=" + heldContainer.container.getId() + ", pendingTasks=" + !this.taskRequests.isEmpty() + ", isSession=" + this.appContext.isSession() + ". isNew=" + isNew));
                                this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
                            } else {
                                heldContainer.resetLocalityMatchLevel();
                                this.delayedContainerManager.addDelayedContainer(heldContainer.getContainer(), currentTime + this.localitySchedulingDelay);
                            }
                        } else {
                            this.delayedContainerManager.addDelayedContainer(heldContainer.getContainer(), currentTime + this.localitySchedulingDelay);
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Delayed container assignment successful, containerId=" + heldContainer.getContainer().getId()));
                }
                return assignedContainers;
            }
            LOG.warn((Object)("Received a request to assign re-used containers when AM was  in state: " + (Object)((Object)state) + ". Ignoring request and releasing container" + ": " + heldContainer.getContainer().getId()));
            this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{heldContainer.container}));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetMatchLocalityForAllHeldContainers() {
        for (HeldContainer heldContainer : this.heldContainers.values()) {
            heldContainer.resetLocalityMatchLevel();
        }
        DelayedContainerManager delayedContainerManager = this.delayedContainerManager;
        synchronized (delayedContainerManager) {
            this.delayedContainerManager.notify();
        }
    }

    public void onShutdownRequest() {
        if (this.isStopped) {
            return;
        }
        this.appClientDelegate.appShutdownRequested();
    }

    public void onNodesUpdated(List<NodeReport> updatedNodes) {
        if (this.isStopped) {
            return;
        }
        this.appClientDelegate.nodesUpdated(updatedNodes);
    }

    public float getProgress() {
        if (this.isStopped) {
            return 1.0f;
        }
        if (this.totalResources.getMemory() == 0) {
            this.totalResources = Resources.clone((Resource)this.getAvailableResources());
            LOG.info((Object)("App total resource memory: " + this.totalResources.getMemory() + " cpu: " + this.totalResources.getVirtualCores() + " taskAllocations: " + this.taskAllocations.size()));
        }
        this.preemptIfNeeded();
        return this.appClientDelegate.getProgress();
    }

    public void onError(Throwable t) {
        if (this.isStopped) {
            return;
        }
        this.appClientDelegate.onError(t);
    }

    public Resource getTotalResources() {
        return this.totalResources;
    }

    public synchronized void blacklistNode(NodeId nodeId) {
        this.amRmClient.addNodeToBlacklist(nodeId);
        this.blacklistedNodes.add(nodeId);
    }

    public synchronized void unblacklistNode(NodeId nodeId) {
        if (this.blacklistedNodes.remove(nodeId)) {
            this.amRmClient.removeNodeFromBlacklist(nodeId);
        }
    }

    public synchronized void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        CRCookie cookie = new CRCookie(task, clientCookie, containerSignature);
        CookieContainerRequest request = new CookieContainerRequest(capability, hosts, racks, priority, cookie);
        this.addTaskRequest(task, request);
        this.delayedContainerManager.triggerScheduling(true);
        LOG.info((Object)("Allocation request for task: " + task + " with request: " + (Object)((Object)request) + " host: " + (hosts != null && hosts.length > 0 ? hosts[0] : "null") + " rack: " + (racks != null && racks.length > 0 ? racks[0] : "null")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deallocateTask(Object task, boolean taskSucceeded) {
        Map<CookieContainerRequest, Container> assignedContainers = null;
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            CookieContainerRequest request = this.removeTaskRequest(task);
            if (request != null) {
                LOG.info((Object)("Deallocating task: " + task + " before allocation"));
                return false;
            }
            Container container = this.doBookKeepingForTaskDeallocate(task);
            if (container == null) {
                LOG.info((Object)("Ignoring removal of unknown task: " + task));
                return false;
            }
            LOG.info((Object)("Deallocated task: " + task + " from container: " + container.getId()));
            if (!taskSucceeded || !this.shouldReuseContainers) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Releasing container, containerId=" + container.getId() + ", taskSucceeded=" + taskSucceeded + ", reuseContainersFlag=" + this.shouldReuseContainers));
                }
                this.releaseContainer(container.getId());
            } else {
                HeldContainer heldContainer = this.heldContainers.get(container.getId());
                if (heldContainer != null) {
                    heldContainer.resetLocalityMatchLevel();
                    long currentTime = System.currentTimeMillis();
                    if (this.sessionDelay > 0L) {
                        heldContainer.setContainerExpiryTime(currentTime + this.sessionDelay);
                    }
                    assignedContainers = this.assignDelayedContainer(heldContainer);
                } else {
                    LOG.info((Object)("Skipping container after task deallocate as container is no longer running, containerId=" + container.getId()));
                }
            }
        }
        if (assignedContainers != null && assignedContainers.size() == 1) {
            this.informAppAboutAssignments(assignedContainers);
        }
        return true;
    }

    public synchronized Object deallocateContainer(ContainerId containerId) {
        Object task = this.unAssignContainer(containerId, true);
        if (task != null) {
            LOG.info((Object)("Deallocated container: " + containerId + " from task: " + task));
            return task;
        }
        LOG.info((Object)("Ignoring dealloction of unknown container: " + containerId));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preemptIfNeeded() {
        ContainerId preemptedContainer = null;
        TaskScheduler taskScheduler = this;
        synchronized (taskScheduler) {
            Resource freeResources = Resources.subtract((Resource)this.totalResources, (Resource)this.allocatedResources);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Allocated resource memory: " + this.allocatedResources.getMemory() + " cpu:" + this.allocatedResources.getVirtualCores() + " delayedContainers: " + this.delayedContainerManager.delayedContainers.size()));
            }
            assert (freeResources.getMemory() >= 0);
            if (this.delayedContainerManager.delayedContainers.size() > 0) {
                return;
            }
            CookieContainerRequest highestPriRequest = null;
            for (CookieContainerRequest request : this.taskRequests.values()) {
                if (highestPriRequest == null) {
                    highestPriRequest = request;
                    continue;
                }
                if (!this.isHigherPriority(request.getPriority(), highestPriRequest.getPriority())) continue;
                highestPriRequest = request;
            }
            if (highestPriRequest != null && !this.fitsIn(highestPriRequest.getCapability(), freeResources)) {
                Map.Entry<Object, Container> preemptedEntry = null;
                for (Map.Entry<Object, Container> entry : this.taskAllocations.entrySet()) {
                    HeldContainer heldContainer = this.heldContainers.get(entry.getValue().getId());
                    CookieContainerRequest lastTaskInfo = heldContainer.getLastTaskInfo();
                    Priority taskPriority = lastTaskInfo.getPriority();
                    Object signature = lastTaskInfo.getCookie().getContainerSignature();
                    if (!this.isHigherPriority(highestPriRequest.getPriority(), taskPriority) || this.containerSignatureMatcher.isExactMatch(highestPriRequest.getCookie().getContainerSignature(), signature) || preemptedEntry != null && this.isHigherPriority(taskPriority, preemptedEntry.getValue().getPriority())) continue;
                    preemptedEntry = entry;
                }
                if (preemptedEntry != null) {
                    LOG.info((Object)("Preempting task: " + preemptedEntry.getKey() + " to free resource for request: " + (Object)((Object)highestPriRequest) + " . Current free resources: " + freeResources));
                    preemptedContainer = ((Container)preemptedEntry.getValue()).getId();
                }
            }
        }
        if (preemptedContainer != null) {
            this.appClientDelegate.preemptContainer(preemptedContainer);
        }
    }

    private boolean fitsIn(Resource toFit, Resource resource) {
        return resource.getMemory() >= toFit.getMemory();
    }

    private CookieContainerRequest getMatchingRequestWithPriority(Container container, String location) {
        Resource capability;
        Priority priority = container.getPriority();
        List requestsList = this.amRmClient.getMatchingRequests(priority, location, capability = container.getResource());
        if (!requestsList.isEmpty()) {
            for (Collection requests : requestsList) {
                for (CookieContainerRequest cookieContainerRequest : requests) {
                    if (!this.canAssignTaskToContainer(cookieContainerRequest, container)) continue;
                    return cookieContainerRequest;
                }
            }
        }
        return null;
    }

    private CookieContainerRequest getMatchingRequestWithoutPriority(Container container, String location) {
        Resource capability = container.getResource();
        List<Collection<CookieContainerRequest>> pRequestsList = this.amRmClient.getMatchingRequestsForTopPriority(location, capability);
        if (pRequestsList == null || pRequestsList.isEmpty()) {
            return null;
        }
        for (Collection<CookieContainerRequest> requests : pRequestsList) {
            for (CookieContainerRequest cookieContainerRequest : requests) {
                if (!this.canAssignTaskToContainer(cookieContainerRequest, container)) continue;
                return cookieContainerRequest;
            }
        }
        return null;
    }

    private boolean canAssignTaskToContainer(CookieContainerRequest cookieContainerRequest, Container container) {
        HeldContainer heldContainer = this.heldContainers.get(container.getId());
        if (heldContainer == null || heldContainer.isNew()) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to match task to a held container,  containerId=" + heldContainer.container.getId()));
        }
        if (this.containerSignatureMatcher.isSuperSet(heldContainer.getFirstContainerSignature(), cookieContainerRequest.getCookie().getContainerSignature())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Matched delayed container to task containerId=" + heldContainer.container.getId()));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Failed to match delayed container to task containerId=" + heldContainer.container.getId()));
        }
        return false;
    }

    private Object getTask(CookieContainerRequest request) {
        return request.getCookie().getTask();
    }

    private void releaseContainer(ContainerId containerId) {
        HeldContainer delayedContainer;
        Object assignedTask = this.containerAssignments.remove(containerId);
        if (assignedTask != null) {
            this.appClientDelegate.containerBeingReleased(containerId);
        }
        if ((delayedContainer = this.heldContainers.remove(containerId)) != null) {
            Resources.subtractFrom((Resource)this.allocatedResources, (Resource)delayedContainer.getContainer().getResource());
        }
        if (delayedContainer != null || !this.shouldReuseContainers) {
            this.amRmClient.releaseAssignedContainer(containerId);
        }
        if (assignedTask != null) {
            this.releasedContainers.put(containerId, assignedTask);
        }
    }

    private void assignContainer(Object task, Container container, CookieContainerRequest assigned) {
        CookieContainerRequest request = this.removeTaskRequest(task);
        assert (request != null);
        Container result = this.taskAllocations.put(task, container);
        assert (result == null);
        this.containerAssignments.put(container.getId(), task);
        HeldContainer heldContainer = this.heldContainers.get(container.getId());
        if (!this.shouldReuseContainers && heldContainer == null) {
            this.heldContainers.put(container.getId(), new HeldContainer(container, -1L, -1L, assigned));
            Resources.addTo((Resource)this.allocatedResources, (Resource)container.getResource());
        } else {
            if (heldContainer.isNew()) {
                this.heldContainers.put(container.getId(), new HeldContainer(container, heldContainer.getNextScheduleTime(), heldContainer.getContainerExpiryTime(), assigned));
            }
            heldContainer.setLastTaskInfo(assigned);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushNewContainerToDelayed(List<Container> containers) {
        long expireTime = -1L;
        if (this.sessionDelay > 0L) {
            long currentTime = System.currentTimeMillis();
            expireTime = currentTime + this.sessionDelay;
        }
        DelayedContainerManager delayedContainerManager = this.delayedContainerManager;
        synchronized (delayedContainerManager) {
            for (Container container : containers) {
                if (this.heldContainers.put(container.getId(), new HeldContainer(container, -1L, expireTime, null)) != null) {
                    throw new TezUncheckedException("New container " + container.getId() + " is already held.");
                }
                long nextScheduleTime = this.delayedContainerManager.maxScheduleTimeSeen;
                if (this.delayedContainerManager.maxScheduleTimeSeen == -1L) {
                    nextScheduleTime = System.currentTimeMillis();
                }
                Resources.addTo((Resource)this.allocatedResources, (Resource)container.getResource());
                this.delayedContainerManager.addDelayedContainer(container, nextScheduleTime + 1L);
            }
        }
        this.delayedContainerManager.triggerScheduling(false);
    }

    private CookieContainerRequest removeTaskRequest(Object task) {
        CookieContainerRequest request = this.taskRequests.remove(task);
        if (request != null) {
            this.amRmClient.removeContainerRequest(request);
        }
        return request;
    }

    private void addTaskRequest(Object task, CookieContainerRequest request) {
        this.taskRequests.put(task, request);
        this.amRmClient.addContainerRequest(request);
    }

    private Container doBookKeepingForTaskDeallocate(Object task) {
        Container container = (Container)this.taskAllocations.remove(task);
        if (container == null) {
            return null;
        }
        return container;
    }

    private Object unAssignContainer(ContainerId containerId, boolean releaseIfFound) {
        Object task = this.containerAssignments.get(containerId);
        if (task == null) {
            return null;
        }
        Container container = (Container)this.taskAllocations.remove(task);
        assert (container != null);
        if (releaseIfFound) {
            this.releaseContainer(containerId);
        }
        return task;
    }

    private boolean isHigherPriority(Priority lhs, Priority rhs) {
        return lhs.getPriority() < rhs.getPriority();
    }

    private synchronized void assignNewContainersWithLocation(Iterable<Container> containers, ContainerAssigner assigner, Map<CookieContainerRequest, Container> assignedContainers) {
        Iterator<Container> containerIterator = containers.iterator();
        while (containerIterator.hasNext()) {
            Container container = containerIterator.next();
            CookieContainerRequest assigned = assigner.assignNewContainer(container);
            if (assigned == null) continue;
            assignedContainers.put(assigned, container);
            containerIterator.remove();
        }
    }

    private synchronized void assignReUsedContainersWithLocation(Iterable<Container> containers, ContainerAssigner assigner, Map<CookieContainerRequest, Container> assignedContainers, boolean honorLocality) {
        Iterator<Container> containerIterator = containers.iterator();
        while (containerIterator.hasNext()) {
            Container container = containerIterator.next();
            if (!this.assignReUsedContainerWithLocation(container, assigner, assignedContainers, honorLocality)) continue;
            containerIterator.remove();
        }
    }

    private synchronized boolean assignReUsedContainerWithLocation(Container container, ContainerAssigner assigner, Map<CookieContainerRequest, Container> assignedContainers, boolean honorLocality) {
        Priority containerPriority = container.getPriority();
        Priority topPendingTaskPriority = this.amRmClient.getTopPriority();
        if (topPendingTaskPriority == null) {
            return false;
        }
        if (topPendingTaskPriority.compareTo(containerPriority) > 0) {
            return false;
        }
        CookieContainerRequest assigned = assigner.assignReUsedContainer(container, honorLocality);
        if (assigned != null) {
            assignedContainers.put(assigned, container);
            return true;
        }
        return false;
    }

    private void releaseUnassignedContainers(Iterable<Container> containers) {
        for (Container container : containers) {
            LOG.info((Object)("Releasing unused container: " + container.getId()));
            this.releaseContainer(container.getId());
        }
    }

    private void informAppAboutAssignment(CookieContainerRequest assigned, Container container) {
        this.appClientDelegate.taskAllocated(this.getTask(assigned), assigned.getCookie().getAppCookie(), container);
    }

    private void informAppAboutAssignments(Map<CookieContainerRequest, Container> assignedContainers) {
        if (assignedContainers == null || assignedContainers.isEmpty()) {
            return;
        }
        for (Map.Entry<CookieContainerRequest, Container> entry : assignedContainers.entrySet()) {
            Container container = entry.getValue();
            if (this.blacklistedNodes.contains(container.getNodeId())) {
                CookieContainerRequest request = entry.getKey();
                Object task = this.getTask(request);
                Object clientCookie = request.getCookie().getAppCookie();
                LOG.info((Object)("Container: " + container.getId() + " allocated on blacklisted node: " + container.getNodeId() + " for task: " + task));
                Object deAllocTask = this.deallocateContainer(container.getId());
                assert (deAllocTask.equals(task));
                this.allocateTask(task, request.getCapability(), request.getNodes() == null ? null : request.getNodes().toArray(new String[request.getNodes().size()]), request.getRacks() == null ? null : request.getRacks().toArray(new String[request.getRacks().size()]), request.getPriority(), request.getCookie().getContainerSignature(), clientCookie);
                continue;
            }
            this.informAppAboutAssignment(entry.getKey(), container);
        }
    }

    static class HeldContainer {
        Container container;
        private long nextScheduleTime;
        private Object firstContainerSignature;
        private LocalityMatchLevel localityMatchLevel;
        private long containerExpiryTime;
        private CookieContainerRequest lastTaskInfo;

        HeldContainer(Container container, long nextScheduleTime, long containerExpiryTime, CookieContainerRequest firstTaskInfo) {
            this.container = container;
            this.nextScheduleTime = nextScheduleTime;
            if (firstTaskInfo != null) {
                this.lastTaskInfo = firstTaskInfo;
                this.firstContainerSignature = firstTaskInfo.getCookie().getContainerSignature();
            }
            this.localityMatchLevel = LocalityMatchLevel.NODE;
            this.containerExpiryTime = containerExpiryTime;
        }

        boolean isNew() {
            return this.firstContainerSignature == null;
        }

        public Container getContainer() {
            return this.container;
        }

        public long getNextScheduleTime() {
            return this.nextScheduleTime;
        }

        public void setNextScheduleTime(long nextScheduleTime) {
            this.nextScheduleTime = nextScheduleTime;
        }

        public long getContainerExpiryTime() {
            return this.containerExpiryTime;
        }

        public void setContainerExpiryTime(long containerExpiryTime) {
            this.containerExpiryTime = containerExpiryTime;
        }

        public Object getFirstContainerSignature() {
            return this.firstContainerSignature;
        }

        public CookieContainerRequest getLastTaskInfo() {
            return this.lastTaskInfo;
        }

        public void setLastTaskInfo(CookieContainerRequest taskInfo) {
            this.lastTaskInfo = taskInfo;
        }

        public synchronized void resetLocalityMatchLevel() {
            this.localityMatchLevel = LocalityMatchLevel.NEW;
        }

        public synchronized void incrementLocalityMatchLevel() {
            if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.NEW)) {
                this.localityMatchLevel = LocalityMatchLevel.NODE;
            } else if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.NODE)) {
                this.localityMatchLevel = LocalityMatchLevel.RACK;
            } else if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.RACK)) {
                this.localityMatchLevel = LocalityMatchLevel.NON_LOCAL;
            } else if (this.localityMatchLevel.equals((Object)LocalityMatchLevel.NON_LOCAL)) {
                throw new TezUncheckedException("Cannot increment locality level  from current NON_LOCAL for container: " + this.container.getId());
            }
        }

        public LocalityMatchLevel getLocalityMatchLevel() {
            return this.localityMatchLevel;
        }

        public String toString() {
            return "HeldContainer: id: " + this.container.getId() + ", nextScheduleTime: " + this.nextScheduleTime + ", localityMatchLevel=" + (Object)((Object)this.localityMatchLevel) + ", signature: " + (this.firstContainerSignature != null ? this.firstContainerSignature.toString() : "null");
        }

        static enum LocalityMatchLevel {
            NEW,
            NODE,
            RACK,
            NON_LOCAL;

        }
    }

    private class ContainerIterable
    implements Iterable<Container> {
        private final Iterable<HeldContainer> delayedContainers;

        ContainerIterable(Iterable<HeldContainer> delayedContainers) {
            this.delayedContainers = delayedContainers;
        }

        @Override
        public Iterator<Container> iterator() {
            final Iterator<HeldContainer> delayedContainerIterator = this.delayedContainers.iterator();
            return new Iterator<Container>(){

                @Override
                public boolean hasNext() {
                    return delayedContainerIterator.hasNext();
                }

                @Override
                public Container next() {
                    return ((HeldContainer)delayedContainerIterator.next()).getContainer();
                }

                @Override
                public void remove() {
                    delayedContainerIterator.remove();
                }
            };
        }
    }

    @VisibleForTesting
    class DelayedContainerManager
    extends Thread {
        private PriorityBlockingQueue<HeldContainer> delayedContainers = new PriorityBlockingQueue<HeldContainer>(20, new HeldContainerTimerComparator());
        private volatile boolean tryAssigningAll = false;
        private volatile boolean running = true;
        private long maxScheduleTimeSeen = -1L;
        @VisibleForTesting
        AtomicBoolean drainedDelayedContainers = null;

        DelayedContainerManager() {
            super.setName("DelayedContainerManager");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                long nextScheduleTs;
                long currentTs;
                if (this.tryAssigningAll) {
                    this.doAssignAll();
                    this.tryAssigningAll = false;
                }
                if (this.delayedContainers.peek() == null) {
                    try {
                        Object object;
                        if (this.drainedDelayedContainers != null) {
                            this.drainedDelayedContainers.set(true);
                            object = this.drainedDelayedContainers;
                            synchronized (object) {
                                this.drainedDelayedContainers.notifyAll();
                            }
                        }
                        object = this;
                        synchronized (object) {
                            this.wait();
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"AllocatedContainerManager Thread interrupted");
                        continue;
                    }
                }
                HeldContainer delayedContainer = this.delayedContainers.peek();
                if (delayedContainer == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Considering HeldContainer: " + delayedContainer + " for assignment"));
                }
                if ((currentTs = System.currentTimeMillis()) >= (nextScheduleTs = delayedContainer.getNextScheduleTime())) {
                    delayedContainer = this.delayedContainers.poll();
                    if (delayedContainer == null) continue;
                    Map assignedContainers = null;
                    TaskScheduler taskScheduler = TaskScheduler.this;
                    synchronized (taskScheduler) {
                        if (null != TaskScheduler.this.heldContainers.get(delayedContainer.getContainer().getId())) {
                            assignedContainers = TaskScheduler.this.assignDelayedContainer(delayedContainer);
                        } else {
                            LOG.info((Object)("Skipping delayed container as container is no longer running, containerId=" + delayedContainer.getContainer().getId()));
                        }
                    }
                    TaskScheduler.this.informAppAboutAssignments(assignedContainers);
                    continue;
                }
                DelayedContainerManager delayedContainerManager = this;
                synchronized (delayedContainerManager) {
                    try {
                        delayedContainer = this.delayedContainers.peek();
                        long diff = TaskScheduler.this.localitySchedulingDelay;
                        if (delayedContainer != null) {
                            diff = delayedContainer.getNextScheduleTime() - currentTs;
                        }
                        if (diff > 0L) {
                            this.wait(diff);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"AllocatedContainerManager Thread interrupted");
                    }
                }
            }
            this.releasePendingContainers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAssignAll() {
            Map assignedContainers;
            if (this.delayedContainers.isEmpty()) {
                return;
            }
            TaskScheduler taskScheduler = TaskScheduler.this;
            synchronized (taskScheduler) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Trying to assign all delayed containers to newly received tasks");
                }
                Iterator<HeldContainer> iter = this.delayedContainers.iterator();
                while (iter.hasNext()) {
                    HeldContainer delayedContainer = iter.next();
                    if (TaskScheduler.this.heldContainers.containsKey(delayedContainer.getContainer().getId())) continue;
                    LOG.info((Object)("AssignAll - Skipping delayed container as container is no longer running, containerId=" + delayedContainer.getContainer().getId()));
                    iter.remove();
                }
                assignedContainers = TaskScheduler.this.tryAssignReUsedContainers(new ContainerIterable(this.delayedContainers));
            }
            TaskScheduler.this.informAppAboutAssignments(assignedContainers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerScheduling(boolean scheduleAll) {
            this.tryAssigningAll = scheduleAll;
            DelayedContainerManager delayedContainerManager = this;
            synchronized (delayedContainerManager) {
                this.notify();
            }
        }

        public void shutdown() {
            this.running = false;
            this.interrupt();
        }

        private void releasePendingContainers() {
            ArrayList pendingContainers = Lists.newArrayListWithCapacity((int)this.delayedContainers.size());
            this.delayedContainers.drainTo(pendingContainers);
            TaskScheduler.this.releaseUnassignedContainers(new ContainerIterable(pendingContainers));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDelayedContainer(Container container, long nextScheduleTime) {
            HeldContainer delayedContainer = TaskScheduler.this.heldContainers.get(container.getId());
            if (delayedContainer == null) {
                LOG.warn((Object)("Attempting to add a non-running container to the delayed container list, containerId=" + container.getId()));
                return;
            }
            delayedContainer.setNextScheduleTime(nextScheduleTime);
            if (this.maxScheduleTimeSeen < nextScheduleTime) {
                this.maxScheduleTimeSeen = nextScheduleTime;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding container to delayed queue, containerId=" + delayedContainer.getContainer().getId() + ", nextScheduleTime=" + delayedContainer.getNextScheduleTime() + ", containerExpiry=" + delayedContainer.getContainerExpiryTime()));
            }
            boolean added = this.delayedContainers.offer(delayedContainer);
            DelayedContainerManager delayedContainerManager = this;
            synchronized (delayedContainerManager) {
                this.notify();
            }
            if (!added) {
                TaskScheduler.this.releaseUnassignedContainers(Lists.newArrayList((Object[])new Container[]{container}));
            }
        }

        class HeldContainerTimerComparator
        implements Comparator<HeldContainer> {
            HeldContainerTimerComparator() {
            }

            @Override
            public int compare(HeldContainer c1, HeldContainer c2) {
                return (int)(c1.getNextScheduleTime() - c2.getNextScheduleTime());
            }
        }
    }

    private class NonLocalContainerAssigner
    extends ContainerAssigner {
        NonLocalContainerAssigner() {
            super("NonLocal");
        }

        @Override
        public CookieContainerRequest assignNewContainer(Container container) {
            String location = "*";
            CookieContainerRequest assigned = TaskScheduler.this.getMatchingRequestWithPriority(container, location);
            this.doBookKeepingForAssignedContainer(assigned, container, location, false);
            return assigned;
        }

        @Override
        public CookieContainerRequest assignReUsedContainer(Container container, boolean honorLocality) {
            if (!honorLocality) {
                String location = "*";
                CookieContainerRequest assigned = TaskScheduler.this.getMatchingRequestWithoutPriority(container, location);
                this.doBookKeepingForAssignedContainer(assigned, container, location, honorLocality);
                return assigned;
            }
            return null;
        }
    }

    private class RackLocalContainerAssigner
    extends ContainerAssigner {
        RackLocalContainerAssigner() {
            super("RackLocal");
        }

        @Override
        public CookieContainerRequest assignNewContainer(Container container) {
            String location = RackResolver.resolve((String)container.getNodeId().getHost()).getNetworkLocation();
            CookieContainerRequest assigned = TaskScheduler.this.getMatchingRequestWithPriority(container, location);
            this.doBookKeepingForAssignedContainer(assigned, container, location, false);
            return assigned;
        }

        @Override
        public CookieContainerRequest assignReUsedContainer(Container container, boolean honorLocality) {
            if (!honorLocality) {
                String location = RackResolver.resolve((String)container.getNodeId().getHost()).getNetworkLocation();
                CookieContainerRequest assigned = TaskScheduler.this.getMatchingRequestWithoutPriority(container, location);
                this.doBookKeepingForAssignedContainer(assigned, container, location, honorLocality);
                return assigned;
            }
            return null;
        }
    }

    private class NodeLocalContainerAssigner
    extends ContainerAssigner {
        NodeLocalContainerAssigner() {
            super("NodeLocal");
        }

        @Override
        public CookieContainerRequest assignNewContainer(Container container) {
            String location = container.getNodeId().getHost();
            CookieContainerRequest assigned = TaskScheduler.this.getMatchingRequestWithPriority(container, location);
            this.doBookKeepingForAssignedContainer(assigned, container, location, false);
            return assigned;
        }

        @Override
        public CookieContainerRequest assignReUsedContainer(Container container, boolean honorLocality) {
            String location = container.getNodeId().getHost();
            CookieContainerRequest assigned = TaskScheduler.this.getMatchingRequestWithoutPriority(container, location);
            this.doBookKeepingForAssignedContainer(assigned, container, location, true);
            return assigned;
        }
    }

    private abstract class ContainerAssigner {
        protected final String locality;

        protected ContainerAssigner(String locality) {
            this.locality = locality;
        }

        public abstract CookieContainerRequest assignNewContainer(Container var1);

        public abstract CookieContainerRequest assignReUsedContainer(Container var1, boolean var2);

        public void doBookKeepingForAssignedContainer(CookieContainerRequest assigned, Container container, String matchedLocation, boolean honorLocalityFlags) {
            if (assigned == null) {
                return;
            }
            Object task = TaskScheduler.this.getTask(assigned);
            assert (task != null);
            LOG.info((Object)("Assigning container to task, container=" + container + ", task=" + task + ", containerHost=" + container.getNodeId().getHost() + ", localityMatchType=" + this.locality + ", matchedLocation=" + matchedLocation + ", honorLocalityFlags=" + honorLocalityFlags + ", reusedContainer=" + TaskScheduler.this.containerAssignments.containsKey(container.getId()) + ", delayedContainers=" + TaskScheduler.this.delayedContainerManager.delayedContainers.size() + ", containerResourceMemory=" + container.getResource().getMemory() + ", containerResourceVCores=" + container.getResource().getVirtualCores()));
            TaskScheduler.this.assignContainer(task, container, assigned);
        }
    }

    class CookieContainerRequest
    extends AMRMClient.ContainerRequest {
        CRCookie cookie;

        public CookieContainerRequest(Resource capability, String[] hosts, String[] racks, Priority priority, CRCookie cookie) {
            super(capability, hosts, racks, priority);
            this.cookie = cookie;
        }

        CRCookie getCookie() {
            return this.cookie;
        }
    }

    class CRCookie {
        private Object task;
        private Object appCookie;
        private Object containerSignature;

        CRCookie(Object task, Object appCookie, Object containerSignature) {
            this.task = task;
            this.appCookie = appCookie;
            this.containerSignature = containerSignature;
        }

        Object getTask() {
            return this.task;
        }

        Object getAppCookie() {
            return this.appCookie;
        }

        Object getContainerSignature() {
            return this.containerSignature;
        }
    }

    public static interface TaskSchedulerAppCallback {
        public void taskAllocated(Object var1, Object var2, Container var3);

        public void containerCompleted(Object var1, ContainerStatus var2);

        public void containerBeingReleased(ContainerId var1);

        public void nodesUpdated(List<NodeReport> var1);

        public void appShutdownRequested();

        public void setApplicationRegistrationData(Resource var1, Map<ApplicationAccessType, String> var2, ByteBuffer var3);

        public void onError(Throwable var1);

        public float getProgress();

        public void preemptContainer(ContainerId var1);

        public AppFinalStatus getFinalAppStatus();

        public static class AppFinalStatus {
            public final FinalApplicationStatus exitStatus;
            public final String exitMessage;
            public final String postCompletionTrackingUrl;

            public AppFinalStatus(FinalApplicationStatus exitStatus, String exitMessage, String posCompletionTrackingUrl) {
                this.exitStatus = exitStatus;
                this.exitMessage = exitMessage;
                this.postCompletionTrackingUrl = posCompletionTrackingUrl;
            }
        }
    }
}

