/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.ATSService;
import org.apache.tez.dag.history.recovery.RecoveryService;
import org.apache.tez.dag.records.TezDAGID;

public class HistoryEventHandler
extends CompositeService {
    private static Log LOG = LogFactory.getLog(HistoryEventHandler.class);
    private final AppContext context;
    private boolean yarnATSEnabled;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private ATSService atsService;
    private RecoveryService recoveryService;
    private boolean recoveryEnabled;

    public HistoryEventHandler(AppContext context) {
        super(HistoryEventHandler.class.getName());
        this.context = context;
    }

    public void serviceInit(Configuration conf) throws Exception {
        LOG.info((Object)"Initializing HistoryEventHandler");
        this.yarnATSEnabled = this.context.getAMConf().getBoolean("tez.yarn.ats.enabled", false);
        this.recoveryEnabled = this.context.getAMConf().getBoolean("tez.dag.recovery.enabled", false);
        if (this.yarnATSEnabled) {
            this.atsService = new ATSService();
            this.addService((Service)this.atsService);
        }
        if (this.recoveryEnabled) {
            this.recoveryService = new RecoveryService(this.context);
            this.addService((Service)this.recoveryService);
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        LOG.info((Object)"Starting HistoryEventHandler");
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        LOG.info((Object)"Stopping HistoryEventHandler");
        super.serviceStop();
    }

    public void handle(DAGHistoryEvent event) {
        TezDAGID dagId = event.getDagID();
        String dagIdStr = "N/A";
        if (dagId != null) {
            dagIdStr = dagId.toString();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling history event, eventType=" + (Object)((Object)event.getHistoryEvent().getEventType())));
        }
        if (this.recoveryEnabled && event.getHistoryEvent().isRecoveryEvent()) {
            this.recoveryService.handle(event);
        }
        if (this.yarnATSEnabled && event.getHistoryEvent().isHistoryEvent()) {
            this.atsService.handle(event);
        }
        LOG.info((Object)("[HISTORY][DAG:" + dagIdStr + "]" + "[Event:" + ((HistoryEventType)event.getType()).name() + "]" + ": " + event.getHistoryEvent().toString()));
    }
}

