/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.ats;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;

public class ATSService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(ATSService.class);
    private LinkedBlockingQueue<DAGHistoryEvent> eventQueue = new LinkedBlockingQueue();
    private final AtomicInteger historyCounter = new AtomicInteger(0);
    private String outputFilePrefix;
    private Thread eventHandlingThread;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private int eventCounter = 0;
    private int eventsProcessed = 0;
    private final Object lock = new Object();

    public ATSService() {
        super(ATSService.class.getName());
    }

    public void serviceInit(Configuration conf) throws Exception {
        LOG.info((Object)"Initializing ATSService");
    }

    public void serviceStart() {
        LOG.info((Object)"Starting ATSService");
        this.eventHandlingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ATSService.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                    DAGHistoryEvent event;
                    if (ATSService.this.eventCounter != 0 && ATSService.this.eventCounter % 1000 == 0) {
                        LOG.info((Object)("Event queue stats, eventsProcessedSinceLastUpdate=" + ATSService.this.eventsProcessed + ", eventQueueSize=" + ATSService.this.eventQueue.size()));
                        ATSService.this.eventCounter = 0;
                        ATSService.this.eventsProcessed = 0;
                    } else {
                        ++ATSService.this.eventCounter;
                    }
                    try {
                        event = (DAGHistoryEvent)((Object)ATSService.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"EventQueue take interrupted. Returning");
                        return;
                    }
                    Object object = ATSService.this.lock;
                    synchronized (object) {
                        ++ATSService.this.eventsProcessed;
                        try {
                            ATSService.this.handleEvent(event);
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Error handling event", (Throwable)e);
                        }
                    }
                }
            }
        }, "HistoryEventHandlingThread");
        this.eventHandlingThread.start();
    }

    public void serviceStop() {
        LOG.info((Object)"Stopping ATSService");
        this.stopped.set(true);
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
    }

    public void handle(DAGHistoryEvent event) {
        this.eventQueue.add(event);
    }

    private void handleEvent(DAGHistoryEvent event) {
        HistoryEventType eventType = event.getHistoryEvent().getEventType();
    }
}

