/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.dag.utils.ProtoUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DAGSubmittedEvent
implements HistoryEvent,
SummaryEvent {
    private TezDAGID dagID;
    private long submitTime;
    private DAGProtos.DAGPlan dagPlan;
    private ApplicationAttemptId applicationAttemptId;

    public DAGSubmittedEvent() {
    }

    public DAGSubmittedEvent(TezDAGID dagID, long submitTime, DAGProtos.DAGPlan dagPlan, ApplicationAttemptId applicationAttemptId) {
        this.dagID = dagID;
        this.submitTime = submitTime;
        this.dagPlan = dagPlan;
        this.applicationAttemptId = applicationAttemptId;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_SUBMITTED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.dagID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject tezAppEntity = new JSONObject();
        tezAppEntity.put("entity", (Object)("tez_" + this.applicationAttemptId.toString()));
        tezAppEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)this.applicationAttemptId.getApplicationId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)this.applicationAttemptId.toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        relatedEntities.put((Object)tezAppEntity);
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONObject primaryFilters = new JSONObject();
        primaryFilters.put("dagName", (Object)this.dagPlan.getName());
        jsonObject.put("primaryfilters", (Object)primaryFilters);
        JSONArray events = new JSONArray();
        JSONObject submitEvent = new JSONObject();
        submitEvent.put("ts", this.submitTime);
        submitEvent.put("eventtype", (Object)HistoryEventType.DAG_SUBMITTED.name());
        events.put((Object)submitEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("dagPlan", (Object)DAGUtils.generateSimpleJSONPlan(this.dagPlan));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.DAGSubmittedProto toProto() {
        return RecoveryProtos.DAGSubmittedProto.newBuilder().setDagId(this.dagID.toString()).setApplicationAttemptId(this.applicationAttemptId.toString()).setDagPlan(this.dagPlan).setSubmitTime(this.submitTime).build();
    }

    public void fromProto(RecoveryProtos.DAGSubmittedProto proto) {
        this.dagID = TezDAGID.fromString((String)proto.getDagId());
        this.dagPlan = proto.getDagPlan();
        this.submitTime = proto.getSubmitTime();
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.DAGSubmittedProto proto = RecoveryProtos.DAGSubmittedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "dagID=" + this.dagID + ", submitTime=" + this.submitTime;
    }

    @Override
    public void toSummaryProtoStream(OutputStream outputStream) throws IOException {
        ProtoUtils.toSummaryEventProto(this.dagID, this.submitTime, HistoryEventType.DAG_SUBMITTED).writeDelimitedTo(outputStream);
    }

    public String getDAGName() {
        if (this.dagPlan != null && this.dagPlan.hasName()) {
            return this.dagPlan.getName();
        }
        return null;
    }

    public DAGProtos.DAGPlan getDAGPlan() {
        return this.dagPlan;
    }
}

