/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TaskFinishedEvent
implements HistoryEvent {
    private TezTaskID taskID;
    private String vertexName;
    private long startTime;
    private long finishTime;
    private TaskState state;
    private TezCounters tezCounters;

    public TaskFinishedEvent(TezTaskID taskID, String vertexName, long startTime, long finishTime, TaskState state, TezCounters counters) {
        this.vertexName = vertexName;
        this.taskID = taskID;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.tezCounters = counters;
    }

    public TaskFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_FINISHED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.taskID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", this.finishTime);
        finishEvent.put("eventtype", (Object)HistoryEventType.TASK_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", this.startTime);
        otherInfo.put("endTime", this.finishTime);
        otherInfo.put("timeTaken", this.finishTime - this.startTime);
        otherInfo.put("status", (Object)this.state.name());
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(this.tezCounters));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskFinishedProto toProto() {
        return RecoveryProtos.TaskFinishedProto.newBuilder().setTaskId(this.taskID.toString()).setState(this.state.ordinal()).setFinishTime(this.finishTime).setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters)).build();
    }

    public void fromProto(RecoveryProtos.TaskFinishedProto proto) {
        this.taskID = TezTaskID.fromString((String)proto.getTaskId());
        this.finishTime = proto.getFinishTime();
        this.state = TaskState.values()[proto.getState()];
        this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskFinishedProto proto = RecoveryProtos.TaskFinishedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskId=" + this.taskID + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", counters=" + this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }
}

