/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexFinishedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private String vertexName;
    private long initRequestedTime;
    private long initedTime;
    private long startRequestedTime;
    private long startTime;
    private long finishTime;
    private VertexStatus.State state;
    private String diagnostics;
    private TezCounters tezCounters;

    public VertexFinishedEvent(TezVertexID vertexId, String vertexName, long initRequestedTime, long initedTime, long startRequestedTime, long startedTime, long finishTime, VertexStatus.State state, String diagnostics, TezCounters counters) {
        this.vertexName = vertexName;
        this.vertexID = vertexId;
        this.initRequestedTime = initRequestedTime;
        this.initedTime = initedTime;
        this.startRequestedTime = startRequestedTime;
        this.startTime = startedTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    public VertexFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_FINISHED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.vertexID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", this.finishTime);
        finishEvent.put("eventtype", (Object)HistoryEventType.VERTEX_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("endTime", this.finishTime);
        otherInfo.put("timeTaken", this.finishTime - this.startTime);
        otherInfo.put("status", (Object)this.state.name());
        otherInfo.put("diagnostics", (Object)this.diagnostics);
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(this.tezCounters));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexFinishedProto toProto() {
        return RecoveryProtos.VertexFinishedProto.newBuilder().setVertexName(this.vertexName).setVertexId(this.vertexID.toString()).setState(this.state.ordinal()).setDiagnostics(this.diagnostics).setFinishTime(this.finishTime).setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters)).build();
    }

    public void fromProto(RecoveryProtos.VertexFinishedProto proto) {
        this.vertexName = proto.getVertexName();
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.finishTime = proto.getFinishTime();
        this.state = VertexStatus.State.values()[proto.getState()];
        this.diagnostics = proto.getDiagnostics();
        this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexFinishedProto proto = RecoveryProtos.VertexFinishedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", vertexId=" + this.vertexID + ", initRequestedTime=" + this.initRequestedTime + ", initedTime=" + this.initedTime + ", startRequestedTime=" + this.startRequestedTime + ", startedTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", diagnostics=" + this.diagnostics + ", counters=" + this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }
}

