/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexInitializedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private String vertexName;
    private long initRequestedTime;
    private long initedTime;
    private long numTasks;
    private String processorName;

    public VertexInitializedEvent() {
    }

    public VertexInitializedEvent(TezVertexID vertexId, String vertexName, long initRequestedTime, long initedTime, long numTasks, String processorName) {
        this.vertexName = vertexName;
        this.vertexID = vertexId;
        this.initRequestedTime = initRequestedTime;
        this.initedTime = initedTime;
        this.numTasks = numTasks;
        this.processorName = processorName;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_INITIALIZED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.vertexID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)this.vertexID.getDAGId().toString());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", this.initedTime);
        initEvent.put("eventtype", (Object)HistoryEventType.VERTEX_INITIALIZED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("vertexName", (Object)this.vertexName);
        otherInfo.put("initRequestedTime", this.initRequestedTime);
        otherInfo.put("initTime", this.initedTime);
        otherInfo.put("numTasks", this.numTasks);
        otherInfo.put("processorClassName", (Object)this.processorName);
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexInitializedProto toProto() {
        return RecoveryProtos.VertexInitializedProto.newBuilder().setVertexId(this.vertexID.toString()).setVertexName(this.vertexName).setInitRequestedTime(this.initRequestedTime).setInitTime(this.initedTime).setNumTasks(this.numTasks).build();
    }

    public void fromProto(RecoveryProtos.VertexInitializedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.vertexName = proto.getVertexName();
        this.initRequestedTime = proto.getInitRequestedTime();
        this.initedTime = proto.getInitTime();
        this.numTasks = proto.getNumTasks();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexInitializedProto proto = RecoveryProtos.VertexInitializedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", vertexId=" + this.vertexID + ", initRequestedTime=" + this.initRequestedTime + ", initedTime=" + this.initedTime + ", numTasks=" + this.numTasks + ", processorName=" + this.processorName;
    }
}

