/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexStartedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private long startRequestedTime;
    private long startTime;

    public VertexStartedEvent() {
    }

    public VertexStartedEvent(TezVertexID vertexId, long startRequestedTime, long startTime) {
        this.vertexID = vertexId;
        this.startRequestedTime = startRequestedTime;
        this.startTime = startTime;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_STARTED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.vertexID.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)this.vertexID.getDAGId().toString());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", this.startTime);
        startEvent.put("eventtype", (Object)HistoryEventType.VERTEX_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startRequestedTime", this.startRequestedTime);
        otherInfo.put("startTime", this.startTime);
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexStartedProto toProto() {
        return RecoveryProtos.VertexStartedProto.newBuilder().setVertexId(this.vertexID.toString()).setStartRequestedTime(this.startRequestedTime).setStartTime(this.startTime).build();
    }

    public void fromProto(RecoveryProtos.VertexStartedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.startRequestedTime = proto.getStartRequestedTime();
        this.startTime = proto.getStartTime();
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexStartedProto proto = RecoveryProtos.VertexStartedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID + ", startRequestedTime=" + this.startRequestedTime + ", startedTime=" + this.startTime;
    }
}

