/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.rpc;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.util.List;
import java.util.Map;
import org.apache.tez.client.TezSessionStatus;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.DAGStatusBuilder;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.DAGAppMaster;

public class DAGClientAMProtocolBlockingPBServerImpl
implements DAGClientAMProtocolBlockingPB {
    DAGAppMaster.DAGClientHandler real;

    public DAGClientAMProtocolBlockingPBServerImpl(DAGAppMaster.DAGClientHandler real) {
        this.real = real;
    }

    public DAGClientAMProtocolRPC.GetAllDAGsResponseProto getAllDAGs(RpcController controller, DAGClientAMProtocolRPC.GetAllDAGsRequestProto request) throws ServiceException {
        try {
            List<String> dagIds = this.real.getAllDAGs();
            return DAGClientAMProtocolRPC.GetAllDAGsResponseProto.newBuilder().addAllDagId(dagIds).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.GetDAGStatusResponseProto getDAGStatus(RpcController controller, DAGClientAMProtocolRPC.GetDAGStatusRequestProto request) throws ServiceException {
        try {
            String dagId = request.getDagId();
            DAGStatus status = this.real.getDAGStatus(dagId, DagTypeConverters.convertStatusGetOptsFromProto((List)request.getStatusOptionsList()));
            assert (status instanceof DAGStatusBuilder);
            DAGStatusBuilder builder = (DAGStatusBuilder)status;
            return DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(builder.getProto()).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.GetVertexStatusResponseProto getVertexStatus(RpcController controller, DAGClientAMProtocolRPC.GetVertexStatusRequestProto request) throws ServiceException {
        try {
            String dagId = request.getDagId();
            String vertexName = request.getVertexName();
            VertexStatus status = this.real.getVertexStatus(dagId, vertexName, DagTypeConverters.convertStatusGetOptsFromProto((List)request.getStatusOptionsList()));
            assert (status instanceof VertexStatusBuilder);
            VertexStatusBuilder builder = (VertexStatusBuilder)status;
            return DAGClientAMProtocolRPC.GetVertexStatusResponseProto.newBuilder().setVertexStatus(builder.getProto()).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.TryKillDAGResponseProto tryKillDAG(RpcController controller, DAGClientAMProtocolRPC.TryKillDAGRequestProto request) throws ServiceException {
        try {
            String dagId = request.getDagId();
            this.real.tryKillDAG(dagId);
            return DAGClientAMProtocolRPC.TryKillDAGResponseProto.newBuilder().build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.SubmitDAGResponseProto submitDAG(RpcController controller, DAGClientAMProtocolRPC.SubmitDAGRequestProto request) throws ServiceException {
        try {
            DAGProtos.DAGPlan dagPlan = request.getDAGPlan();
            Map additionalResources = null;
            if (request.hasAdditionalAmResources()) {
                additionalResources = DagTypeConverters.convertFromPlanLocalResources((DAGProtos.PlanLocalResourcesProto)request.getAdditionalAmResources());
            }
            String dagId = this.real.submitDAG(dagPlan, additionalResources);
            return DAGClientAMProtocolRPC.SubmitDAGResponseProto.newBuilder().setDagId(dagId).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    ServiceException wrapException(Exception e) {
        return new ServiceException((Throwable)e);
    }

    public DAGClientAMProtocolRPC.ShutdownSessionResponseProto shutdownSession(RpcController arg0, DAGClientAMProtocolRPC.ShutdownSessionRequestProto arg1) throws ServiceException {
        this.real.shutdownAM();
        return DAGClientAMProtocolRPC.ShutdownSessionResponseProto.newBuilder().build();
    }

    public DAGClientAMProtocolRPC.GetAMStatusResponseProto getAMStatus(RpcController controller, DAGClientAMProtocolRPC.GetAMStatusRequestProto request) throws ServiceException {
        try {
            TezSessionStatus sessionStatus = this.real.getSessionStatus();
            return DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DagTypeConverters.convertTezSessionStatusToProto((TezSessionStatus)sessionStatus)).build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }

    public DAGClientAMProtocolRPC.PreWarmResponseProto preWarm(RpcController controller, DAGClientAMProtocolRPC.PreWarmRequestProto request) throws ServiceException {
        try {
            this.real.preWarmContainers(DagTypeConverters.convertPreWarmContextFromProto((DAGProtos.PreWarmContextProto)request.getPreWarmContext()));
            return DAGClientAMProtocolRPC.PreWarmResponseProto.newBuilder().build();
        }
        catch (TezException e) {
            throw this.wrapException((Exception)((Object)e));
        }
    }
}

