/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VertexParallelismUpdatedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private int numTasks;
    private VertexLocationHint vertexLocationHint;
    private Map<String, EdgeManagerDescriptor> sourceEdgeManagers;

    public VertexParallelismUpdatedEvent() {
    }

    public VertexParallelismUpdatedEvent(TezVertexID vertexID, int numTasks, VertexLocationHint vertexLocationHint, Map<String, EdgeManagerDescriptor> sourceEdgeManagers) {
        this.vertexID = vertexID;
        this.numTasks = numTasks;
        this.vertexLocationHint = vertexLocationHint;
        this.sourceEdgeManagers = sourceEdgeManagers;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_PARALLELISM_UPDATED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        throw new UnsupportedOperationException("VertexParallelismUpdatedEvent not a History event");
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return false;
    }

    public RecoveryProtos.VertexParallelismUpdatedProto toProto() {
        RecoveryProtos.VertexParallelismUpdatedProto.Builder builder = RecoveryProtos.VertexParallelismUpdatedProto.newBuilder();
        builder.setVertexId(this.vertexID.toString()).setNumTasks(this.numTasks);
        if (this.vertexLocationHint != null) {
            builder.setVertexLocationHint(DagTypeConverters.convertVertexLocationHintToProto((VertexLocationHint)this.vertexLocationHint));
        }
        if (this.sourceEdgeManagers != null) {
            for (Map.Entry<String, EdgeManagerDescriptor> entry : this.sourceEdgeManagers.entrySet()) {
                RecoveryProtos.EdgeManagerDescriptorProto.Builder edgeMgrBuilder = RecoveryProtos.EdgeManagerDescriptorProto.newBuilder();
                edgeMgrBuilder.setEdgeName(entry.getKey());
                edgeMgrBuilder.setEntityDescriptor(DagTypeConverters.convertToDAGPlan((TezEntityDescriptor)((TezEntityDescriptor)entry.getValue())));
                builder.addEdgeManagerDescriptors(edgeMgrBuilder.build());
            }
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.VertexParallelismUpdatedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.numTasks = proto.getNumTasks();
        if (proto.hasVertexLocationHint()) {
            this.vertexLocationHint = DagTypeConverters.convertVertexLocationHintFromProto((DAGProtos.VertexLocationHintProto)proto.getVertexLocationHint());
        }
        if (proto.getEdgeManagerDescriptorsCount() > 0) {
            this.sourceEdgeManagers = new HashMap<String, EdgeManagerDescriptor>(proto.getEdgeManagerDescriptorsCount());
            for (RecoveryProtos.EdgeManagerDescriptorProto edgeManagerProto : proto.getEdgeManagerDescriptorsList()) {
                EdgeManagerDescriptor edgeManagerDescriptor = DagTypeConverters.convertEdgeManagerDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)edgeManagerProto.getEntityDescriptor());
                this.sourceEdgeManagers.put(edgeManagerProto.getEdgeName(), edgeManagerDescriptor);
            }
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexParallelismUpdatedProto proto = RecoveryProtos.VertexParallelismUpdatedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID + ", numTasks=" + this.numTasks + ", vertexLocationHint=" + (this.vertexLocationHint == null ? "null" : this.vertexLocationHint) + ", edgeManagersCount=" + (this.sourceEdgeManagers == null ? "null" : Integer.valueOf(this.sourceEdgeManagers.size()));
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public VertexLocationHint getVertexLocationHint() {
        return this.vertexLocationHint;
    }

    public Map<String, EdgeManagerDescriptor> getSourceEdgeManagers() {
        return this.sourceEdgeManagers;
    }
}

