/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.HeartbeatHandlerBase;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;

public class ContainerHeartbeatHandler
extends HeartbeatHandlerBase<ContainerId> {
    public ContainerHeartbeatHandler(AppContext context, int expectedConcurrency) {
        super(context, expectedConcurrency, "ContainerHeartbeatHandler");
    }

    @Override
    protected int getConfiguredTimeout(Configuration conf) {
        return conf.getInt("tez.task.timeout", 300000);
    }

    @Override
    protected int getConfiguredTimeoutCheckInterval(Configuration conf) {
        return conf.getInt("tez.task.heartbeat.timeout-ms", 30000);
    }

    @Override
    protected boolean hasTimedOut(HeartbeatHandlerBase.ReportTime report, long currentTime) {
        return this.timeOut > 0 && currentTime > report.getLastPing() + (long)this.timeOut;
    }

    @Override
    protected void handleTimeOut(ContainerId containerId) {
        this.eventHandler.handle((Event)new AMContainerEvent(containerId, AMContainerEventType.C_TIMED_OUT));
    }
}

