/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.ats.EntityTypes;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private TezTaskAttemptID taskAttemptId;
    private String vertexName;
    private long startTime;
    private long finishTime;
    private TaskAttemptState state;
    private String diagnostics;
    private TezCounters tezCounters;

    public TaskAttemptFinishedEvent(TezTaskAttemptID taId, String vertexName, long startTime, long finishTime, TaskAttemptState state, String diagnostics, TezCounters counters) {
        this.taskAttemptId = taId;
        this.vertexName = vertexName;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    public TaskAttemptFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_FINISHED;
    }

    @Override
    public JSONObject convertToATSJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)this.taskAttemptId.toString());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", this.finishTime);
        finishEvent.put("eventtype", (Object)HistoryEventType.TASK_ATTEMPT_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", this.startTime);
        otherInfo.put("endTime", this.finishTime);
        otherInfo.put("timeTaken", this.finishTime - this.startTime);
        otherInfo.put("status", (Object)this.state.name());
        otherInfo.put("diagnostics", (Object)this.diagnostics);
        otherInfo.put("counters", (Object)DAGUtils.convertCountersToJSON(this.tezCounters));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskAttemptFinishedProto toProto() {
        RecoveryProtos.TaskAttemptFinishedProto.Builder builder = RecoveryProtos.TaskAttemptFinishedProto.newBuilder();
        builder.setTaskAttemptId(this.taskAttemptId.toString()).setState(this.state.ordinal()).setFinishTime(this.finishTime);
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.tezCounters != null) {
            builder.setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters));
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.TaskAttemptFinishedProto proto) {
        this.taskAttemptId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        this.finishTime = proto.getFinishTime();
        this.state = TaskAttemptState.values()[proto.getState()];
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasCounters()) {
            this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskAttemptFinishedProto proto = RecoveryProtos.TaskAttemptFinishedProto.parseDelimitedFrom(inputStream);
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskAttemptId=" + this.taskAttemptId + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", diagnostics=" + this.diagnostics + ", counters=" + (this.tezCounters == null ? "null" : this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " "));
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public TezCounters getCounters() {
        return this.tezCounters;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public TaskAttemptState getState() {
        return this.state;
    }
}

