/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.RuntimeUtils;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputFailed;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputInitialized;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.app.dag.impl.TezRootInputInitializerContextImpl;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TezRootInputInitializer;
import org.apache.tez.runtime.api.TezRootInputInitializerContext;

public class RootInputInitializerRunner {
    private static final Log LOG = LogFactory.getLog(RootInputInitializerRunner.class);
    private final ExecutorService rawExecutor;
    private final ListeningExecutorService executor;
    private final String dagName;
    private final String vertexName;
    private final TezVertexID vertexID;
    private final int numTasks;
    private final Resource vertexTaskResource;
    private final Resource totalResource;
    private final EventHandler eventHandler;
    private volatile boolean isStopped = false;
    private final UserGroupInformation dagUgi;
    private final int numClusterNodes;
    private final int dagAttemptNumber;

    public RootInputInitializerRunner(String dagName, String vertexName, TezVertexID vertexID, EventHandler eventHandler, UserGroupInformation dagUgi, Resource vertexTaskResource, Resource totalResource, int numTasks, int numNodes, int dagAttemptNumber) {
        this.dagName = dagName;
        this.vertexName = vertexName;
        this.vertexID = vertexID;
        this.eventHandler = eventHandler;
        this.vertexTaskResource = vertexTaskResource;
        this.totalResource = totalResource;
        this.numTasks = numTasks;
        this.rawExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("InputInitializer [" + this.vertexName + "] #%d").build());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)this.rawExecutor);
        this.dagUgi = dagUgi;
        this.numClusterNodes = numNodes;
        this.dagAttemptNumber = dagAttemptNumber;
    }

    public void runInputInitializers(List<RootInputLeafOutputDescriptor<InputDescriptor>> inputs) {
        for (RootInputLeafOutputDescriptor<InputDescriptor> input : inputs) {
            ListenableFuture future = this.executor.submit((Callable)new InputInitializerCallable(input, this.vertexID, this.dagName, this.vertexName, this.dagUgi, this.numTasks, this.numClusterNodes, this.vertexTaskResource, this.totalResource, this.dagAttemptNumber));
            Futures.addCallback((ListenableFuture)future, (FutureCallback)this.createInputInitializerCallback(input.getEntityName()));
        }
    }

    @VisibleForTesting
    protected InputInitializerCallback createInputInitializerCallback(String entityName) {
        return new InputInitializerCallback(entityName, this.eventHandler, this.vertexID);
    }

    public void shutdown() {
        if (this.executor != null && !this.isStopped) {
            this.executor.shutdownNow();
            this.isStopped = true;
        }
    }

    @VisibleForTesting
    private static class InputInitializerCallback
    implements FutureCallback<List<org.apache.tez.runtime.api.Event>> {
        private final String inputName;
        private final EventHandler eventHandler;
        private final TezVertexID vertexID;

        public InputInitializerCallback(String inputName, EventHandler eventHandler, TezVertexID vertexID) {
            this.inputName = inputName;
            this.eventHandler = eventHandler;
            this.vertexID = vertexID;
        }

        public void onSuccess(List<org.apache.tez.runtime.api.Event> result) {
            this.eventHandler.handle((Event)new VertexEventRootInputInitialized(this.vertexID, this.inputName, result));
        }

        public void onFailure(Throwable t) {
            this.eventHandler.handle((Event)new VertexEventRootInputFailed(this.vertexID, this.inputName, t));
        }
    }

    private static class InputInitializerCallable
    implements Callable<List<org.apache.tez.runtime.api.Event>> {
        private final RootInputLeafOutputDescriptor<InputDescriptor> input;
        private final TezVertexID vertexID;
        private final String dagName;
        private final String vertexName;
        private final int numTasks;
        private final Resource vertexTaskResource;
        private final Resource totalResource;
        private final UserGroupInformation ugi;
        private final int numClusterNodes;
        private final int dagAttemptNumber;

        public InputInitializerCallable(RootInputLeafOutputDescriptor<InputDescriptor> input, TezVertexID vertexID, String dagName, String vertexName, UserGroupInformation ugi, int numTasks, int numClusterNodes, Resource vertexTaskResource, Resource totalResource, int dagAttemptNumber) {
            this.input = input;
            this.vertexID = vertexID;
            this.dagName = dagName;
            this.vertexName = vertexName;
            this.numTasks = numTasks;
            this.vertexTaskResource = vertexTaskResource;
            this.totalResource = totalResource;
            this.ugi = ugi;
            this.numClusterNodes = numClusterNodes;
            this.dagAttemptNumber = dagAttemptNumber;
        }

        @Override
        public List<org.apache.tez.runtime.api.Event> call() throws Exception {
            List events = (List)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<org.apache.tez.runtime.api.Event>>(){

                @Override
                public List<org.apache.tez.runtime.api.Event> run() throws Exception {
                    TezRootInputInitializer initializer = InputInitializerCallable.this.createInitializer();
                    TezRootInputInitializerContextImpl context = new TezRootInputInitializerContextImpl(InputInitializerCallable.this.vertexID, InputInitializerCallable.this.dagName, InputInitializerCallable.this.vertexName, InputInitializerCallable.this.input.getEntityName(), (InputDescriptor)InputInitializerCallable.this.input.getDescriptor(), InputInitializerCallable.this.numTasks, InputInitializerCallable.this.numClusterNodes, InputInitializerCallable.this.vertexTaskResource, InputInitializerCallable.this.totalResource, InputInitializerCallable.this.dagAttemptNumber);
                    return initializer.initialize((TezRootInputInitializerContext)context);
                }
            });
            return events;
        }

        private TezRootInputInitializer createInitializer() throws InstantiationException, IllegalAccessException {
            String className = this.input.getInitializerClassName();
            Class clazz = RuntimeUtils.getClazz((String)className);
            TezRootInputInitializer initializer = (TezRootInputInitializer)clazz.newInstance();
            return initializer;
        }
    }
}

