/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TezRootInputInitializerContext;

public class TezRootInputInitializerContextImpl
implements TezRootInputInitializerContext {
    private final TezVertexID vertexID;
    private final String dagName;
    private final String inputName;
    private final InputDescriptor inputDescriptor;
    private final int numTasks;
    private final Resource vertexTaskResource;
    private final Resource totalResource;
    private final int numClusterNodes;
    private final int dagAttemptNumber;

    public TezRootInputInitializerContextImpl(TezVertexID vertexID, String dagName, String vertexName, String inputName, InputDescriptor inputDescriptor, int numTasks, int numClusterNodes, Resource vertexTaskResource, Resource totalResource, int dagAttemptNumber) {
        Preconditions.checkNotNull((Object)vertexID, (Object)"vertexID is null");
        Preconditions.checkNotNull((Object)dagName, (Object)"dagName is null");
        Preconditions.checkNotNull((Object)inputName, (Object)"inputName is null");
        Preconditions.checkNotNull((Object)inputDescriptor, (Object)"inputDescriptor is null");
        Preconditions.checkNotNull((Object)vertexTaskResource, (Object)"numTasks is null");
        Preconditions.checkNotNull((Object)totalResource, (Object)"totalResource is null");
        this.vertexID = vertexID;
        this.dagName = dagName;
        this.inputName = inputName;
        this.inputDescriptor = inputDescriptor;
        this.numTasks = numTasks;
        this.vertexTaskResource = vertexTaskResource;
        this.totalResource = totalResource;
        this.numClusterNodes = numClusterNodes;
        this.dagAttemptNumber = dagAttemptNumber;
    }

    public ApplicationId getApplicationId() {
        return this.vertexID.getDAGId().getApplicationId();
    }

    public String getDAGName() {
        return this.dagName;
    }

    public String getInputName() {
        return this.inputName;
    }

    public byte[] getUserPayload() {
        return this.inputDescriptor.getUserPayload();
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public Resource getVertexTaskResource() {
        return this.vertexTaskResource;
    }

    public Resource getTotalAvailableResource() {
        return this.totalResource;
    }

    public int getNumClusterNodes() {
        return this.numClusterNodes;
    }

    public int getDAGAttemptNumber() {
        return this.dagAttemptNumber;
    }
}

